//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * AhX[hXvCgXe[g
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics2D/SpriteState/AddressModeSpriteState.h"
#include "Graphics/Renderer/RenderingDevice.h"

namespace Lamp{

// Nv
const AddressModeSpriteState AddressModeSpriteState::clampState(
	addressModeClamp, addressModeClamp);

// bv
const AddressModeSpriteState AddressModeSpriteState::wrapState(
	addressModeWrap, addressModeWrap);

// ~[
const AddressModeSpriteState AddressModeSpriteState::mirrorState(
	addressModeMirror, addressModeMirror);

// ftHg
const AddressModeSpriteState AddressModeSpriteState::defaultState(clampState);

// AhX[he[u
const String AddressModeSpriteState::addressModeStringTable[] = {
	"Wrap",
	"Clamp",
	"Mirror",
};

//------------------------------------------------------------------------------
// RXgN^
AddressModeSpriteState::AddressModeSpriteState() :
	addressModeU_(addressModeClamp), addressModeV_(addressModeClamp){
}
//------------------------------------------------------------------------------
// RXgN^
AddressModeSpriteState::AddressModeSpriteState(
	AddressMode addressModeU, AddressMode addressModeV) :
	addressModeU_(addressModeU), addressModeV_(addressModeV){
	Assert((addressModeU_ >= 0) && (addressModeU_ < addressModeMax));
	Assert((addressModeV_ >= 0) && (addressModeV_ < addressModeMax));
}
//------------------------------------------------------------------------------
// fXgN^
AddressModeSpriteState::~AddressModeSpriteState(){
}
//------------------------------------------------------------------------------
// `
//------------------------------------------------------------------------------
// Kp
void AddressModeSpriteState::apply(SpriteRenderState* renderState){
	RenderingDevice* device = RenderingDevice::getInstance();
	device->setTextureAddressMode2(0, addressModeU_, addressModeV_);
}
//------------------------------------------------------------------------------
// AhX[h
//------------------------------------------------------------------------------
// AhX[h當ւ̕ϊ
const String& AddressModeSpriteState::addressModeToString(
	AddressMode addressMode){
	Assert((addressMode >= 0) && (addressMode < addressModeMax));
	return addressModeStringTable[addressMode];
}
//------------------------------------------------------------------------------
// 񂩂AhX[hւ̕ϊ
AddressModeSpriteState::AddressMode
	AddressModeSpriteState::addressModeFromString(
	const String& addressModeString){
	for(int i = 0; i < addressModeMax; i++){
		if(addressModeStringTable[i].equals(addressModeString)){
			return AddressMode(i);
		}
	}
	ErrorOut("AddressModeSpriteState::addressModeFromString() " +
		addressModeString);
	return addressModeMax;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
