//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * XvCgsN`
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics2D/Sprite/SpritePicture.h"
#include "Graphics/System/LampGraphics.h"

namespace Lamp{

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
SpritePicture::SpritePicture() :
	size_(DimensionI::zero), d3dTexture_(NULL), referenceCount_(0){
	LampGraphics::addDeviceObjectHolder(this);
}
//------------------------------------------------------------------------------
// fXgN^
SpritePicture::~SpritePicture(){
	Assert(referenceCount_ == 0);
	LampGraphics::removeDeviceObjectHolder(this);
	SafeRelease(d3dTexture_);
}
//------------------------------------------------------------------------------
// Direct3DeNX`
//------------------------------------------------------------------------------
// D3DeNX`̎擾
Direct3DTexture* SpritePicture::getD3DTexture(){
	if(d3dTexture_ == NULL){
		if(!compileD3DTexture()){ return NULL; }
	}
	return d3dTexture_;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
