//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * XvCg_[Xe[g
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics2D/Renderer/SpriteRenderState.h"
#include "Graphics2D/Renderer/SpriteGraphicsBuffer.h"
#include "Graphics2D/Sprite/SpritePicture.h"
#include "Graphics/Renderer/RenderingDevice.h"

namespace Lamp{

//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
SpriteRenderState::SpriteRenderState(SpriteGraphicsBuffer* graphicsBuffer) :
	graphicsBuffer_(graphicsBuffer), picture_(NULL){
	// _[^[QbgTCY擾
	RenderingDevice* device = RenderingDevice::getInstance();
	renderTargetSize_.set(device->getRenderTargetSize());
}
//------------------------------------------------------------------------------
// fXgN^
SpriteRenderState::~SpriteRenderState(){
}
//------------------------------------------------------------------------------
// `
//------------------------------------------------------------------------------
// NGXg
void SpriteRenderState::request(SpritePicture* picture,
	const Point2f& minPosition, const Point2f& maxPosition,
	const TexCoord2& minUV, const TexCoord2& maxUV){
	// sN`ɕύX΃obt@o
	if(picture_ != picture){
		render();
		picture_ = picture;
		RenderingDevice* device = RenderingDevice::getInstance();
		if(picture_ == NULL){
			device->setTexture(0, (Direct3DTexture*)NULL);
		}else{
			device->setTexture(0, picture_->getD3DTexture());
		}
	}
	graphicsBuffer_->request(minPosition, maxPosition, minUV, maxUV);
}
//------------------------------------------------------------------------------
// _O
void SpriteRenderState::render(){
	graphicsBuffer_->render();
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
