//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eNX`
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Texture/Texture.h"
#include "Graphics/Texture/TextureManager.h"
#include "Graphics/Material/Material.h"
#include "Graphics/Picture/Picture.h"

namespace Lamp{

// AhX[he[u
const String Texture::addressModeStringTable[] = {
	"Wrap",
	"Clamp",
	"Mirror",
};

//------------------------------------------------------------------------------
// RXgN^
Texture::Texture(const String& name, Scene* scene) :
	SceneObject(name, scene){
}
//------------------------------------------------------------------------------
// fXgN^
Texture::~Texture(){
}
//------------------------------------------------------------------------------
// eNX`̒lRs[
void Texture::copyTextureValue(Texture* destination, u_int copyMask) const{
	int pictureCount = getPictureCount();
	for(int i = 0; i < pictureCount; i++){
		if((copyMask & copyPicture) == 0){
			// sN`L
			destination->addPicture(getPicture(i));
		}else{
			// sN`Rs[
			destination->addPicture(getPicture(i)->copy());
		}
	}
}
//------------------------------------------------------------------------------
// ċAIj
int Texture::recursiveDestroy(Texture* texture){
	Assert(texture != NULL);
	int result = 0;
	// sN`̔j
	int pictureCount = texture->getPictureCount();
	for(int i = pictureCount - 1; i >= 0; i--){
		Picture* picture = texture->getPicture(i);
		texture->removePicture(picture);
		result += Picture::destroy(picture);
	}
	// ̔j
	TextureManager* manager = texture->getScene()->getTextureManager();
	if(manager->destroy(texture) == 0){ result++; }
	return result;
}
//------------------------------------------------------------------------------
// Xe[gύXtO𗧂Ă
void Texture::stateChanged(){
	int parentCount = getParentCount();
	for(int i = 0; i < parentCount; i++){
		getParent(i)->stateChanged();
	}
}
//------------------------------------------------------------------------------
// AhX[h當ւ̕ϊ
const String& Texture::addressModeToString(AddressMode addressMode){
	Assert(addressMode >= 0);
	Assert(addressMode < addressModeMax);
	return addressModeStringTable[addressMode];
}
//------------------------------------------------------------------------------
// 񂩂AhX[hւ̕ϊ
Texture::AddressMode Texture::addressModeFromString(
	const String& addressModeString){
	for(int i = 0; i < addressModeMax; i++){
		if(addressModeStringTable[i].equals(addressModeString)){
			return AddressMode(i);
		}
	}
	ErrorOut("Texture::addressModeFromString() " + addressModeString);
	return addressModeMax;
}
//------------------------------------------------------------------------------
// sN`t@X̒ǉ
void Texture::addPictureReference(Picture* picture){
	picture->addReference(this);
}
//------------------------------------------------------------------------------
// sN`t@X̍폜
void Texture::removePictureReference(Picture* picture){
	picture->removeReference(this);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
