//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * T[tF[XeNX`
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Texture/SurfaceTexture.h"
#include "Graphics/Scene/Scene.h"
#include "Graphics/Texture/TextureManager.h"
#include "Graphics/Picture/Picture.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
SurfaceTexture::SurfaceTexture(const String& name, Scene* scene) :
	Texture(name, scene), picture_(NULL), addressModeU_(addressModeClamp),
	addressModeV_(addressModeClamp), repeatUV_(1.f, 1.f), offsetUV_(0.f, 0.f){
}
//------------------------------------------------------------------------------
// fXgN^
SurfaceTexture::~SurfaceTexture(){
}
//------------------------------------------------------------------------------
/// T[tF[XeNX`̃Rs[
SurfaceTexture* SurfaceTexture::copySurfaceTexture(u_int copyMask) const{
	TextureManager* manager = scene_->getTextureManager();
	SurfaceTexture* copyTexture =
		manager->createSurfaceTexture(manager->rename(name_));
	// eNX`l̃Rs[
	copyTextureValue(copyTexture, copyMask);
	// õRs[
	copyTexture->setAddressModeU(addressModeU_);
	copyTexture->setAddressModeV(addressModeV_);
	copyTexture->setRepeatUV(repeatUV_);
	copyTexture->setOffsetUV(offsetUV_);
	return copyTexture;
}
//------------------------------------------------------------------------------
// D3DeNX`̎擾
Direct3DTexture* SurfaceTexture::getD3DTexture(){
	Picture* picture = getPicture(0);
	Assert(picture != NULL);
	if(picture == NULL){ return NULL; }
	return picture->getD3DTexture();
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
