//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * LampOtBNX
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Enumeration/GraphicsDeviceEnumeration.h"
#include "Graphics/DeviceSelector/GraphicsDeviceSelector.h"
#include "Graphics/System/GraphicsDeviceSettings.h"
#include "Graphics/DeviceSelector/DesktopGraphicsDeviceSelector.h"
#include "Graphics/System/GraphicsDevice.h"
#include "Graphics/System/GraphicsDeviceCapacity.h"
#include "Graphics/Renderer/RenderingDevice.h"
#include "Graphics/Shader/ShaderManager.h"
#include "Graphics/System/GraphicsDeviceObjectHolder.h"

namespace Lamp{

// EBhEnh
HWND LampGraphics::windowHandle_ = NULL;
// OtBbNXfoCX̗
GraphicsDeviceEnumeration* LampGraphics::enumeration_ = NULL;
// OtBbNXfoCXZN^
GraphicsDeviceSelector* LampGraphics::selector_ = NULL;
// OtBbNXfoCXݒ
GraphicsDeviceSettings* LampGraphics::settings_ = NULL;
// OtBbNXfoCX
GraphicsDevice* LampGraphics::device_ = NULL;
// Direct3DfoCX
Direct3DDevice* LampGraphics::direct3DDevice_ = NULL;
// OtBbNXfoCX\
GraphicsDeviceCapacity* LampGraphics::deviceCapacity_ = NULL;
// _OfoCX
RenderingDevice* LampGraphics::renderingDevice_ = NULL;
// VF[_}l[W
ShaderManager* LampGraphics::shaderManager_ = NULL;
// Direct3D
Direct3D* LampGraphics::direct3D_ = NULL;
// foCXIuWFNgz_
ArrayList<GraphicsDeviceObjectHolder*> LampGraphics::deviceObjectHolders_;

// V[z
ArrayList<Scene*> LampGraphics::sceneArray_(scenesCapacity_);
// V[f[^x[X
HashMap<String, Scene*> LampGraphics::sceneDatabase_(scenesCapacity_, 1.f);

// tO
bool LampGraphics::isInitialized_ = false;
// foCXtO
bool LampGraphics::deviceInitialized_ = false;

//------------------------------------------------------------------------------
// 
void LampGraphics::initialize(){
	if(isInitialized_){ return; }
	LampCore::initialize();
	enumeration_ = new GraphicsDeviceEnumeration();
	selector_ = new DesktopGraphicsDeviceSelector();
	settings_ = new GraphicsDeviceSettings();
	device_ = new GraphicsDevice();
	deviceCapacity_ = new GraphicsDeviceCapacity();
	renderingDevice_ = new RenderingDevice(deviceCapacity_);
	shaderManager_ = new ShaderManager();
	// tOĂ
	isInitialized_ = true;
	return;
}
//------------------------------------------------------------------------------
// foCX̏
bool LampGraphics::initializeDevice(
	HWND windowHandle, bool startFullscreen){
	Assert(isInitialized_);
	if(deviceInitialized_){ return true; }
	windowHandle_ = windowHandle;
	// Direct3D̍쐬
	direct3D_ = Direct3DCreate(D3D_SDK_VERSION);
	if(direct3D_ == NULL){
		ErrorOut("LampGraphics::initialize() Direct3DCreate()");
		return false;
	}
	// OtBbNXfoCX̗񋓂s
	if(!enumeration_->enumerate()){
		ErrorOut("LampGraphics::initialize() Enumerate()");
		return false;
	}
	// foCXݒ̏
	if(!selector_->chooseDeviceSettings(windowHandle_, startFullscreen)){
		ErrorOut("LampGraphics::initialize() chooseDeviceSettings()");
		return false;
	}
	// foCX̏
	device_->initializeWindowHandle(windowHandle_);
	if(!device_->initialize()){
		ErrorOut("LampGraphics::initialize() initializeDevice()");
		return false;
	}
	// foCXtOĂ
	deviceInitialized_ = true;
	return true;
}
//------------------------------------------------------------------------------
// n
void LampGraphics::finalize(){
	// foCX̌n
	device_->cleanup();
	// Direct3D̉
	SafeRelease(direct3D_);
	windowHandle_ = NULL;
	// foCXtONA
	deviceInitialized_ = false;

	// ̌n
	SafeDelete(shaderManager_);
	SafeDelete(renderingDevice_);
	SafeDelete(deviceCapacity_);
	SafeDelete(device_);
	SafeDelete(selector_);
	SafeDelete(settings_);
	SafeDelete(enumeration_);
	// tONA
	isInitialized_ = false;

	// V[f[^x[X̐
	Assert(getSceneCount() == 0);
	if(sceneArray_.getCapacity() != scenesCapacity_){
		sceneArray_.setCapacity(scenesCapacity_);
		sceneDatabase_.setCapacity(scenesCapacity_);
	}
}
//------------------------------------------------------------------------------
// EBhEvV[W
LRESULT LampGraphics::windowProcedure(
	HWND windowHandle, u_int message, WPARAM wParam, LPARAM lParam){
	// foCX̃vV[WĂяo
	return device_->windowProcedure(windowHandle, message, wParam, lParam);
}
//------------------------------------------------------------------------------
// OtBbNXfoCXZN^̐ݒ
void LampGraphics::setDeviceSelector(GraphicsDeviceSelector* selector){
	SafeDelete(selector_);
	selector_ = selector;
}
//------------------------------------------------------------------------------
// foCX֌W
//------------------------------------------------------------------------------
// foCXZbgꂽ
void LampGraphics::deviceReset(){
	direct3DDevice_ = device_->getDirect3DDevice();
	// foCX\͂̃ZbgŗDōs
	deviceCapacity_->deviceReset(direct3DDevice_);
	// ftHgXe[gubN̍\zɍs
	renderingDevice_->restoreDefaultStateBlock(direct3DDevice_);
}
//------------------------------------------------------------------------------
// foCXIuWFNg̏
bool LampGraphics::initializeDeviceObjects(){
	bool result = true;
	int objectHolderCount = getDeviceObjectHolderCount();
	for(int i = 0; i < objectHolderCount; i++){
		GraphicsDeviceObjectHolder* holder = getDeviceObjectHolder(i);
		if(!holder->initializeGraphicsDeviceObjects()){ result = false; }
	}
	return result;
}
//------------------------------------------------------------------------------
// foCXIuWFNg̍폜
void LampGraphics::deleteDeviceObjects(){
	int objectHolderCount = getDeviceObjectHolderCount();
	for(int i = 0; i < objectHolderCount; i++){
		getDeviceObjectHolder(i)->deleteGraphicsDeviceObjects();
	}
}
//------------------------------------------------------------------------------
// foCXIuWFNg̃XgA
bool LampGraphics::restoreDeviceObjects(){
	bool result = true;
	// foCXIuWFNgz_̃XgA
	int objectHolderCount = getDeviceObjectHolderCount();
	for(int i = 0; i < objectHolderCount; i++){
		GraphicsDeviceObjectHolder* holder = getDeviceObjectHolder(i);
		if(!holder->restoreGraphicsDeviceObjects()){ result = false; }
	}
	return result;
}
//------------------------------------------------------------------------------
// foCXIuWFNg̖
void LampGraphics::invalidateDeviceObjects(){
	// foCXIuWFNgz_̖
	int objectHolderCount = getDeviceObjectHolderCount();
	for(int i = 0; i < objectHolderCount; i++){
		getDeviceObjectHolder(i)->invalidateGraphicsDeviceObjects();
	}
	// ftHgXe[gubN̖
	renderingDevice_->invalidateDefaultStateBlock();
}
//------------------------------------------------------------------------------
// V[֌W
//------------------------------------------------------------------------------
// V[̍쐬
Scene* LampGraphics::createScene(const String& name){
	// O̒`FbN
	if(name.getSize() == 0){
		ErrorOut("LampGraphics::createScene() name.getSize() == 0");
		return NULL;
	}
	// Ȍd`FbN
	if(search(name) != NULL){
		ErrorOut("LampGraphics::createScene() repetition name %s",
			name.getBytes());
		return NULL;
	}
	Scene* scene = new Scene(name);
	sceneDatabase_.put(name, scene);
	sceneArray_.add(scene);
	addDeviceObjectHolder(scene);
	return scene;
}
//------------------------------------------------------------------------------
// V[̔j
void LampGraphics::destroyScene(Scene* scene){
	removeDeviceObjectHolder(scene);
	sceneArray_.removeByValue(scene);
	sceneDatabase_.remove(scene->getName());
	delete scene;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
