//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OtBbNXfoCX\͎
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/System/GraphicsDeviceCapacity.h"
#include "Graphics/System/GraphicsDeviceSettings.h"
#include "Graphics/Enumeration/GraphicsAdapterInformation.h"
#include "Graphics/Enumeration/GraphicsDeviceInformation.h"
#include "Graphics/Enumeration/GraphicsDeviceComboInformation.h"
#include "Graphics/System/GraphicsDevice.h"
#include "Graphics/Primitive/GraphicsBufferFormat.h"

namespace Lamp{

// CX^X
GraphicsDeviceCapacity* GraphicsDeviceCapacity::instance_ = NULL;

//------------------------------------------------------------------------------
// RXgN^
GraphicsDeviceCapacity::GraphicsDeviceCapacity(){
	Assert(instance_ == NULL);
	instance_ = this;
}
//------------------------------------------------------------------------------
// fXgN^
GraphicsDeviceCapacity::~GraphicsDeviceCapacity(){
	Assert(instance_ == this);
	instance_ = NULL;
}
//------------------------------------------------------------------------------
// foCXZbgꂽ
void GraphicsDeviceCapacity::deviceReset(Direct3DDevice* direct3DDevice){
	// foCX\͂̍Ď擾
	direct3DDevice->GetDeviceCaps(&capacity_);

	//--------------------------------------------------------------------------
	// foCX
	//--------------------------------------------------------------------------
	GraphicsDeviceSettings* settings = GraphicsDeviceSettings::getInstance();
	GraphicsAdapterInformation* adapterInfo = settings->getAdapterInformation();
	GraphicsDeviceInformation* deviceInfo = settings->getDeviceInformation();
	GraphicsDeviceComboInformation* deviceComboInfo =
		settings->getDeviceComboInformation();
	deviceName_ = adapterInfo->getName();
	driverName_ = adapterInfo->getDriverName();
	// capacity_ɓf[^L
	deviceOrdinal_ = adapterInfo->getAdapterOrdinal();
	Assert(adapterInfo->getAdapterOrdinal() == capacity_.AdapterOrdinal);
	// capacity_ɓf[^L
	deviceType_ = deviceInfo->getDeviceType();
	Assert(deviceInfo->getDeviceType() == capacity_.DeviceType);
	isWindowed_ = settings->isWindowed();
	vertexProcessingType_ = settings->getVertexProcessingType();
	adapterFormat_ = deviceComboInfo->getAdapterFormat();
	backBufferFormat_ = deviceComboInfo->getBackBufferFormat();
	backBufferSize_ = settings->getBackBufferSize();
	refreshRate_ = settings->getDisplayMode().RefreshRate;
	depthStencilEnabled_ = settings->getDepthStencilEnabled();
	depthStencilFormat_ = settings->getDepthStencilFormat();
	presentationInterval_ = settings->getPresentationInterval();
	multiSampleType_ = settings->getMultiSampleType();
	multiSampleQuality_ = settings->getMultiSampleQuality();

	//--------------------------------------------------------------------------
	// foCX\
	//--------------------------------------------------------------------------
	numSimultaneousRTs_ = capacity_.NumSimultaneousRTs;
	executeSystemMemory_ =
		((capacity_.DevCaps & D3DDEVCAPS_EXECUTESYSTEMMEMORY) != 0);
	executeVideoMemory_ =
		((capacity_.DevCaps & D3DDEVCAPS_EXECUTEVIDEOMEMORY) != 0);
	tlVertexSystemMemory_ =
		((capacity_.DevCaps & D3DDEVCAPS_TLVERTEXSYSTEMMEMORY) != 0);
	tlVertexVideoMemory_ =
		((capacity_.DevCaps & D3DDEVCAPS_TLVERTEXVIDEOMEMORY) != 0);
	textureSystemMemory_ =
		((capacity_.DevCaps & D3DDEVCAPS_TEXTURESYSTEMMEMORY) != 0);
	textureVideoMemory_ =
		((capacity_.DevCaps & D3DDEVCAPS_TEXTUREVIDEOMEMORY) != 0);
	drawPrimTlVertex_ =
		((capacity_.DevCaps & D3DDEVCAPS_DRAWPRIMTLVERTEX) != 0);
	canRenderAfterFlip_ =
		((capacity_.DevCaps & D3DDEVCAPS_CANRENDERAFTERFLIP) != 0);
	textureNonLocalVidedMemory_ =
		((capacity_.DevCaps & D3DDEVCAPS_TEXTURENONLOCALVIDMEM) != 0);
	drawPrimitives2_ =
		((capacity_.DevCaps & D3DDEVCAPS_DRAWPRIMITIVES2) != 0);
	separateTextureMemories_ =
		((capacity_.DevCaps & D3DDEVCAPS_SEPARATETEXTUREMEMORIES) != 0);
	drawPrimitives2EX_ =
		((capacity_.DevCaps & D3DDEVCAPS_DRAWPRIMITIVES2EX) != 0);
	hwTransformAndLight_ =
		((capacity_.DevCaps & D3DDEVCAPS_HWTRANSFORMANDLIGHT) != 0);
	canBltSystemToNonLocal_ =
		((capacity_.DevCaps & D3DDEVCAPS_CANBLTSYSTONONLOCAL) != 0);
	hwRasterization_ =
		((capacity_.DevCaps & D3DDEVCAPS_HWRASTERIZATION) != 0);
	pureDevice_ =
		((capacity_.DevCaps & D3DDEVCAPS_PUREDEVICE) != 0);
	quinticRtPatches_ =
		((capacity_.DevCaps & D3DDEVCAPS_QUINTICRTPATCHES) != 0);
	rtPatches_ =
		((capacity_.DevCaps & D3DDEVCAPS_RTPATCHES) != 0);
	rtPatchHanldeZero_ =
		((capacity_.DevCaps & D3DDEVCAPS_RTPATCHHANDLEZERO) != 0);
	nPatches_ =
		((capacity_.DevCaps & D3DDEVCAPS_NPATCHES) != 0);
	presentationIntervalImmediate_ =
		((capacity_.PresentationIntervals &
		D3DPRESENT_INTERVAL_IMMEDIATE) != 0);
	presentationIntervalOne_ =
		((capacity_.PresentationIntervals & D3DPRESENT_INTERVAL_ONE) != 0);
	presentationIntervalTwo_ =
		((capacity_.PresentationIntervals & D3DPRESENT_INTERVAL_TWO) != 0);
	presentationIntervalThree_ =
		((capacity_.PresentationIntervals & D3DPRESENT_INTERVAL_THREE) != 0);
	presentationIntervalFour_ =
		((capacity_.PresentationIntervals & D3DPRESENT_INTERVAL_FOUR) != 0);
	cursorColor_ =
		((capacity_.CursorCaps & D3DCURSORCAPS_COLOR) != 0);
	cursorLowRes_ =
		((capacity_.CursorCaps & D3DCURSORCAPS_LOWRES) != 0);
	stretchRectMinPoint_ =
		((capacity_.StretchRectFilterCaps & D3DPTFILTERCAPS_MINFPOINT) != 0);
	stretchRectMagPoint_ =
		((capacity_.StretchRectFilterCaps & D3DPTFILTERCAPS_MAGFPOINT) != 0);
	stretchRectMinLinear_ =
		((capacity_.StretchRectFilterCaps & D3DPTFILTERCAPS_MINFLINEAR) != 0);
	stretchRectMagLinear_ =
		((capacity_.StretchRectFilterCaps & D3DPTFILTERCAPS_MAGFLINEAR) != 0);

	//--------------------------------------------------------------------------
	// foCX̑
	//--------------------------------------------------------------------------
	masterAdapterOrdinal_ = capacity_.MasterAdapterOrdinal;
	adapterOrdinalInGroup_ = capacity_.AdapterOrdinalInGroup;
	numberOfAdaptersInGroup_ = capacity_.NumberOfAdaptersInGroup;
	maskZ_ =
		((capacity_.PrimitiveMiscCaps & D3DPMISCCAPS_MASKZ) != 0);
	cullNone_ =
		((capacity_.PrimitiveMiscCaps & D3DPMISCCAPS_CULLNONE) != 0);
	cullCW_ =
		((capacity_.PrimitiveMiscCaps & D3DPMISCCAPS_CULLCW) != 0);
	cullCCW_ =
		((capacity_.PrimitiveMiscCaps & D3DPMISCCAPS_CULLCCW) != 0);
	colorWriteEnable_ =
		((capacity_.PrimitiveMiscCaps & D3DPMISCCAPS_COLORWRITEENABLE) != 0);
	clipPlaneScaledPoints_ =
		((capacity_.PrimitiveMiscCaps &
		D3DPMISCCAPS_CLIPPLANESCALEDPOINTS) != 0);
	clipTlVerts_ =
		((capacity_.PrimitiveMiscCaps & D3DPMISCCAPS_CLIPTLVERTS) != 0);
	tssArgTemp_ =
		((capacity_.PrimitiveMiscCaps & D3DPMISCCAPS_TSSARGTEMP) != 0);
	blendOp_ =
		((capacity_.PrimitiveMiscCaps & D3DPMISCCAPS_BLENDOP) != 0);
	nullReference_ =
		((capacity_.PrimitiveMiscCaps & D3DPMISCCAPS_NULLREFERENCE) != 0);
	independentWriteMasks_ =
		((capacity_.PrimitiveMiscCaps &
		D3DPMISCCAPS_INDEPENDENTWRITEMASKS) != 0);
	perStageConstant_ =
		((capacity_.PrimitiveMiscCaps & D3DPMISCCAPS_PERSTAGECONSTANT) != 0);
	fogAndSpecularAlpha_ =
		((capacity_.PrimitiveMiscCaps & D3DPMISCCAPS_FOGANDSPECULARALPHA) != 0);
	separateAlphaBlend_ =
		((capacity_.PrimitiveMiscCaps & D3DPMISCCAPS_SEPARATEALPHABLEND) != 0);
	mrtIndependentBitDepth_ =
		((capacity_.PrimitiveMiscCaps &
		D3DPMISCCAPS_MRTINDEPENDENTBITDEPTHS) != 0);
	mrtPostPixelShaderBlending_ =
		((capacity_.PrimitiveMiscCaps &
		D3DPMISCCAPS_MRTPOSTPIXELSHADERBLENDING) != 0);
	fogVertexClamped_ =
		((capacity_.PrimitiveMiscCaps & D3DPMISCCAPS_FOGVERTEXCLAMPED) != 0);

	//--------------------------------------------------------------------------
	// hCo\
	//--------------------------------------------------------------------------
	readScanLine_ =
		((capacity_.Caps & D3DCAPS_READ_SCANLINE) != 0);
	fullscreenGamma_ =
		((capacity_.Caps2 & D3DCAPS2_FULLSCREENGAMMA) != 0);
	canCalibrateGamma_ =
		((capacity_.Caps2 & D3DCAPS2_CANCALIBRATEGAMMA) != 0);
	canManageResource_ =
		((capacity_.Caps2 & D3DCAPS2_CANMANAGERESOURCE) != 0);
	dynamicTextures_ =
		((capacity_.Caps2 & D3DCAPS2_DYNAMICTEXTURES) != 0);
	canAutogenMipmap_ =
		((capacity_.Caps2 & D3DCAPS2_CANAUTOGENMIPMAP) != 0);
	alphaFullscreenFlipOrDiscard_ =
		((capacity_.Caps3 & D3DCAPS3_ALPHA_FULLSCREEN_FLIP_OR_DISCARD) != 0);
	linerToSrgbPresentation_ =
		((capacity_.Caps3 & D3DCAPS3_LINEAR_TO_SRGB_PRESENTATION) != 0);
	copyToVideoMemory_ =
		((capacity_.Caps3 & D3DCAPS3_COPY_TO_VIDMEM) != 0);
	copyToSystemMemory_ =
		((capacity_.Caps3 & D3DCAPS3_COPY_TO_SYSTEMMEM) != 0);

	//--------------------------------------------------------------------------
	// v~eBu
	//--------------------------------------------------------------------------
	maxPointSize_ = capacity_.MaxPointSize;
	lineTexture_ =		((capacity_.LineCaps & D3DLINECAPS_TEXTURE) != 0);
	lineZTest_ =		((capacity_.LineCaps & D3DLINECAPS_ZTEST) != 0);
	lineBlend_ =		((capacity_.LineCaps & D3DLINECAPS_BLEND) != 0);
	lineAlphaCompare_ =	((capacity_.LineCaps & D3DLINECAPS_ALPHACMP) != 0);
	lineFog_ =			((capacity_.LineCaps & D3DLINECAPS_FOG) != 0);
	lineAntialias_ =	((capacity_.LineCaps & D3DLINECAPS_ANTIALIAS) != 0);

	//--------------------------------------------------------------------------
	// _
	//--------------------------------------------------------------------------
	maxPrimitiveCount_ = capacity_.MaxPrimitiveCount;
	maxVertexIndex_ = capacity_.MaxVertexIndex;
	maxStreams_ = capacity_.MaxStreams;
	maxActiveLights_ = capacity_.MaxActiveLights;
	maxVertexW_ = capacity_.MaxVertexW;
	maxVertexBlendMatrices_ = capacity_.MaxVertexBlendMatrices;
	maxVertexBlendMatrixIndex_ = capacity_.MaxVertexBlendMatrixIndex;
	guardBandLeft_ = capacity_.GuardBandLeft;
	guardBandTop_ = capacity_.GuardBandTop;
	guardBandRight_ = capacity_.GuardBandRight;
	guardBandBottom_ = capacity_.GuardBandBottom;
	maxUserCliplanes_ = capacity_.MaxUserClipPlanes;
	texGen_ =
		((capacity_.VertexProcessingCaps & D3DVTXPCAPS_TEXGEN) != 0);
	materialSource_ =
		((capacity_.VertexProcessingCaps & D3DVTXPCAPS_MATERIALSOURCE7) != 0);
	directionalLights_ =
		((capacity_.VertexProcessingCaps & D3DVTXPCAPS_DIRECTIONALLIGHTS) != 0);
	positionalLights_ =
		((capacity_.VertexProcessingCaps & D3DVTXPCAPS_POSITIONALLIGHTS) != 0);
	localViewer_ =
		((capacity_.VertexProcessingCaps & D3DVTXPCAPS_LOCALVIEWER) != 0);
	tweening_ =
		((capacity_.VertexProcessingCaps & D3DVTXPCAPS_TWEENING) != 0);
	texgenSpheremap_ =
		((capacity_.VertexProcessingCaps & D3DVTXPCAPS_TEXGEN_SPHEREMAP) != 0);
	noTexgenNonLocalViewer_ =
		((capacity_.VertexProcessingCaps &
		D3DVTXPCAPS_NO_TEXGEN_NONLOCALVIEWER) != 0);

	//--------------------------------------------------------------------------
	// _tH[}bg
	//--------------------------------------------------------------------------
	fvfTexCoordCountMask_ =
		((capacity_.FVFCaps & D3DFVFCAPS_TEXCOORDCOUNTMASK) != 0);
	fvfDoNotStripElements_ =
		((capacity_.FVFCaps & D3DFVFCAPS_DONOTSTRIPELEMENTS) != 0);
	fvfPSize_ = ((capacity_.FVFCaps & D3DFVFCAPS_PSIZE) != 0);
	declUByte4_ = ((capacity_.DeclTypes & D3DDTCAPS_UBYTE4) != 0);
	declUByte4N_ = ((capacity_.DeclTypes & D3DDTCAPS_UBYTE4N) != 0);
	declShort2N_ = ((capacity_.DeclTypes & D3DDTCAPS_SHORT2N) != 0);
	declShort4N_ = ((capacity_.DeclTypes & D3DDTCAPS_SHORT4N) != 0);
	declUShort2N_ = ((capacity_.DeclTypes & D3DDTCAPS_USHORT2N) != 0);
	declUShort4N_ = ((capacity_.DeclTypes & D3DDTCAPS_USHORT4N) != 0);
	declUDec3_ = ((capacity_.DeclTypes & D3DDTCAPS_UDEC3) != 0);
	declDec3_ = ((capacity_.DeclTypes & D3DDTCAPS_DEC3N) != 0);
	declFloat16_2_ = ((capacity_.DeclTypes & D3DDTCAPS_FLOAT16_2) != 0);
	declFloat16_4_ = ((capacity_.DeclTypes & D3DDTCAPS_FLOAT16_4) != 0);

	//--------------------------------------------------------------------------
	// ebZ[V
	//--------------------------------------------------------------------------
	maxNPatchTesselationLevel_ = capacity_.MaxNpatchTessellationLevel;
	streamOffset_ =
		((capacity_.DevCaps2 & D3DDEVCAPS2_STREAMOFFSET) != 0);
	dmapNPatch_ =
		((capacity_.DevCaps2 & D3DDEVCAPS2_DMAPNPATCH) != 0);
	adaptiveTessRTPatch_ =
		((capacity_.DevCaps2 & D3DDEVCAPS2_ADAPTIVETESSRTPATCH) != 0);
	adaptiveTessNPatch_ =
		((capacity_.DevCaps2 & D3DDEVCAPS2_ADAPTIVETESSNPATCH) != 0);
	canStretchRectFromTextures_ =
		((capacity_.DevCaps2 & D3DDEVCAPS2_CAN_STRETCHRECT_FROM_TEXTURES) != 0);
	preSampledDmapNPatch_ =
		((capacity_.DevCaps2 & D3DDEVCAPS2_PRESAMPLEDDMAPNPATCH) != 0);
	vertexElementsCanShareStreamOffset_ =
		((capacity_.DevCaps2 &
		D3DDEVCAPS2_VERTEXELEMENTSCANSHARESTREAMOFFSET) != 0);

	//--------------------------------------------------------------------------
	// VF[fBO
	//--------------------------------------------------------------------------
	shadeColorGouraudRGB_ =
		((capacity_.ShadeCaps & D3DPSHADECAPS_COLORGOURAUDRGB) != 0);
	shadeSpecularGouraudRGB_ =
		((capacity_.ShadeCaps & D3DPSHADECAPS_SPECULARGOURAUDRGB) != 0);
	shadeAlphaGouraudBlend_ =
		((capacity_.ShadeCaps & D3DPSHADECAPS_ALPHAGOURAUDBLEND) != 0);
	shadeFogGouraud_ =
		((capacity_.ShadeCaps & D3DPSHADECAPS_FOGGOURAUD) != 0);

	//--------------------------------------------------------------------------
	// eNX`
	//--------------------------------------------------------------------------
	maxTextureSize_.set(capacity_.MaxTextureWidth, capacity_.MaxTextureHeight);
	maxVolumeExtent_ = capacity_.MaxVolumeExtent;
	maxTextureRepeat_ = capacity_.MaxTextureRepeat;
	maxAnisotropy_ = capacity_.MaxAnisotropy;
	maxTextureAspectRaito_ = capacity_.MaxTextureAspectRatio;
	texturePerspective_ =
		((capacity_.TextureCaps & D3DPTEXTURECAPS_PERSPECTIVE) != 0);
	texturePow2_ =
		((capacity_.TextureCaps & D3DPTEXTURECAPS_POW2) != 0);
	textureAlpha_ =
		((capacity_.TextureCaps & D3DPTEXTURECAPS_ALPHA) != 0);
	textureSquareOnly_ =
		((capacity_.TextureCaps & D3DPTEXTURECAPS_SQUAREONLY) != 0);
	textureRepeatNotScaledBySize_ =
		((capacity_.TextureCaps &
		D3DPTEXTURECAPS_TEXREPEATNOTSCALEDBYSIZE) != 0);
	textureAlphaPalette_ =
		((capacity_.TextureCaps & D3DPTEXTURECAPS_ALPHAPALETTE) != 0);
	textureNonPow2Conditional_ =
		((capacity_.TextureCaps & D3DPTEXTURECAPS_NONPOW2CONDITIONAL) != 0);
	textureProjected_ =
		((capacity_.TextureCaps & D3DPTEXTURECAPS_PROJECTED) != 0);
	textureCubemap_ =
		((capacity_.TextureCaps & D3DPTEXTURECAPS_CUBEMAP) != 0);
	textureVolumemap_ =
		((capacity_.TextureCaps & D3DPTEXTURECAPS_VOLUMEMAP) != 0);
	textureMipmap_ =
		((capacity_.TextureCaps & D3DPTEXTURECAPS_MIPMAP) != 0);
	textureMipmapCubemap_ =
		((capacity_.TextureCaps & D3DPTEXTURECAPS_MIPCUBEMAP) != 0);
	textureMipmapVolumemap_ =
		((capacity_.TextureCaps & D3DPTEXTURECAPS_MIPVOLUMEMAP) != 0);
	textureCubemapPow2_ =
		((capacity_.TextureCaps & D3DPTEXTURECAPS_CUBEMAP_POW2) != 0);
	textureVolumemapPow2_ =
		((capacity_.TextureCaps & D3DPTEXTURECAPS_VOLUMEMAP_POW2) != 0);
	textureNoProjectedBumpEnvironment_ =
		((capacity_.TextureCaps & D3DPTEXTURECAPS_NOPROJECTEDBUMPENV) != 0);

	//--------------------------------------------------------------------------
	// eNX`AhX
	//--------------------------------------------------------------------------
	textureAddressWrap_ =
		((capacity_.TextureAddressCaps & D3DPTADDRESSCAPS_WRAP) != 0);
	textureAddressMirror_ =
		((capacity_.TextureAddressCaps & D3DPTADDRESSCAPS_MIRROR) != 0);
	textureAddressClamp_ =
		((capacity_.TextureAddressCaps & D3DPTADDRESSCAPS_CLAMP) != 0);
	textureAddressBorder_ =
		((capacity_.TextureAddressCaps & D3DPTADDRESSCAPS_BORDER) != 0);
	textureAddressIndependentUV_ =
		((capacity_.TextureAddressCaps & D3DPTADDRESSCAPS_INDEPENDENTUV) != 0);
	textureAddressMirrorOnce_ =
		((capacity_.TextureAddressCaps & D3DPTADDRESSCAPS_MIRRORONCE) != 0);
	volumeTextureAddressWrap_ =
		((capacity_.VolumeTextureAddressCaps & D3DPTADDRESSCAPS_WRAP) != 0);
	volumeTextureAddressMirror_ =
		((capacity_.VolumeTextureAddressCaps & D3DPTADDRESSCAPS_MIRROR) != 0);
	volumeTextureAddressClamp_ =
		((capacity_.VolumeTextureAddressCaps & D3DPTADDRESSCAPS_CLAMP) != 0);
	volumeTextureAddressBorder_ =
		((capacity_.VolumeTextureAddressCaps & D3DPTADDRESSCAPS_BORDER) != 0);
	volumeTextureAddressIndependentUV_ =
		((capacity_.VolumeTextureAddressCaps &
		D3DPTADDRESSCAPS_INDEPENDENTUV) != 0);
	volumeTextureAddressMirrorOnce_ =
		((capacity_.VolumeTextureAddressCaps &
		D3DPTADDRESSCAPS_MIRRORONCE) != 0);

	//--------------------------------------------------------------------------
	// eNX`tB^
	//--------------------------------------------------------------------------
	textureFilterMinPoint_ =
		((capacity_.TextureFilterCaps & D3DPTFILTERCAPS_MINFPOINT) != 0);
	textureFilterMinLiner_ =
		((capacity_.TextureFilterCaps & D3DPTFILTERCAPS_MINFLINEAR) != 0);
	textureFilterMinAnisotropic_ =
		((capacity_.TextureFilterCaps & D3DPTFILTERCAPS_MINFANISOTROPIC) != 0);
	textureFilterMinPyramidalQuad_ =
		((capacity_.TextureFilterCaps &
		D3DPTFILTERCAPS_MINFPYRAMIDALQUAD) != 0);
	textureFilterMinGaussianQuad_ =
		((capacity_.TextureFilterCaps & D3DPTFILTERCAPS_MINFGAUSSIANQUAD) != 0);
	textureFilterMagPoint_ =
		((capacity_.TextureFilterCaps & D3DPTFILTERCAPS_MAGFPOINT) != 0);
	textureFilterMagLiner_ =
		((capacity_.TextureFilterCaps & D3DPTFILTERCAPS_MAGFLINEAR) != 0);
	textureFilterMagAnisotropic_ =
		((capacity_.TextureFilterCaps & D3DPTFILTERCAPS_MAGFANISOTROPIC) != 0);
	textureFilterMagPyramidalQuad_ =
		((capacity_.TextureFilterCaps &
		D3DPTFILTERCAPS_MAGFPYRAMIDALQUAD) != 0);
	textureFilterMagGaussianQuad_ =
		((capacity_.TextureFilterCaps & D3DPTFILTERCAPS_MAGFGAUSSIANQUAD) != 0);
	textureFilterMipmapPoint_ =
		((capacity_.TextureFilterCaps & D3DPTFILTERCAPS_MIPFPOINT) != 0);
	textureFilterMipmapLiner_ =
		((capacity_.TextureFilterCaps & D3DPTFILTERCAPS_MIPFLINEAR) != 0);

	cubeTextureFilterMinPoint_ =
		((capacity_.CubeTextureFilterCaps & D3DPTFILTERCAPS_MINFPOINT) != 0);
	cubeTextureFilterMinLiner_ =
		((capacity_.CubeTextureFilterCaps & D3DPTFILTERCAPS_MINFLINEAR) != 0);
	cubeTextureFilterMinAnisotropic_ =
		((capacity_.CubeTextureFilterCaps &
		D3DPTFILTERCAPS_MINFANISOTROPIC) != 0);
	cubeTextureFilterMinPyramidalQuad_ =
		((capacity_.CubeTextureFilterCaps &
		D3DPTFILTERCAPS_MINFPYRAMIDALQUAD) != 0);
	cubeTextureFilterMinGaussianQuad_ =
		((capacity_.CubeTextureFilterCaps &
		D3DPTFILTERCAPS_MINFGAUSSIANQUAD) != 0);
	cubeTextureFilterMagPoint_ =
		((capacity_.CubeTextureFilterCaps & D3DPTFILTERCAPS_MAGFPOINT) != 0);
	cubeTextureFilterMagLiner_ =
		((capacity_.CubeTextureFilterCaps & D3DPTFILTERCAPS_MAGFLINEAR) != 0);
	cubeTextureFilterMagAnisotropic_ =
		((capacity_.CubeTextureFilterCaps &
		D3DPTFILTERCAPS_MAGFANISOTROPIC) != 0);
	cubeTextureFilterMagPyramidalQuad_ =
		((capacity_.CubeTextureFilterCaps &
		D3DPTFILTERCAPS_MAGFPYRAMIDALQUAD) != 0);
	cubeTextureFilterMagGaussianQuad_ =
		((capacity_.CubeTextureFilterCaps &
		D3DPTFILTERCAPS_MAGFGAUSSIANQUAD) != 0);
	cubeTextureFilterMipmapPoint_ =
		((capacity_.CubeTextureFilterCaps & D3DPTFILTERCAPS_MIPFPOINT) != 0);
	cubeTextureFilterMipmapLiner_ =
		((capacity_.CubeTextureFilterCaps & D3DPTFILTERCAPS_MIPFLINEAR) != 0);

	volumeTextureFilterMinPoint_ =
		((capacity_.VolumeTextureFilterCaps & D3DPTFILTERCAPS_MINFPOINT) != 0);
	volumeTextureFilterMinLiner_ =
		((capacity_.VolumeTextureFilterCaps & D3DPTFILTERCAPS_MINFLINEAR) != 0);
	volumeTextureFilterMinAnisotropic_ =
		((capacity_.VolumeTextureFilterCaps &
		D3DPTFILTERCAPS_MINFANISOTROPIC) != 0);
	volumeTextureFilterMinPyramidalQuad_ =
		((capacity_.VolumeTextureFilterCaps &
		D3DPTFILTERCAPS_MINFPYRAMIDALQUAD) != 0);
	volumeTextureFilterMinGaussianQuad_ =
		((capacity_.VolumeTextureFilterCaps &
		D3DPTFILTERCAPS_MINFGAUSSIANQUAD) != 0);
	volumeTextureFilterMagPoint_ =
		((capacity_.VolumeTextureFilterCaps & D3DPTFILTERCAPS_MAGFPOINT) != 0);
	volumeTextureFilterMagLiner_ =
		((capacity_.VolumeTextureFilterCaps & D3DPTFILTERCAPS_MAGFLINEAR) != 0);
	volumeTextureFilterMagAnisotropic_ =
		((capacity_.VolumeTextureFilterCaps &
		D3DPTFILTERCAPS_MAGFANISOTROPIC) != 0);
	volumeTextureFilterMagPyramidalQuad_ =
		((capacity_.VolumeTextureFilterCaps &
		D3DPTFILTERCAPS_MAGFPYRAMIDALQUAD) != 0);
	volumeTextureFilterMagGaussianQuad_ =
		((capacity_.VolumeTextureFilterCaps &
		D3DPTFILTERCAPS_MAGFGAUSSIANQUAD) != 0);
	volumeTextureFilterMipmapPoint_ =
		((capacity_.VolumeTextureFilterCaps & D3DPTFILTERCAPS_MIPFPOINT) != 0);
	volumeTextureFilterMipmapLiner_ =
		((capacity_.VolumeTextureFilterCaps & D3DPTFILTERCAPS_MIPFLINEAR) != 0);

	vertexTextureFilterMinPoint_ =
		((capacity_.VertexTextureFilterCaps & D3DPTFILTERCAPS_MINFPOINT) != 0);
	vertexTextureFilterMinLiner_ =
		((capacity_.VertexTextureFilterCaps & D3DPTFILTERCAPS_MINFLINEAR) != 0);
	vertexTextureFilterMinAnisotropic_ =
		((capacity_.VertexTextureFilterCaps &
		D3DPTFILTERCAPS_MINFANISOTROPIC) != 0);
	vertexTextureFilterMinPyramidalQuad_ =
		((capacity_.VertexTextureFilterCaps &
		D3DPTFILTERCAPS_MINFPYRAMIDALQUAD) != 0);
	vertexTextureFilterMinGaussianQuad_ =
		((capacity_.VertexTextureFilterCaps &
		D3DPTFILTERCAPS_MINFGAUSSIANQUAD) != 0);
	vertexTextureFilterMagPoint_ =
		((capacity_.VertexTextureFilterCaps & D3DPTFILTERCAPS_MAGFPOINT) != 0);
	vertexTextureFilterMagLiner_ =
		((capacity_.VertexTextureFilterCaps & D3DPTFILTERCAPS_MAGFLINEAR) != 0);
	vertexTextureFilterMagAnisotropic_ =
		((capacity_.VertexTextureFilterCaps &
		D3DPTFILTERCAPS_MAGFANISOTROPIC) != 0);
	vertexTextureFilterMagPyramidalQuad_ =
		((capacity_.VertexTextureFilterCaps &
		D3DPTFILTERCAPS_MAGFPYRAMIDALQUAD) != 0);
	vertexTextureFilterMagGaussianQuad_ =
		((capacity_.VertexTextureFilterCaps &
		D3DPTFILTERCAPS_MAGFGAUSSIANQUAD) != 0);
	vertexTextureFilterMipmapPoint_ =
		((capacity_.VertexTextureFilterCaps & D3DPTFILTERCAPS_MIPFPOINT) != 0);
	vertexTextureFilterMipmapLiner_ =
		((capacity_.VertexTextureFilterCaps & D3DPTFILTERCAPS_MIPFLINEAR) != 0);

	//--------------------------------------------------------------------------
	// eNX`Xe[W
	//--------------------------------------------------------------------------
	maxTextureBlendStages_ = capacity_.MaxTextureBlendStages;
	maxSimultaneousTextures_ = capacity_.MaxSimultaneousTextures;

	textureOperationDisable_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_DISABLE) != 0);
	textureOperationSelectArg1_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_SELECTARG1) != 0);
	textureOperationSelectArg2_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_SELECTARG2) != 0);
	textureOperationModulate_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_MODULATE) != 0);
	textureOperationModulate2x_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_MODULATE2X) != 0);
	textureOperationModulate4x_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_MODULATE4X) != 0);
	textureOperationAdd_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_ADD) != 0);
	textureOperationAddSigned_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_ADDSIGNED) != 0);
	textureOperationAddSigned2x_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_ADDSIGNED2X) != 0);
	textureOperationSubtract_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_SUBTRACT) != 0);
	textureOperationAddSmooth_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_ADDSMOOTH) != 0);
	textureOperationBlendDiffuseAlpha_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_BLENDDIFFUSEALPHA) != 0);
	textureOperationBlendTextureAlpha_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_BLENDTEXTUREALPHA) != 0);
	textureOperationBlendFactorAlpha_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_BLENDFACTORALPHA) != 0);
	textureOperationBlendTextureAlphaPM_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_BLENDTEXTUREALPHAPM) != 0);
	textureOperationBlendCurrentAlpha_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_BLENDCURRENTALPHA) != 0);
	textureOperationPreModulate_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_PREMODULATE) != 0);
	textureOperationModulateAlphaAddColor_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_MODULATEALPHA_ADDCOLOR) != 0);
	textureOperationModulateColorAddAlpha_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_MODULATECOLOR_ADDALPHA) != 0);
	textureOperationModulateInvAlphaAddColor_ =
		((capacity_.TextureOpCaps &
		D3DTEXOPCAPS_MODULATEINVALPHA_ADDCOLOR) != 0);
	textureOperationModulateInvColorAddAlpha_ =
		((capacity_.TextureOpCaps &
		D3DTEXOPCAPS_MODULATEINVCOLOR_ADDALPHA) != 0);
	textureOperationBumpEnvMap_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_BUMPENVMAP) != 0);
	textureOperationBumpEnvMapLuminance_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_BUMPENVMAPLUMINANCE) != 0);
	textureOperationDotProduct3_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_DOTPRODUCT3) != 0);
	textureOperationMultiplyAdd_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_MULTIPLYADD) != 0);
	textureOperationLerp_ =
		((capacity_.TextureOpCaps & D3DTEXOPCAPS_LERP) != 0);

	//--------------------------------------------------------------------------
	// r
	//--------------------------------------------------------------------------
	zCompareNever_ =
		((capacity_.ZCmpCaps & D3DPCMPCAPS_NEVER) != 0);
	zCompareLess_ =
		((capacity_.ZCmpCaps & D3DPCMPCAPS_LESS) != 0);
	zCompareEqual_ =
		((capacity_.ZCmpCaps & D3DPCMPCAPS_EQUAL) != 0);
	zCompareLessEqual_ =
		((capacity_.ZCmpCaps & D3DPCMPCAPS_LESSEQUAL) != 0);
	zCompareGreater_ =
		((capacity_.ZCmpCaps & D3DPCMPCAPS_GREATER) != 0);
	zCompareNotEqual_ =
		((capacity_.ZCmpCaps & D3DPCMPCAPS_NOTEQUAL) != 0);
	zCompareGreaterEqual_ =
		((capacity_.ZCmpCaps & D3DPCMPCAPS_GREATEREQUAL) != 0);
	zCompareAlways_ =
		((capacity_.ZCmpCaps & D3DPCMPCAPS_ALWAYS) != 0);

	stencilKeep_ =
		((capacity_.StencilCaps & D3DSTENCILCAPS_KEEP) != 0);
	stencilZero_ =
		((capacity_.StencilCaps & D3DSTENCILCAPS_ZERO) != 0);
	stencilReplace_ =
		((capacity_.StencilCaps & D3DSTENCILCAPS_REPLACE) != 0);
	stencilIncrSat_ =
		((capacity_.StencilCaps & D3DSTENCILCAPS_INCRSAT) != 0);
	stencilDecrSat_ =
		((capacity_.StencilCaps & D3DSTENCILCAPS_DECRSAT) != 0);
	stencilInvert_ =
		((capacity_.StencilCaps & D3DSTENCILCAPS_INVERT) != 0);
	stencilIncr_ =
		((capacity_.StencilCaps & D3DSTENCILCAPS_INCR) != 0);
	stencilDecr_ =
		((capacity_.StencilCaps & D3DSTENCILCAPS_DECR) != 0);
	stencilTwoSided_ =
		((capacity_.StencilCaps & D3DSTENCILCAPS_TWOSIDED) != 0);

	alphaCompareNever_ =
		((capacity_.AlphaCmpCaps & D3DPCMPCAPS_NEVER) != 0);
	alphaCompareLess_ =
		((capacity_.AlphaCmpCaps & D3DPCMPCAPS_LESS) != 0);
	alphaCompareEqual_ =
		((capacity_.AlphaCmpCaps & D3DPCMPCAPS_EQUAL) != 0);
	alphaCompareLessEqual_ =
		((capacity_.AlphaCmpCaps & D3DPCMPCAPS_LESSEQUAL) != 0);
	alphaCompareGreater_ =
		((capacity_.AlphaCmpCaps & D3DPCMPCAPS_GREATER) != 0);
	alphaCompareNotEqual_ =
		((capacity_.AlphaCmpCaps & D3DPCMPCAPS_NOTEQUAL) != 0);
	alphaCompareGreaterEqual_ =
		((capacity_.AlphaCmpCaps & D3DPCMPCAPS_GREATEREQUAL) != 0);
	alphaCompareAlways_ =
		((capacity_.AlphaCmpCaps & D3DPCMPCAPS_ALWAYS) != 0);

	//--------------------------------------------------------------------------
	// ufBO
	//--------------------------------------------------------------------------
	blendSourceZero_ =
		((capacity_.SrcBlendCaps & D3DPBLENDCAPS_ZERO) != 0);
	blendSourceOne_ =
		((capacity_.SrcBlendCaps & D3DPBLENDCAPS_ONE) != 0);
	blendSourceSrcColor_ =
		((capacity_.SrcBlendCaps & D3DPBLENDCAPS_SRCCOLOR) != 0);
	blendSourceInvSrcColor_ =
		((capacity_.SrcBlendCaps & D3DPBLENDCAPS_INVSRCCOLOR) != 0);
	blendSourceSrcAlpha_ =
		((capacity_.SrcBlendCaps & D3DPBLENDCAPS_SRCALPHA) != 0);
	blendSourceInvSrcAlpha_ =
		((capacity_.SrcBlendCaps & D3DPBLENDCAPS_INVSRCALPHA) != 0);
	blendSourceDestAlpha_ =
		((capacity_.SrcBlendCaps & D3DPBLENDCAPS_DESTALPHA) != 0);
	blendSourceInvDestAlpha_ =
		((capacity_.SrcBlendCaps & D3DPBLENDCAPS_INVDESTALPHA) != 0);
	blendSourceDestColor_ =
		((capacity_.SrcBlendCaps & D3DPBLENDCAPS_DESTCOLOR) != 0);
	blendSourceInvDestColor_ =
		((capacity_.SrcBlendCaps & D3DPBLENDCAPS_INVDESTCOLOR) != 0);
	blendSourceSrcAlphaSat_ =
		((capacity_.SrcBlendCaps & D3DPBLENDCAPS_SRCALPHASAT) != 0);
	blendSourceBothSrcAlpha_ =
		((capacity_.SrcBlendCaps & D3DPBLENDCAPS_BOTHSRCALPHA) != 0);
	blendSourceBothInvSrcAlpha_ =
		((capacity_.SrcBlendCaps & D3DPBLENDCAPS_BOTHINVSRCALPHA) != 0);
	blendSourceBlendFactor_ =
		((capacity_.SrcBlendCaps & D3DPBLENDCAPS_BLENDFACTOR) != 0);

	blendDestinationZero_ =
		((capacity_.DestBlendCaps & D3DPBLENDCAPS_ZERO) != 0);
	blendDestinationOne_ =
		((capacity_.DestBlendCaps & D3DPBLENDCAPS_ONE) != 0);
	blendDestinationSrcColor_ =
		((capacity_.DestBlendCaps & D3DPBLENDCAPS_SRCCOLOR) != 0);
	blendDestinationInvSrcColor_ =
		((capacity_.DestBlendCaps & D3DPBLENDCAPS_INVSRCCOLOR) != 0);
	blendDestinationSrcAlpha_ =
		((capacity_.DestBlendCaps & D3DPBLENDCAPS_SRCALPHA) != 0);
	blendDestinationInvSrcAlpha_ =
		((capacity_.DestBlendCaps & D3DPBLENDCAPS_INVSRCALPHA) != 0);
	blendDestinationDestAlpha_ =
		((capacity_.DestBlendCaps & D3DPBLENDCAPS_DESTALPHA) != 0);
	blendDestinationInvDestAlpha_ =
		((capacity_.DestBlendCaps & D3DPBLENDCAPS_INVDESTALPHA) != 0);
	blendDestinationDestColor_ =
		((capacity_.DestBlendCaps & D3DPBLENDCAPS_DESTCOLOR) != 0);
	blendDestinationInvDestColor_ =
		((capacity_.DestBlendCaps & D3DPBLENDCAPS_INVDESTCOLOR) != 0);
	blendDestinationSrcAlphaSat_ =
		((capacity_.DestBlendCaps & D3DPBLENDCAPS_SRCALPHASAT) != 0);
	blendDestinationBothSrcAlpha_ =
		((capacity_.DestBlendCaps & D3DPBLENDCAPS_BOTHSRCALPHA) != 0);
	blendDestinationBothInvSrcAlpha_ =
		((capacity_.DestBlendCaps & D3DPBLENDCAPS_BOTHINVSRCALPHA) != 0);
	blendDestinationBlendFactor_ =
		((capacity_.DestBlendCaps & D3DPBLENDCAPS_BLENDFACTOR) != 0);

	//--------------------------------------------------------------------------
	// X^CY
	//--------------------------------------------------------------------------
	extentsAdjust_ = capacity_.ExtentsAdjust;
	rasterDither_ =
		((capacity_.RasterCaps & D3DPRASTERCAPS_DITHER) != 0);
	rasterZTest_ =
		((capacity_.RasterCaps & D3DPRASTERCAPS_ZTEST) != 0);
	rasterFogVertex_ =
		((capacity_.RasterCaps & D3DPRASTERCAPS_FOGVERTEX) != 0);
	rasterFogTable_ =
		((capacity_.RasterCaps & D3DPRASTERCAPS_FOGTABLE) != 0);
	rasterMipmapLODBias_ =
		((capacity_.RasterCaps & D3DPRASTERCAPS_MIPMAPLODBIAS) != 0);
	rasterZBufferLessHSR_ =
		((capacity_.RasterCaps & D3DPRASTERCAPS_ZBUFFERLESSHSR) != 0);
	rasterFogRange_ =
		((capacity_.RasterCaps & D3DPRASTERCAPS_FOGRANGE) != 0);
	rasterAnisotropy_ =
		((capacity_.RasterCaps & D3DPRASTERCAPS_ANISOTROPY) != 0);
	rasterWBuffer_ =
		((capacity_.RasterCaps & D3DPRASTERCAPS_WBUFFER) != 0);
	rasterWFog_ =
		((capacity_.RasterCaps & D3DPRASTERCAPS_WFOG) != 0);
	rasterZFog_ =
		((capacity_.RasterCaps & D3DPRASTERCAPS_ZFOG) != 0);
	rasterColorPerspective_ =
		((capacity_.RasterCaps & D3DPRASTERCAPS_COLORPERSPECTIVE) != 0);
	rasterScissorTest_ =
		((capacity_.RasterCaps & D3DPRASTERCAPS_SCISSORTEST) != 0);
	rasterSlopeScaleDepthBias_ =
		((capacity_.RasterCaps & D3DPRASTERCAPS_SLOPESCALEDEPTHBIAS) != 0);
	rasterDepthBias_ =
		((capacity_.RasterCaps & D3DPRASTERCAPS_DEPTHBIAS) != 0);
	rasterMultiSampleToggle_ =
		((capacity_.RasterCaps & D3DPRASTERCAPS_MULTISAMPLE_TOGGLE) != 0);

	//--------------------------------------------------------------------------
	// _VF[_
	//--------------------------------------------------------------------------
	vertexShaderMajorVersion_ =
		D3DSHADER_VERSION_MAJOR(capacity_.VertexShaderVersion);
	vertexShaderMinorVersion_ =
		D3DSHADER_VERSION_MINOR(capacity_.VertexShaderVersion);
	maxVertexShaderConst_ = capacity_.MaxVertexShaderConst;
	maxStreamStride_ = capacity_.MaxStreamStride;
	maxVShaderInstructionsExecuted_ = capacity_.MaxVShaderInstructionsExecuted;
	maxVertexShader30InstructionSlots_ =
		capacity_.MaxVertexShader30InstructionSlots;
	vertexShaderDynamicFlowControlDepth_ =
		capacity_.VS20Caps.DynamicFlowControlDepth;
	vertexShaderNumTemps_ =  capacity_.VS20Caps.NumTemps;
	vertexShaderStaticFlowControlDepth_ =
		capacity_.VS20Caps.StaticFlowControlDepth;
	vertexShaderPredication_ =
		((capacity_.VS20Caps.Caps & D3DVS20CAPS_PREDICATION) != 0);

	//--------------------------------------------------------------------------
	// sNZVF[_
	//--------------------------------------------------------------------------
	pixelShaderMajorVersion_ =
		D3DSHADER_VERSION_MAJOR(capacity_.PixelShaderVersion);
	pixelShaderMinorVersion_ =
		D3DSHADER_VERSION_MINOR(capacity_.PixelShaderVersion);
	pixelShader1xMaxValue_ = capacity_.PixelShader1xMaxValue;
	maxPShaderInstructionsExecuted_ = capacity_.MaxPShaderInstructionsExecuted;
	maxPixelShader30InstructionSlots_ =
		capacity_.MaxPixelShader30InstructionSlots;
	pixelShaderDynamicFlowControlDepth_ =
		capacity_.PS20Caps.DynamicFlowControlDepth;
	pixelShaderNumTemps_ =  capacity_.PS20Caps.NumTemps;
	pixelShaderStaticFlowControlDepth_ =
		capacity_.PS20Caps.StaticFlowControlDepth;
	pixelShaderNumInstructionSlots_ =
		capacity_.PS20Caps.NumInstructionSlots;
	pixelShaderArbitrarySwizzle_ =
		((capacity_.PS20Caps.Caps & D3DPS20CAPS_ARBITRARYSWIZZLE) != 0);
	pixelShaderGradientInstructions_ =
		((capacity_.PS20Caps.Caps & D3DPS20CAPS_GRADIENTINSTRUCTIONS) != 0);
	pixelShaderPredication_ =
		((capacity_.PS20Caps.Caps & D3DPS20CAPS_PREDICATION) != 0);
	pixelShaderNoDependentReadLimit_ =
		((capacity_.PS20Caps.Caps & D3DPS20CAPS_NODEPENDENTREADLIMIT) != 0);
	pixelShaderNoTexnstructionLimit_ =
		((capacity_.PS20Caps.Caps & D3DPS20CAPS_NOTEXINSTRUCTIONLIMIT) != 0);

}
//------------------------------------------------------------------------------
// ւ̕ϊ
String GraphicsDeviceCapacity::toString() const{
	String result, temp, line;
	GraphicsBufferFormat bufferFormat;
	line = "//----------------------------------------"
		"-------------------------------------\n";

	//--------------------------------------------------------------------------
	// foCX
	//--------------------------------------------------------------------------
	result += line + "//\tfoCX\n" + line;
	result += temp.format("\tfoCX\t\t\t\t\t\t%s\n",
		getDeviceName().getBytes());
	result += temp.format("\thCo\t\t\t\t\t\t%s\n",
		getDriverName().getBytes());
	result += temp.format("\tfoCXԍ\t\t\t\t\t%d\n", getDeviceOrdinal());
	switch(getDeviceType()){
	case D3DDEVTYPE_HAL:
		result += "\tfoCX^Cv\t\t\t\t\tn[hEFA\n";
		break;
	case D3DDEVTYPE_REF:
		result += "\tfoCX^Cv\t\t\t\t\tt@XX^CU\n";
		break;
	case D3DDEVTYPE_SW:
		result += "\tfoCX^Cv\t\t\t\t\t\tgEFA\n";
		break;
	}
	if(isWindowed()){ result += "\t[h\t\t\t\t\t\t\tEBhE\n";}
	else{ result += "\t[h\t\t\t\t\t\t\ttXN[\n"; }
	result += temp.format("\t_vZX^Cv\t\t\t\t%s\n",
		getVertexProcessingType().toString().getBytes());
	bufferFormat = getAdapterFormat();
	result += "\tA_v^tH[}bg\t\t\t" + bufferFormat.getName() + "\n";
	bufferFormat = getBackBufferFormat();
	result += "\tobNobt@tH[}bg\t\t" + bufferFormat.getName() + "\n";
	result += temp.format("\tobNobt@TCY\t\t\t( %d x %d )\n",
		getBackBufferSize().width, getBackBufferSize().height);
	result += temp.format("\ttbV[g\t\t\t\t%d Hz\n",
		getRefreshRate());
	if(getDepthStencilEnabled()){
		result += "\t[xAXeVobt@\t\tL\n";
	}else{
		result += "\t[xAXeVobt@\t\t\n";
	}
	bufferFormat = getDepthStencilFormat();
	result += "\t[xAXeVtH[}bg\t" + bufferFormat.getName() + "\n";
	result += "\tv[e[VԊu\t\t\t";
	switch(getPresentationInterval()){
	case D3DPRESENT_INTERVAL_IMMEDIATE:	result += "\n"; break;
	case D3DPRESENT_INTERVAL_DEFAULT:	result += "ftHg\n"; break;
	case D3DPRESENT_INTERVAL_ONE:		result += "1\n"; break;
	case D3DPRESENT_INTERVAL_TWO:		result += "2\n"; break;
	case D3DPRESENT_INTERVAL_THREE:		result += "3\n"; break;
	case D3DPRESENT_INTERVAL_FOUR:		result += "4\n"; break;
	}
	result += "\t}`Tv^Cv\t\t\t";
	switch(getMultiSampleType()){
	case D3DMULTISAMPLE_NONE:			result += "\n"; break;
	case D3DMULTISAMPLE_NONMASKABLE:	result += "NHeB\n"; break;
	case D3DMULTISAMPLE_2_SAMPLES:		result += "2Tv\n"; break;
	case D3DMULTISAMPLE_3_SAMPLES:		result += "3Tv\n"; break;
	case D3DMULTISAMPLE_4_SAMPLES:		result += "4Tv\n"; break;
	case D3DMULTISAMPLE_5_SAMPLES:		result += "5Tv\n"; break;
	case D3DMULTISAMPLE_6_SAMPLES:		result += "6Tv\n"; break;
	case D3DMULTISAMPLE_7_SAMPLES:		result += "7Tv\n"; break;
	case D3DMULTISAMPLE_8_SAMPLES:		result += "8Tv\n"; break;
	case D3DMULTISAMPLE_9_SAMPLES:		result += "9Tv\n"; break;
	case D3DMULTISAMPLE_10_SAMPLES:		result += "10Tv\n"; break;
	case D3DMULTISAMPLE_11_SAMPLES:		result += "11Tv\n"; break;
	case D3DMULTISAMPLE_12_SAMPLES:		result += "12Tv\n"; break;
	case D3DMULTISAMPLE_13_SAMPLES:		result += "13Tv\n"; break;
	case D3DMULTISAMPLE_14_SAMPLES:		result += "14Tv\n"; break;
	case D3DMULTISAMPLE_15_SAMPLES:		result += "15Tv\n"; break;
	case D3DMULTISAMPLE_16_SAMPLES:		result += "16Tv\n"; break;
	}
	result += temp.format("\t}`TvNHeB\t\t%d\n",
		getMultiSampleQuality());

	//--------------------------------------------------------------------------
	// foCX\
	//--------------------------------------------------------------------------
	result += "\n" + line + "//\tfoCX\\n" + line;
	result += temp.format("\t}`_[^[Qbg\t\t%d\n",
		getNumSimultaneousRTs());
	result += "\tVXeŎs\t\t\t";
	result += supportedString(supportedExecuteSystemMemory());
	result += "\trfIŎs\t\t\t\t";
	result += supportedString(supportedExecuteVideoMemory());
	result += "\tVXeTL_\t\t";
	result += supportedString(supportedTlVertexSystemMemory());
	result += "\trfITL_\t\t\t";
	result += supportedString(supportedTlVertexVideoMemory());
	result += "\tVXẽeNX`\t";
	result += supportedString(supportedTextureSystemMemory());
	result += "\trfĨeNX`\t\t";
	result += supportedString(supportedTextureVideoMemory());
	result += "\tTL_̕`\t\t\t\t\t";
	result += supportedString(supportedDrawPrimTlVertex());
	result += "\ttbṽ_O\t\t";
	result += supportedString(supportedCanRenderAfterFlip());
	result += "\t񃍁[JrfI\t\t\t";
	result += supportedString(supportedTextureNonLocalVidedMemory());
	result += "\tDrawPrivitives2\t\t\t\t\t";
	result += supportedString(supportedDrawPrimitives2());
	result += "\tƗeNX`v[\t";
	result += supportedString(supportedSeparateTextureMemories());
	result += "\tDrawPrimitives2EX\t\t\t\t";
	result += supportedString(supportedDrawPrimitives2EX());
	result += "\tn[hEFAT&L\t\t\t\t\t";
	result += supportedString(supportedHwTransformAndLight());
	result += "\tVXerfIւBLT\t\t";
	result += supportedString(supportedCanBltSystemToNonLocal());
	result += "\tn[hEFAX^CY\t\t";
	result += supportedString(supportedHwRasterization());
	result += "\tsAfoCX\t\t\t\t\t";
	result += supportedString(supportedPureDevice());
	result += "\txWFABXvC\t\t\t\t";
	result += supportedString(supportedQuinticRtPatches());
	result += "\t`AOp`pb`\t\t\t\t";
	result += supportedString(supportedRtPatches());
	result += "\tIȃnh0pb`\t\t\t";
	result += supportedString(supportedRtPatchHanldeZero());
	result += "\tNpb`\t\t\t\t\t\t\t";
	result += supportedString(supportedNPatches());
	result += "\tv[e[VԊu\t\t";
	result += supportedString(supportedPresentationIntervalImmediate());
	result += "\tv[e[VԊu1\t";
	result += supportedString(supportedPresentationIntervalOne());
	result += "\tv[e[VԊu2\t";
	result += supportedString(supportedPresentationIntervalTwo());
	result += "\tv[e[VԊu3\t";
	result += supportedString(supportedPresentationIntervalThree());
	result += "\tv[e[VԊu4\t";
	result += supportedString(supportedPresentationIntervalFour());
	result += "\tn[hEFAJ[\\t\t\t";
	result += supportedString(supportedCursorColor());
	result += "\t𑜓xn[hEFAJ[\\t";
	result += supportedString(supportedCursorLowRes());
	result += "\tStretchRectMinPointtB^\t\t";
	result += supportedString(supportedStretchRectMinPoint());
	result += "\tStretchRectMagPointtB^\t\t";
	result += supportedString(supportedStretchRectMagPoint());
	result += "\tStretchRectMinLineartB^\t";
	result += supportedString(supportedStretchRectMinLinear());
	result += "\tStretchRectMagLineartB^\t";
	result += supportedString(supportedStretchRectMagLinear());

	//--------------------------------------------------------------------------
	// foCX̑
	//--------------------------------------------------------------------------
	result += "\n" + line + "//\tfoCX̑\n" + line;
	result += temp.format("\t}X^[A_v^ԍ\t\t\t%d\n",
		getMasterAdapterOrdinal());
	result += temp.format("\tO[ṽA_v^ԍ\t\t%d\n",
		getAdapterOrdinalInGroup());
	result += temp.format("\tO[ṽA_v^\t\t\t%d\n",
		getNumberOfAdaptersInGroup());
	result += "\tZ}XN\t\t\t\t\t\t\t";
	result += supportedString(supportedMaskZ());
	result += "\tJO\t\t\t\t\t";
	result += supportedString(supportedCullNone());
	result += "\tvJO\t\t\t\t";
	result += supportedString(supportedCullCW());
	result += "\tvJO\t\t\t\t";
	result += supportedString(supportedCullCCW());
	result += "\tJ[`l\t\t";
	result += supportedString(supportedColorWriteEnable());
	result += "\tmȃ|CgNbv\t\t\t";
	result += supportedString(supportedClipPlaneScaledPoints());
	result += "\t_Nbv\t\t\t\t\t";
	result += supportedString(supportedClipTlVerts());
	result += "\te|eNX`\t\t";
	result += supportedString(supportedTssArgTemp());
	result += "\tAt@ufBO\t\t\t";
	result += supportedString(supportedBlendOp());
	result += "\tkt@X\t\t\t\t";
	result += supportedString(supportedNullReference());
	result += "\tƗ݃}XN\t\t\t";
	result += supportedString(supportedIndependentWriteMasks());
	result += "\teNX`Xe[W萔\t\t\t";
	result += supportedString(supportedPerStageConstant());
	result += "\ttHOƃXyLAt@\t\t";
	result += supportedString(supportedFogAndSpecularAlpha());
	result += "\tAt@puh\t\t\t\t";
	result += supportedString(supportedSeparateAlphaBlend());
	result += "\tMRTɈႤZ[x\t\t\t\t\t";
	result += supportedString(supportedMrtIndependentBitDepth());
	result += "\tMRTɃsNZVF[_㏈\t\t";
	result += supportedString(supportedMrtPostPixelShaderBlending());
	result += "\t_tHÕNv\t\t\t";
	result += supportedString(supportedFogVertexClamped());

	//--------------------------------------------------------------------------
	// hCo\
	//--------------------------------------------------------------------------
	result += "\n" + line + "//\thCo\\n" + line;
	result += "\tXLC̓ǂݍ\t\t";
	result += supportedString(supportedReadScanLine());
	result += "\ttXN[K}\t\t\t";
	result += supportedString(supportedFullscreenGamma());
	result += "\tLu[gK}\t\t\t";
	result += supportedString(supportedCanCalibrateGamma());
	result += "\t}l[Wh\[X\t\t\t\t";
	result += supportedString(supportedCanManageResource());
	result += "\tIeNX`\t\t\t\t\t";
	result += supportedString(supportedDynamicTextures());
	result += "\t~bv}bv\t\t\t";
	result += supportedString(supportedCanAutogenMipmap());
	result += "\ttXN[At@uh\t";
	result += supportedString(supportedAlphaFullscreenFlipOrDiscard());
	result += "\tsRGBv[e[V\t\t\t";
	result += supportedString(supportedLinerToSrgbPresentation());
	result += "\trfIւ̃Rs[\t\t\t";
	result += supportedString(supportedCopyToVideoMemory());
	result += "\tVXeւ̃Rs[\t\t";
	result += supportedString(supportedCopyToSystemMemory());

	//--------------------------------------------------------------------------
	// v~eBu
	//--------------------------------------------------------------------------
	result += "\n" + line + "//\tv~eBu\n" + line;
	result += temp.format("\tő_TCY\t\t\t\t\t%.2f\n", getMaxPointSize());
	result += "\tCeNX`\t\t\t\t";
	result += supportedString(supportedLineTexture());
	result += "\tCZeXg\t\t\t\t\t";
	result += supportedString(supportedLineZTest());
	result += "\tCuh\t\t\t\t\t";
	result += supportedString(supportedLineBlend());
	result += "\tCAt@r\t\t\t\t";
	result += supportedString(supportedLineAlphaCompare());
	result += "\tCtHO\t\t\t\t\t";
	result += supportedString(supportedLineFog());
	result += "\tCA`GCAX\t\t\t";
	result += supportedString(supportedLineAntialias());

	//--------------------------------------------------------------------------
	// _
	//--------------------------------------------------------------------------
	result += "\n" + line + "//\t_\n" + line;
	result += temp.format("\tőv~eBu\t\t\t\t%d\n",
		getMaxPrimitiveCount());
	result += temp.format("\tőCfbNX\t\t\t\t%d\n",
		getMaxVertexIndex());
	result += temp.format("\tőXg[\t\t\t\t%d\n", getMaxStreams());
	result += temp.format("\tő僉Cg\t\t\t\t\t%d\n", getMaxActiveLights());
	result += temp.format("\tőWl\t\t\t\t\t\t\t%.2e\n", getMaxVertexW());
	result += temp.format("\tőuhs\t\t\t\t%d\n",
		getMaxVertexBlendMatrices());
	result += temp.format("\tőuhsCfbNX\t%d\n",
		getMaxVertexBlendMatrixIndex());
	result += temp.format("\tK[hoh\t\t\t\t\t%.2e\n",
		getGuardBandLeft());
	result += temp.format("\tK[hoh\t\t\t\t\t%.2e\n", getGuardBandTop());
	result += temp.format("\tK[hohE\t\t\t\t\t%.2e\n",
		getGuardBandRight());
	result += temp.format("\tK[hoh\t\t\t\t\t%.2e\n",
		getGuardBandBottom());
	result += temp.format("\tő僆[UNbv\t\t\t%d\n",
		getMaxUserCliplanes());

	result += "\tTexgen\t\t\t\t\t\t\t";
	result += supportedString(supportedTexGen());
	result += "\tJ[}eA\[X\t\t\t";
	result += supportedString(supportedMaterialSource());
	result += "\tfBNViCg\t\t\t";
	result += supportedString(supportedDirectionalLights());
	result += "\t|WVCg\t\t\t\t";
	result += supportedString(supportedPositionalLights());
	result += "\t[Jr[\t\t\t\t";
	result += supportedString(supportedLocalViewer());
	result += "\t_gDC[jO\t\t\t\t";
	result += supportedString(supportedTweening());
	result += "\tXtBA}bv\t\t\t\t\t";
	result += supportedString(supportedTexgenSpheremap());
	result += "\t[Jr[OTexgens\t";
	result += supportedString(supportedNoTexgenNonLocalViewer());

	//--------------------------------------------------------------------------
	// _tH[}bg
	//--------------------------------------------------------------------------
	result += "\n" + line + "//\t_tH[}bg\n" + line;
	result += "\tFVFeNX`WJEg}XN\t";
	result += supportedString(supportedFvfTexCoordCountMask());
	result += "\tFVF_ɗ]ȗvf܂߂\t";
	result += supportedString(supportedFvfDoNotStripElements());
	result += "\tFVF_TCY\t\t\t\t\t";
	result += supportedString(supportedFvfPSize());
	result += "\tu_byte4錾\t\t\t\t\t\t";
	result += supportedString(supportedDeclUByte4());
	result += "\tu_byte4N錾\t\t\t\t\t";
	result += supportedString(supportedDeclUByte4N());
	result += "\tshort2N錾\t\t\t\t\t\t";
	result += supportedString(supportedDeclShort2N());
	result += "\tshort4N錾\t\t\t\t\t\t";
	result += supportedString(supportedDeclShort4N());
	result += "\tu_short2N錾\t\t\t\t\t";
	result += supportedString(supportedDeclUShort2N());
	result += "\tu_short4N錾\t\t\t\t\t";
	result += supportedString(supportedDeclUShort4N());
	result += "\tuDec3錾\t\t\t\t\t\t";
	result += supportedString(supportedDeclUDec3());
	result += "\tdec3錾\t\t\t\t\t\t";
	result += supportedString(supportedDeclDec3());
	result += "\tfloat16_2錾\t\t\t\t\t";
	result += supportedString(supportedDeclFloat16_2());
	result += "\tfloat16_4錾\t\t\t\t\t";
	result += supportedString(supportedDeclFloat16_4());

	//--------------------------------------------------------------------------
	// ebZ[V
	//--------------------------------------------------------------------------
	result += "\n" + line + "//\tebZ[V\n" + line;
	result += temp.format("\tNpb`ő啪x\t\t\t%.2f\n",
		getMaxNPatchTesselationLevel());
	result += "\tXg[ItZbg\t\t\t";
	result += supportedString(supportedStreamOffset());
	result += "\tfBXv[XgNpb`\t\t";
	result += supportedString(supportedDmapNPatch());
	result += "\tK^RTpb`\t\t\t\t\t";
	result += supportedString(supportedAdaptiveTessRTPatch());
	result += "\tK^Npb`\t\t\t\t\t";
	result += supportedString(supportedAdaptiveTessNPatch());
	result += "\teNX`StretchRect\t\t";
	result += supportedString(supportedCanStretchRectFromTextures());
	result += "\tvfBXv[XhNpb`\t\t";
	result += supportedString(supportedPreSampledDmapNPatch());
	result += "\tXg[ItZbgL\t\t";
	result += supportedString(supportedVertexElementsCanShareStreamOffset());

	//--------------------------------------------------------------------------
	// VF[fBO
	//--------------------------------------------------------------------------
	result += "\n" + line + "//\tVF[fBO\n" + line;
	result += "\tJ[O[\t\t\t\t\t";
	result += supportedString(supportedShadeColorGouraudRGB());
	result += "\tXyLO[\t\t\t\t";
	result += supportedString(supportedShadeSpecularGouraudRGB());
	result += "\tAt@O[\t\t\t\t\t";
	result += supportedString(supportedShadeAlphaGouraudBlend());
	result += "\ttHOO[\t\t\t\t\t";
	result += supportedString(supportedShadeFogGouraud());

	//--------------------------------------------------------------------------
	// eNX`
	//--------------------------------------------------------------------------
	result += "\n" + line + "//\teNX`\n" + line;
	result += temp.format("\tőeNX`TCY\t\t\t( %d x %d )\n",
		getMaxTextureSize().width, getMaxTextureSize().height);
	result += temp.format("\tő{[eNX`\t\t%d\n",
		getMaxVolumeExtent());
	result += temp.format("\tőeNX`s[g\t\t%d\n",
		getMaxTextureRepeat());
	result += temp.format("\tőٕtB^l\t\t\t%d\n",
		getMaxAnisotropy());
	result += temp.format("\tőeNX`AXyNg\t\t%d\n",
		getMaxTextureAspectRaito());
	result += "\tp[XyNeBu␳\t\t\t";
	result += supportedString(supportedTexturePerspective());
	result += "\tӂ2̗ݏ̂\t\t\t\t\t";
	result += supportedString(supportedTexturePow2());
	result += "\tAt@\t\t\t\t\t\t";
	result += supportedString(supportedTextureAlpha());
	result += "\t`̂\t\t\t\t\t\t";
	result += supportedString(supportedTextureSquareOnly());
	result += "\ts[gXP[\t\t\t";
	result += supportedString(supportedTextureRepeatNotScaledBySize());
	result += "\tAt@pbg\t\t\t\t";
	result += supportedString(supportedTextureAlphaPalette());
	result += "\tӂ2̗ݏŖĂ悢\t\t\t";
	result += supportedString(supportedTextureNonPow2Conditional());
	result += "\tˉe\t\t\t\t\t\t\t";
	result += supportedString(supportedTextureProjected());
	result += "\tL[u}bv\t\t\t\t\t";
	result += supportedString(supportedTextureCubemap());
	result += "\t{[}bv\t\t\t\t";
	result += supportedString(supportedTextureVolumemap());
	result += "\t~bv}bv\t\t\t\t\t";
	result += supportedString(supportedTextureMipmap());
	result += "\tL[u~bv}bv\t\t\t";
	result += supportedString(supportedTextureMipmapCubemap());
	result += "\t{[~bv}bv\t\t\t";
	result += supportedString(supportedTextureMipmapVolumemap());
	result += "\tL[u}bvӂ2̗ݏ̂\t";
	result += supportedString(supportedTextureCubemapPow2());
	result += "\t{[}bvӂ2̗ݏ̂\t";
	result += supportedString(supportedTextureVolumemapPow2());
	result += "\tˉeov}bv\t\t";
	result += supportedString(supportedTextureNoProjectedBumpEnvironment());

	//--------------------------------------------------------------------------
	// eNX`AhX
	//--------------------------------------------------------------------------
	result += "\n" + line + "//\teNX`AhX\n" + line;
	result += "\tbv\t\t\t\t\t\t\t";
	result += supportedString(supportedTextureAddressWrap());
	result += "\t~[\t\t\t\t\t\t\t";
	result += supportedString(supportedTextureAddressMirror());
	result += "\tUṼNv\t\t\t\t\t";
	result += supportedString(supportedTextureAddressClamp());
	result += "\tEF̐ݒ\t\t\t\t\t";
	result += supportedString(supportedTextureAddressBorder());
	result += "\tƗUV[h\t\t\t\t\t";
	result += supportedString(supportedTextureAddressIndependentUV());
	result += "\t1~[\t\t\t\t\t\t";
	result += supportedString(supportedTextureAddressMirrorOnce());
	result += "\t{[bv\t\t\t\t";
	result += supportedString(supportedVolumeTextureAddressWrap());
	result += "\t{[~[\t\t\t\t";
	result += supportedString(supportedVolumeTextureAddressMirror());
	result += "\t{[UṼNv\t\t\t";
	result += supportedString(supportedVolumeTextureAddressClamp());
	result += "\t{[EF̐ݒ\t\t\t";
	result += supportedString(supportedVolumeTextureAddressBorder());
	result += "\t{[ƗUV[h\t\t\t";
	result += supportedString(supportedVolumeTextureAddressIndependentUV());
	result += "\t{[1~[\t\t\t";
	result += supportedString(supportedVolumeTextureAddressMirrorOnce());

	//--------------------------------------------------------------------------
	// eNX`tB^
	//--------------------------------------------------------------------------
	result += "\n" + line + "//\teNX`tB^\n" + line;
	result += "\tk|Cg\t\t\t\t\t";
	result += supportedString(supportedTextureFilterMinPoint());
	result += "\tk`\t\t\t\t\t\t";
	result += supportedString(supportedTextureFilterMinLiner());
	result += "\tkٕ\t\t\t\t\t\t";
	result += supportedString(supportedTextureFilterMinAnisotropic());
	result += "\tks~bh\t\t\t\t\t";
	result += supportedString(supportedTextureFilterMinPyramidalQuad());
	result += "\tk2KEX\t\t\t\t\t";
	result += supportedString(supportedTextureFilterMinGaussianQuad());
	result += "\tg|Cg\t\t\t\t\t";
	result += supportedString(supportedTextureFilterMagPoint());
	result += "\tg`\t\t\t\t\t\t";
	result += supportedString(supportedTextureFilterMagLiner());
	result += "\tgٕ\t\t\t\t\t\t";
	result += supportedString(supportedTextureFilterMagAnisotropic());
	result += "\tgs~bh\t\t\t\t\t";
	result += supportedString(supportedTextureFilterMagPyramidalQuad());
	result += "\tg2KEX\t\t\t\t\t";
	result += supportedString(supportedTextureFilterMagGaussianQuad());
	result += "\t~bv}bv|Cg\t\t\t";
	result += supportedString(supportedTextureFilterMipmapPoint());
	result += "\t~bv}bv`\t\t\t\t";
	result += supportedString(supportedTextureFilterMipmapLiner());

	result += "\n" + line;
	result += "\tL[uk|Cg\t\t\t";
	result += supportedString(supportedCubeTextureFilterMinPoint());
	result += "\tL[uk`\t\t\t\t";
	result += supportedString(supportedCubeTextureFilterMinLiner());
	result += "\tL[ukٕ\t\t\t\t";
	result += supportedString(supportedCubeTextureFilterMinAnisotropic());
	result += "\tL[uks~bh\t\t\t";
	result += supportedString(supportedCubeTextureFilterMinPyramidalQuad());
	result += "\tL[uk2KEX\t\t\t";
	result += supportedString(supportedCubeTextureFilterMinGaussianQuad());
	result += "\tL[ug|Cg\t\t\t";
	result += supportedString(supportedCubeTextureFilterMagPoint());
	result += "\tL[ug`\t\t\t\t";
	result += supportedString(supportedCubeTextureFilterMagLiner());
	result += "\tL[ugٕ\t\t\t\t";
	result += supportedString(supportedCubeTextureFilterMagAnisotropic());
	result += "\tL[ugs~bh\t\t\t";
	result += supportedString(supportedCubeTextureFilterMagPyramidalQuad());
	result += "\tL[ug2KEX\t\t\t";
	result += supportedString(supportedCubeTextureFilterMagGaussianQuad());
	result += "\tL[u~bv}bv|Cg\t";
	result += supportedString(supportedCubeTextureFilterMipmapPoint());
	result += "\tL[u~bv}bv`\t\t";
	result += supportedString(supportedCubeTextureFilterMipmapLiner());

	result += "\n" + line;
	result += "\t{[k|Cg\t\t\t";
	result += supportedString(supportedVolumeTextureFilterMinPoint());
	result += "\t{[k`\t\t\t\t";
	result += supportedString(supportedVolumeTextureFilterMinLiner());
	result += "\t{[kٕ\t\t\t";
	result += supportedString(supportedVolumeTextureFilterMinAnisotropic());
	result += "\t{[ks~bh\t\t";
	result += supportedString(supportedVolumeTextureFilterMinPyramidalQuad());
	result += "\t{[k2KEX\t\t\t";
	result += supportedString(supportedVolumeTextureFilterMinGaussianQuad());
	result += "\t{[g|Cg\t\t\t";
	result += supportedString(supportedVolumeTextureFilterMagPoint());
	result += "\t{[g`\t\t\t\t";
	result += supportedString(supportedVolumeTextureFilterMagLiner());
	result += "\t{[gٕ\t\t\t";
	result += supportedString(supportedVolumeTextureFilterMagAnisotropic());
	result += "\t{[gs~bh\t\t";
	result += supportedString(supportedVolumeTextureFilterMagPyramidalQuad());
	result += "\t{[g2KEX\t\t\t";
	result += supportedString(supportedVolumeTextureFilterMagGaussianQuad());
	result += "\t{[~bv}bv|Cg\t";
	result += supportedString(supportedVolumeTextureFilterMipmapPoint());
	result += "\t{[~bv}bv`\t\t";
	result += supportedString(supportedVolumeTextureFilterMipmapLiner());

	result += "\n" + line;
	result += "\t_k|Cg\t\t\t\t";
	result += supportedString(supportedVertexTextureFilterMinPoint());
	result += "\t_k`\t\t\t\t\t";
	result += supportedString(supportedVertexTextureFilterMinLiner());
	result += "\t_kٕ\t\t\t\t\t";
	result += supportedString(supportedVertexTextureFilterMinAnisotropic());
	result += "\t_ks~bh\t\t\t\t";
	result += supportedString(supportedVertexTextureFilterMinPyramidalQuad());
	result += "\t_k2KEX\t\t\t\t";
	result += supportedString(supportedVertexTextureFilterMinGaussianQuad());
	result += "\t_g|Cg\t\t\t\t";
	result += supportedString(supportedVertexTextureFilterMagPoint());
	result += "\t_g`\t\t\t\t\t";
	result += supportedString(supportedVertexTextureFilterMagLiner());
	result += "\t_gٕ\t\t\t\t\t";
	result += supportedString(supportedVertexTextureFilterMagAnisotropic());
	result += "\t_gs~bh\t\t\t\t";
	result += supportedString(supportedVertexTextureFilterMagPyramidalQuad());
	result += "\t_g2KEX\t\t\t\t";
	result += supportedString(supportedVertexTextureFilterMagGaussianQuad());
	result += "\t_~bv}bv|Cg\t\t";
	result += supportedString(supportedVertexTextureFilterMipmapPoint());
	result += "\t_~bv}bv`\t\t\t";
	result += supportedString(supportedVertexTextureFilterMipmapLiner());

	//--------------------------------------------------------------------------
	// eNX`Xe[W
	//--------------------------------------------------------------------------
	result += "\n" + line + "//\teNX`Xe[W\n" + line;
	result += temp.format("\tőeNX`Xe[W\t\t\t\t%d\n",
		getMaxTextureBlendStages());
	result += temp.format("\tő}`eNX`\t\t\t\t\t%d\n",
		getMaxSimultaneousTextures());
	result += "\tDisableIy[V\t\t\t\t\t";
	result += supportedString(supportedTextureOperationDisable());
	result += "\tSelectArg1Iy[V\t\t\t\t";
	result += supportedString(supportedTextureOperationSelectArg1());
	result += "\tSelectArg2Iy[V\t\t\t\t";
	result += supportedString(supportedTextureOperationSelectArg2());
	result += "\tModulateIy[V\t\t\t\t\t";
	result += supportedString(supportedTextureOperationModulate());
	result += "\tModulate2xIy[V\t\t\t\t";
	result += supportedString(supportedTextureOperationModulate2x());
	result += "\tModulate4xIy[V\t\t\t\t";
	result += supportedString(supportedTextureOperationModulate4x());
	result += "\tAddIy[V\t\t\t\t\t\t";
	result += supportedString(supportedTextureOperationAdd());
	result += "\tAddSignedIy[V\t\t\t\t\t";
	result += supportedString(supportedTextureOperationAddSigned());
	result += "\tAddSigned2xIy[V\t\t\t\t";
	result += supportedString(supportedTextureOperationAddSigned2x());
	result += "\tSubtractIy[V\t\t\t\t\t";
	result += supportedString(supportedTextureOperationSubtract());
	result += "\tAddSmoothIy[V\t\t\t\t\t";
	result += supportedString(supportedTextureOperationAddSmooth());
	result += "\tBlendDiffuseAlphaIy[V\t\t\t";
	result += supportedString(supportedTextureOperationBlendDiffuseAlpha());
	result += "\tBlendTextureAlphaIy[V\t\t\t";
	result += supportedString(supportedTextureOperationBlendTextureAlpha());
	result += "\tBlendFactorAlphaIy[V\t\t\t";
	result += supportedString(supportedTextureOperationBlendFactorAlpha());
	result += "\tBlendTextureAlphaPMIy[V\t\t";
	result += supportedString(supportedTextureOperationBlendTextureAlphaPM());
	result += "\tBlendCurrentAlphaIy[V\t\t\t";
	result += supportedString(supportedTextureOperationBlendCurrentAlpha());
	result += "\tPreModulateIy[V\t\t\t\t";
	result += supportedString(supportedTextureOperationPreModulate());
	result += "\tModulateAlphaAddColorIy[V\t\t";
	result += supportedString(supportedTextureOperationModulateAlphaAddColor());
	result += "\tModulateColorAddAlphaIy[V\t\t";
	result += supportedString(supportedTextureOperationModulateColorAddAlpha());
	result += "\tModulateInvAlphaAddColorIy[V\t";
	result += supportedString(supportedTextureOperationModulateInvAlphaAddColor());
	result += "\tModulateInvColorAddAlphaIy[V\t";
	result += supportedString(supportedTextureOperationModulateInvColorAddAlpha());
	result += "\tBumpEnvMapIy[V\t\t\t\t";
	result += supportedString(supportedTextureOperationBumpEnvMap());
	result += "\tBumpEnvMapLuminanceIy[V\t\t";
	result += supportedString(supportedTextureOperationBumpEnvMapLuminance());
	result += "\tDotProduct3Iy[V\t\t\t\t";
	result += supportedString(supportedTextureOperationDotProduct3());
	result += "\tMultiplyAddIy[V\t\t\t\t";
	result += supportedString(supportedTextureOperationMultiplyAdd());
	result += "\tLerpIy[V\t\t\t\t\t\t";
	result += supportedString(supportedTextureOperationLerp());

	//--------------------------------------------------------------------------
	// r
	//--------------------------------------------------------------------------
	result += "\n" + line + "//\tr\n" + line;
	result += "\tZrNever\t\t\t\t\t\t";
	result += supportedString(supportedZCompareNever());
	result += "\tZrLess\t\t\t\t\t\t";
	result += supportedString(supportedZCompareLess());
	result += "\tZrEqual\t\t\t\t\t\t";
	result += supportedString(supportedZCompareEqual());
	result += "\tZrLessEqual\t\t\t\t\t";
	result += supportedString(supportedZCompareLessEqual());
	result += "\tZrGreater\t\t\t\t\t";
	result += supportedString(supportedZCompareGreater());
	result += "\tZrNotEqual\t\t\t\t\t";
	result += supportedString(supportedZCompareNotEqual());
	result += "\tZrGreaterEqual\t\t\t\t";
	result += supportedString(supportedZCompareGreaterEqual());
	result += "\tZrAlways\t\t\t\t\t\t";
	result += supportedString(supportedZCompareAlways());

	result += "\n" + line;
	result += "\tXeVKeep\t\t\t\t\t";
	result += supportedString(supportedStencilKeep());
	result += "\tXeVZero\t\t\t\t\t";
	result += supportedString(supportedStencilZero());
	result += "\tXeVReplace\t\t\t\t";
	result += supportedString(supportedStencilReplace());
	result += "\tXeVIncrSat\t\t\t\t";
	result += supportedString(supportedStencilIncrSat());
	result += "\tXeVDecrSat\t\t\t\t";
	result += supportedString(supportedStencilDecrSat());
	result += "\tXeVInvert\t\t\t\t";
	result += supportedString(supportedStencilInvert());
	result += "\tXeVIncr\t\t\t\t\t";
	result += supportedString(supportedStencilIncr());
	result += "\tXeVDecr\t\t\t\t\t";
	result += supportedString(supportedStencilDecr());
	result += "\tXeVTwoSided\t\t\t\t";
	result += supportedString(supportedStencilTwoSided());

	result += "\n" + line;
	result += "\tAt@rNever\t\t\t\t";
	result += supportedString(supportedAlphaCompareNever());
	result += "\tAt@rLess\t\t\t\t";
	result += supportedString(supportedAlphaCompareLess());
	result += "\tAt@rEqual\t\t\t\t";
	result += supportedString(supportedAlphaCompareEqual());
	result += "\tAt@rLessEqual\t\t\t";
	result += supportedString(supportedAlphaCompareLessEqual());
	result += "\tAt@rGreater\t\t\t\t";
	result += supportedString(supportedAlphaCompareGreater());
	result += "\tAt@rNotEqual\t\t\t";
	result += supportedString(supportedAlphaCompareNotEqual());
	result += "\tAt@rGreaterEqual\t\t";
	result += supportedString(supportedAlphaCompareGreaterEqual());
	result += "\tAt@rAlways\t\t\t\t";
	result += supportedString(supportedAlphaCompareAlways());

	//--------------------------------------------------------------------------
	// ufBO
	//--------------------------------------------------------------------------
	result += "\n" + line + "//\tufBO\n" + line;
	result += "\t\[XZero\t\t\t\t\t\t\t";
	result += supportedString(supportedBlendSourceZero());
	result += "\t\[XOne\t\t\t\t\t\t\t";
	result += supportedString(supportedBlendSourceOne());
	result += "\t\[XSrcColor\t\t\t\t\t\t";
	result += supportedString(supportedBlendSourceSrcColor());
	result += "\t\[XInvSrcColor\t\t\t\t\t";
	result += supportedString(supportedBlendSourceInvSrcColor());
	result += "\t\[XSrcAlpha\t\t\t\t\t\t";
	result += supportedString(supportedBlendSourceSrcAlpha());
	result += "\t\[XInvSrcAlpha\t\t\t\t\t";
	result += supportedString(supportedBlendSourceInvSrcAlpha());
	result += "\t\[XDestAlpha\t\t\t\t\t\t";
	result += supportedString(supportedBlendSourceDestAlpha());
	result += "\t\[XInvDestAlpha\t\t\t\t\t";
	result += supportedString(supportedBlendSourceInvDestAlpha());
	result += "\t\[XDestColor\t\t\t\t\t\t";
	result += supportedString(supportedBlendSourceDestColor());
	result += "\t\[XInvDestColor\t\t\t\t\t";
	result += supportedString(supportedBlendSourceInvDestColor());
	result += "\t\[XSrcAlphaSat\t\t\t\t\t";
	result += supportedString(supportedBlendSourceSrcAlphaSat());
	result += "\t\[XBothSrcAlpha\t\t\t\t\t";
	result += supportedString(supportedBlendSourceBothSrcAlpha());
	result += "\t\[XBothInvSrcAlpha\t\t\t\t";
	result += supportedString(supportedBlendSourceBothInvSrcAlpha());
	result += "\t\[XBlendFactor\t\t\t\t\t";
	result += supportedString(supportedBlendSourceBlendFactor());

	result += "\n" + line;
	result += "\tfXeBl[VZero\t\t\t\t";
	result += supportedString(supportedBlendDestinationZero());
	result += "\tfXeBl[VOne\t\t\t\t";
	result += supportedString(supportedBlendDestinationOne());
	result += "\tfXeBl[VSrcColor\t\t\t";
	result += supportedString(supportedBlendDestinationSrcColor());
	result += "\tfXeBl[VInvSrcColor\t\t";
	result += supportedString(supportedBlendDestinationInvSrcColor());
	result += "\tfXeBl[VSrcAlpha\t\t\t";
	result += supportedString(supportedBlendDestinationSrcAlpha());
	result += "\tfXeBl[VInvSrcAlpha\t\t";
	result += supportedString(supportedBlendDestinationInvSrcAlpha());
	result += "\tfXeBl[VDestAlpha\t\t\t";
	result += supportedString(supportedBlendDestinationDestAlpha());
	result += "\tfXeBl[VInvDestAlpha\t\t";
	result += supportedString(supportedBlendDestinationInvDestAlpha());
	result += "\tfXeBl[VDestColor\t\t\t";
	result += supportedString(supportedBlendDestinationDestColor());
	result += "\tfXeBl[VInvDestColor\t\t";
	result += supportedString(supportedBlendDestinationInvDestColor());
	result += "\tfXeBl[VSrcAlphaSat\t\t";
	result += supportedString(supportedBlendDestinationSrcAlphaSat());
	result += "\tfXeBl[VBothSrcAlpha\t\t";
	result += supportedString(supportedBlendDestinationBothSrcAlpha());
	result += "\tfXeBl[VBothInvSrcAlpha\t";
	result += supportedString(supportedBlendDestinationBothInvSrcAlpha());
	result += "\tfXeBl[VBlendFactor\t\t";
	result += supportedString(supportedBlendDestinationBlendFactor());

	//--------------------------------------------------------------------------
	// X^CY
	//--------------------------------------------------------------------------
	result += "\n" + line + "//\tX^CY\n" + line;
	result += temp.format("\tA`GCAXg\t\t\t%.2f\n",
		getExtentsAdjust());
	result += "\tfBU\t\t\t\t\t\t\t";
	result += supportedString(supportedRasterDither());
	result += "\tZeXg\t\t\t\t\t\t\t";
	result += supportedString(supportedRasterZTest());
	result += "\t_tHO\t\t\t\t\t\t";
	result += supportedString(supportedRasterFogVertex());
	result += "\ttHOe[u\t\t\t\t\t";
	result += supportedString(supportedRasterFogTable());
	result += "\t~bv}bvoCAX\t\t\t";
	result += supportedString(supportedRasterMipmapLODBias());
	result += "\tBʏ\t\t\t\t\t\t";
	result += supportedString(supportedRasterZBufferLessHSR());
	result += "\tWtHO\t\t\t\t\t";
	result += supportedString(supportedRasterFogRange());
	result += "\tٕtB^O\t\t\t";
	result += supportedString(supportedRasterAnisotropy());
	result += "\tWobt@\t\t\t\t\t\t";
	result += supportedString(supportedRasterWBuffer());
	result += "\tWtHO\t\t\t\t\t\t\t";
	result += supportedString(supportedRasterWFog());
	result += "\tZtHO\t\t\t\t\t\t\t";
	result += supportedString(supportedRasterZFog());
	result += "\tFp[XyNeBu␳\t\t\t";
	result += supportedString(supportedRasterColorPerspective());
	result += "\tVU[eXg\t\t\t\t\t";
	result += supportedString(supportedRasterScissorTest());
	result += "\tX[vXP[[xoCAX\t";
	result += supportedString(supportedRasterSlopeScaleDepthBias());
	result += "\t[xoCAX\t\t\t\t\t";
	result += supportedString(supportedRasterDepthBias());
	result += "\t}`Tv؂ւ\t\t\t";
	result += supportedString(supportedRasterMultiSampleToggle());


	//--------------------------------------------------------------------------
	// _VF[_
	//--------------------------------------------------------------------------
	result += "\n" + line + "//\t_VF[_\n" + line;
	result += temp.format("\t_VF[_o[W\t\t\t%d.%d\n",
		getVertexShaderMajorVersion(), getVertexShaderMinorVersion());
	result += temp.format("\tő咸_VF[_萔\t\t\t%d\n",
		getMaxVertexShaderConst());
	result += temp.format("\tőXg[XgCh\t\t%d\n",
		getMaxStreamStride());
	result += temp.format("\tő喽ߎs\t\t\t\t\t%d\n",
		getMaxVShaderInstructionsExecuted());
	result += temp.format("\tő喽߃Xbg\t\t\t\t%d\n",
		getMaxVertexShader30InstructionSlots());
	result += temp.format("\tIt[lXgx\t\t\t%d\n",
		getVertexShaderDynamicFlowControlDepth());
	result += temp.format("\te|\t\t\t\t\t%d\n",
		getVertexShaderNumTemps());
	result += temp.format("\tÓIt[lXgx\t\t\t%d\n",
		getVertexShaderStaticFlowControlDepth());
	result += "\tvfBP[V\t\t\t";
	result += supportedString(supportedVertexShaderPredication());

 	//--------------------------------------------------------------------------
	// sNZVF[_
	//--------------------------------------------------------------------------
	result += "\n" + line + "//\tsNZVF[_\n" + line;
	result += temp.format("\tsNZVF[_o[W\t\t%d.%d\n",
		getPixelShaderMajorVersion(), getPixelShaderMinorVersion());
	result += temp.format("\tsNZVF[_1xől\t\t%.2f\n",
		getPixelShader1xMaxValue());
	result += temp.format("\tő喽ߎs\t\t\t\t\t%d\n",
		getMaxPShaderInstructionsExecuted());
	result += temp.format("\tő喽߃Xbg\t\t\t\t%d\n",
		getMaxPixelShader30InstructionSlots());
	result += temp.format("\tIt[lXgx\t\t\t%d\n",
		getPixelShaderDynamicFlowControlDepth());
	result += temp.format("\te|\t\t\t\t\t%d\n",
		getPixelShaderNumTemps());
	result += temp.format("\tÓIt[lXgx\t\t\t%d\n",
		getPixelShaderStaticFlowControlDepth());
	result += temp.format("\t߃Xbg\t\t\t\t\t%d\n",
		getPixelShaderNumInstructionSlots());
	result += "\tCӂ̓ւ\t\t\t\t\t";
	result += supportedString(supportedPixelShaderArbitrarySwizzle());
	result += "\tOf[V\t\t\t\t";
	result += supportedString(supportedPixelShaderGradientInstructions());
	result += "\tvfBP[V\t\t\t";
	result += supportedString(supportedPixelShaderPredication());
	result += "\t]ǂݍݖ\t\t\t\t";
	result += supportedString(supportedPixelShaderNoDependentReadLimit());
	result += "\ttexߖ\t\t\t\t\t";
	result += supportedString(supportedPixelShaderNoTexnstructionLimit());

	//--------------------------------------------------------------------------
	result += "\n" + line;
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
