//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OtBbNXfoCX
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/System/GraphicsDevice.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/DeviceSelector/GraphicsDeviceSelector.h"
#include "Graphics/System/GraphicsDeviceSettings.h"
#include "Graphics/Enumeration/GraphicsDeviceInformation.h"

namespace Lamp{

// CX^X
GraphicsDevice* GraphicsDevice::instance_ = NULL;

//------------------------------------------------------------------------------
// RXgN^
GraphicsDevice::GraphicsDevice(){
	Assert(instance_ == NULL);
	instance_ = this;
	direct3DDevice_ = NULL;
	::memset(&presentationParameter_, 0, sizeof(D3DPRESENT_PARAMETERS));
	settings_ = NULL;
	windowHandle_ = NULL;
	windowStyle_ = 0;
	SetRect(&windowBoundsSize_, 0, 0, 0, 0);
	SetRect(&windowClientSize_, 0, 0, 0, 0);
	menuHandle_ = NULL;
	deviceLost_ = false;
	clipCursor_ = true;
	ignoreSizeChange_ = false;
	windowMaximized_ = false;
	windowMinimized_ = false;
}
//------------------------------------------------------------------------------
// fXgN^
GraphicsDevice::~GraphicsDevice(){
	Assert(instance_ == this);
	instance_ = NULL;
}
//------------------------------------------------------------------------------
// NA
void GraphicsDevice::clear(Color4c color, float zValue, u_int stencilValue){
	u_int clearFlag = D3DCLEAR_TARGET;
	if(settings_->getDepthStencilEnabled()){ clearFlag |= D3DCLEAR_ZBUFFER; }
	direct3DDevice_->Clear(
		0, NULL, clearFlag, color.getARGB(), zValue, stencilValue);
}
//------------------------------------------------------------------------------
// v[e[V
bool GraphicsDevice::presentation(){
	// foCXXgĂȂƂmFĂVXe[vsA
	// `sC[`z肵Ă
	HRESULT result;
	// foCXXg
	if(deviceLost_){
		result = direct3DDevice_->TestCooperativeLevel();
		if(DirectXFailed(result)){
			// foCXZbgv
			if(result == D3DERR_DEVICENOTRESET){
				if(settings_->isWindowed()){
					// fXNgbvfBXvCtH[}bgύXꂽ̂
					// v[e[Vp[^č\z
					LampGraphics::getDeviceSelector()->findBestWindowedMode(
						windowHandle_, false, false);
					settings_->buildPresentationParameters(
						&presentationParameter_, windowHandle_);
				}
				if(!reset()){
					ErrorOut("GraphicsDevice::presentation() reset()");
				}
			}
		}else{
			// foCXXg
			deviceLost_ = false;
		}
	}else{
		result = direct3DDevice_->Present(NULL, NULL, NULL, NULL);
		// foCXXg`FbN
		if(result == D3DERR_DEVICELOST){ deviceLost_ = true; }
	}
	return deviceLost_;
}
//------------------------------------------------------------------------------
// tXN[[hƃEBhE[h؂ւ
void GraphicsDevice::toggleFullscreen(){
	// foCX̃obNAbv
	GraphicsDeviceInformation* deviceInfoOld =
		settings_->getDeviceInformation();
	int adapterOrdinalOld = deviceInfoOld->getAdapterOrdinal();
	D3DDEVTYPE deviceTypeOld = deviceInfoOld->getDeviceType();
	// TCYύX𖳎
	ignoreSizeChange_ = true;
	// EBhEtO]
	settings_->setWindowed(!settings_->isWindowed());
	// EBhE̒s
	adjustWindowForChange();
	// 3D̍č\z
	bool result;
	GraphicsDeviceInformation* deviceInfo = settings_->getDeviceInformation();
	if((deviceInfo->getAdapterOrdinal() == adapterOrdinalOld) &&
		(deviceInfo->getDeviceType() == deviceTypeOld)){
		// Zbg
		settings_->buildPresentationParameters(
			&presentationParameter_, windowHandle_);
		result = reset();
	}else{
		// č\z
		result = rebuild();
	}
	// ؂ւs猳ɖ߂
	if(!result){ toggleFullscreen(); }
	// TCYύX𖳎Ȃ
	ignoreSizeChange_ = false;
}
//------------------------------------------------------------------------------
// IɃEBhE[hɂ
void GraphicsDevice::forceWindowed(){
	if(settings_->isWindowed()){ return; }
	LampGraphics::getDeviceSelector()->findBestWindowedMode(
		windowHandle_, false, false);
	if(!rebuild()){ ErrorOut("GraphicsDevice::forceWindowed() rebuild()"); }
}
//------------------------------------------------------------------------------
// rh
bool GraphicsDevice::rebuild(){
	cleanup();
	return initialize();
}
//------------------------------------------------------------------------------
// EBhEnh̏
void GraphicsDevice::initializeWindowHandle(HWND windowHandle){
	// EBhEvpeB̎擾
	windowHandle_ = windowHandle;
	windowStyle_ = ::GetWindowLong(windowHandle_, GWL_STYLE);
	::GetWindowRect(windowHandle_, &windowBoundsSize_);
	::GetClientRect(windowHandle_, &windowClientSize_);
	// foCXݒ̎擾
	settings_ = GraphicsDeviceSettings::getInstance();
}
//------------------------------------------------------------------------------
// 
bool GraphicsDevice::initialize(){
	// EBhE̒
	adjustWindowForChange();
	// v[e[Vp[^̍\z
	settings_->buildPresentationParameters(
		&presentationParameter_, windowHandle_);
	// _vZXtO̎擾
	u_int vertexProsessingFlag =
		settings_->getVertexProcessingType().getCreateFlag();
	// foCX̍쐬
	HRESULT result;
	Direct3D* direct3D = LampGraphics::getDirect3D();
	GraphicsDeviceInformation* deviceInfo = settings_->getDeviceInformation();
	result = direct3D->CreateDevice(
		deviceInfo->getAdapterOrdinal(),	// A_v^ԍ
		deviceInfo->getDeviceType(),		// foCX^Cv
		windowHandle_,						// EBhEnh
		vertexProsessingFlag,				// U镑tO
		&presentationParameter_,			// v[e[Vp[^
		&direct3DDevice_);					// foCX
	if(DirectXSucceeded(result)){
		// foCXZbgʒm
		LampGraphics::deviceReset();
		// J[\Nbv
		clipCursor();
		// foCXIuWFNgč\z
		if(!LampGraphics::initializeDeviceObjects()){
			LampGraphics::deleteDeviceObjects();
		}else{
			if(!LampGraphics::restoreDeviceObjects()){
				LampGraphics::invalidateDeviceObjects();
			}else{
				return true;
			}
		}
		cleanup();
	}
	// t@XX^CUł̋N
	if(deviceInfo->getDeviceType() == D3DDEVTYPE_HAL){
		if(LampGraphics::getDeviceSelector()->findBestWindowedMode(
			windowHandle_, false, true)){
			adjustWindowForChange();
			AssertMessage(false, "GraphicsDevice::initialize() "
				"Switched to REF");
			return initialize();
		}
	}
	return false;

}
//------------------------------------------------------------------------------
// Zbg
bool GraphicsDevice::reset(){
	// foCXIuWFNg
	LampGraphics::invalidateDeviceObjects();
	// Zbgs
	direct3DDevice_->Reset(&presentationParameter_);
	// foCXZbgʒm
	LampGraphics::deviceReset();
	// J[\Nbv
	clipCursor();
	// foCXIuWFNgč\z
	if(!LampGraphics::restoreDeviceObjects()){
		LampGraphics::invalidateDeviceObjects();
		return false;
	}
	return true;
}
//------------------------------------------------------------------------------
// J[\̃Nbv
void GraphicsDevice::clipCursor(){
	if(!clipCursor_){ return; }
	if(settings_->isWindowed()){
		ClipCursor(NULL);
	}else{
		RECT clipRect;
		GetWindowRect(windowHandle_, &clipRect);
		ClipCursor(&clipRect);
	}
}
//------------------------------------------------------------------------------
// n
void GraphicsDevice::cleanup(){
	// foCXIuWFNg̖
	LampGraphics::invalidateDeviceObjects();
	// foCXIuWFNg̔j
	LampGraphics::deleteDeviceObjects();
	// Direct3DDevicẻ
	SafeRelease(direct3DDevice_);
}
//------------------------------------------------------------------------------
// EBhEvV[W
LRESULT GraphicsDevice::windowProcedure(
	HWND windowHandle, u_int message, WPARAM wParam, LPARAM lParam){
	switch(message){
	// TCYύX
	case WM_SIZE:
		if(settings_->isWindowed() && windowHandle_ != NULL){
			windowStyle_ = GetWindowLong(windowHandle_, GWL_STYLE);
		}
		if(wParam == SIZE_MINIMIZED){
			// J[\̃Nbv𖳌ɂ
			if(clipCursor_ && (!settings_->isWindowed())){
				ClipCursor(NULL);
			}
			windowMinimized_ = true;
			windowMaximized_ = false;
		}else if(wParam == SIZE_MAXIMIZED){
			windowMaximized_ = true;
			windowMinimized_ = false;
			handlePossibleSizeChange();
		}else if(wParam == SIZE_RESTORED){
			if(windowMaximized_){
				windowMaximized_ = false;
				handlePossibleSizeChange();
			}else if(windowMinimized_){
				windowMinimized_ = false;
				handlePossibleSizeChange();
			}
			// hbOł̃TCYύXWM_EXITSIZEMOVEőΏ
		}
		break;
	// TCYύXI
	case WM_EXITSIZEMOVE:
		handlePossibleSizeChange();
		break;
	// tXN[Ƀj[I𖳌ɂ
	case WM_NCHITTEST:
		if(!settings_->isWindowed()){ return HTCLIENT; }
		break;
	// VXeR}h
	case WM_SYSCOMMAND:
		switch(wParam){
			// tXN[Ɉȉ̃CxgNȂ悤ɂ
			case SC_MOVE:
			case SC_SIZE:
			case SC_MAXIMIZE:
			case SC_KEYMENU:
			case SC_MONITORPOWER:
				if(!settings_->isWindowed()){ return 1; }
				break;
		}
		break;
	}
	return 0;
}
//------------------------------------------------------------------------------
// EBhE̒
void GraphicsDevice::adjustWindowForChange(){
	if(settings_->isWindowed()){
		// EBhEX^C̐ݒ
		SetWindowLong(windowHandle_, GWL_STYLE, windowStyle_);
		// j[nh̐ݒ
		if(menuHandle_ != NULL){
			SetMenu(windowHandle_, menuHandle_);
			menuHandle_ = NULL;
		}
		// EBhETCY̒
		SetWindowPos(windowHandle_, HWND_NOTOPMOST,
			windowBoundsSize_.left, windowBoundsSize_.top,
			(windowBoundsSize_.right - windowBoundsSize_.left),
			(windowBoundsSize_.bottom - windowBoundsSize_.top),
			SWP_SHOWWINDOW);
	}else{
		// EBhEX^C̐ݒ
		u_int fullScreenStyle = (WS_POPUP | WS_SYSMENU | WS_VISIBLE);
		SetWindowLong(windowHandle_, GWL_STYLE, fullScreenStyle);
		// j[nh̐ݒ
		if(menuHandle_ == NULL){
			menuHandle_ = GetMenu(windowHandle_);
			SetMenu(windowHandle_, NULL);
		}
	}
}
//------------------------------------------------------------------------------
// EBhETCYύX
void GraphicsDevice::handlePossibleSizeChange(){
	// tOĂΖ
	if(ignoreSizeChange_){ return; }
	// NCAgTCỸobNAbv
	RECT windowClientSizeOld =  windowClientSize_;
	// VTCY̎擾
	::GetWindowRect(windowHandle_, &windowBoundsSize_);
	::GetClientRect(windowHandle_, &windowClientSize_);
	// TCYςĂȂΖ
	int width = (windowClientSize_.right - windowClientSize_.left);
	int height = (windowClientSize_.bottom - windowClientSize_.top);
	if(((windowClientSizeOld.right - windowClientSizeOld.left) == width) &&
		((windowClientSizeOld.bottom - windowClientSizeOld.top) == height)){
		return;
	}
	settings_->setWindowSize(DimensionI(width, height));
	settings_->buildPresentationParameters(
		&presentationParameter_, windowHandle_);
	if(!reset()){
		ErrorOut("GraphicsDevice::handlePossibleSizeChange()");
	}
	// Ԃꂽʂ̕\sȂ悤ɂ
	clear();
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
