//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * VF[_
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Shader/Shader.h"
#include "Graphics/Renderer/Renderer.h"
#include "Graphics/Renderer/RenderingDevice.h"
#include "Graphics/Renderer/DrawRequest.h"
#include "Graphics/Mesh/Mesh.h"
#include "Graphics/Material/Material.h"
#include "Graphics/Texture/Texture.h"

namespace Lamp{

// őANeBuCg
const int Shader::maxActiveLightCount_ = Renderer::maxActiveLightCount_;

//------------------------------------------------------------------------------
// RXgN^
Shader::Shader(){
	device_ = RenderingDevice::getInstance();
}
//------------------------------------------------------------------------------
// fXgN^
Shader::~Shader(){
}
//------------------------------------------------------------------------------
// }eAJn̍\z
void Shader::buildMaterialStart(Material* material){
	// At@lFixedProgrammableňႤ̂ŃTuNXŐݒ肷

	// At@uh
	if(material->isBlendEnabled()){
		device_->setBlendMode(material->getBlendMode(),
			material->getBlendSource(), material->getBlendDestination());
	}

	// Z
	device_->setRenderState(D3DRS_ZWRITEENABLE, material->useZWrite());
	// ZeXg
	device_->setZTest(material->useZTest());
}
//------------------------------------------------------------------------------
// }eAI̍\z
//void Shader::buildMaterialEnd(Material* material){
//}
//------------------------------------------------------------------------------
// `
//------------------------------------------------------------------------------
// `R[
void Shader::drawCall(DrawRequest* request){
	Mesh* mesh = request->getMesh();
	// CfbNX
	if(mesh->hasVertexIndices()){
		// pCvCɊ֌WȂAbVf[^ȂΐݒsȂ
		if(request->isMeshDataChanged()){
			// CfbNXobt@ݒ
			device_->setIndexBuffer(mesh->getIndexBuffer());
		}
		// CfbNXOpXg`
		device_->drawIndexedTriangleList(
			mesh->getVertexCount(), mesh->getPrimitiveCount());
	}else{
		// OpXg`
		device_->drawTriangleList(mesh->getPrimitiveCount());
	}
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
