//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ŒpCvCVF[_
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Shader/FixedShader.h"
#include "Graphics/Renderer/RenderingDevice.h"
#include "Graphics/Renderer/DrawRequest.h"
#include "Graphics/Fog/Fog.h"
#include "Graphics/SceneNode/SceneNode.h"
#include "Graphics/Light/DirectionalLight.h"
#include "Graphics/Light/PointLight.h"
#include "Graphics/MeshData/MeshData.h"
#include "Graphics/Material/Material.h"
#include "Graphics/Texture/SurfaceTexture.h"


#include "Graphics/Model/Model.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
FixedShader::FixedShader(){
}
//------------------------------------------------------------------------------
// fXgN^
FixedShader::~FixedShader(){
}
//------------------------------------------------------------------------------
// Xe[gubN
//------------------------------------------------------------------------------
// }eAJn̍\z
void FixedShader::buildMaterialStart(Material* material){
	Shader::buildMaterialStart(material);
}
//------------------------------------------------------------------------------
// }eAI̍\z
//void FixedShader::buildMaterialEnd(Material* material){
//	Shader::buildMaterialEnd(material);
//}
//------------------------------------------------------------------------------
// eNX`
//------------------------------------------------------------------------------
// Œ@\eNX`ݒ
void FixedShader::setFixedTexture(int textureStage, Texture* texture){
	// eNX`ݒ
	device_->setTexture(textureStage, texture);
	// T[tF[XeNX`ݒ
	SurfaceTexture* surfaceTexture = texture->castSurfaceTexture();
	if(surfaceTexture != NULL){
		// UṼs[gƃItZbg
		device_->setTextureTransform2(textureStage,
			surfaceTexture->getRepeatUV(), surfaceTexture->getOffsetUV());
		// AhX[hݒ
		device_->setTextureAddressMode2(textureStage,
			surfaceTexture->getAddressModeU(),
			surfaceTexture->getAddressModeV());
	}
}
//------------------------------------------------------------------------------
// Œ@\x[XeNX`̐ݒ
int FixedShader::setFixedBaseTexture(
	int colorStage, Texture* baseTexture, int baseUVIndex){
	if(baseTexture == NULL){ return colorStage; }
	// eNX`ݒ
	setFixedTexture(colorStage, baseTexture);
	// Current * baseTexture
	device_->setColorTextureStage(colorStage,
		D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TEXTURE, baseUVIndex);
	colorStage++;
	return colorStage;
}
//------------------------------------------------------------------------------
// Œ@\CgeNX`̐ݒ
int FixedShader::setFixedLightTexture(
	int colorStage, Texture* lightTexture, int lightUVIndex){
	if(lightTexture == NULL){ return colorStage; }
	// eNX`ݒ
	setFixedTexture(colorStage, lightTexture);
	// Current + lightTexture
	device_->setColorTextureStage(colorStage,
		D3DTOP_ADD, D3DTA_CURRENT, D3DTA_TEXTURE, lightUVIndex);
	colorStage++;
	return colorStage;
}
//------------------------------------------------------------------------------
// Œ@\eNX`̐ݒ
int FixedShader::setFixedStainTexture(
	int colorStage, Texture* stainTexture, int stainUVIndex){
	if(stainTexture == NULL){ return colorStage; }
	// eNX`ݒ
	setFixedTexture(colorStage, stainTexture);
	// Current * stainTexture
	device_->setColorTextureStage(colorStage,
		D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TEXTURE, stainUVIndex);
	colorStage++;
	return colorStage;
}
//------------------------------------------------------------------------------
// `̏
//------------------------------------------------------------------------------
// Œ@\`̃ZbgAbv
void FixedShader::setupFixedDraw(DrawRequest* request){
	// @̐Kݒ
	device_->setRenderState(D3DRS_NORMALIZENORMALS,
		request->requireNormalize());
	// s̐ݒ
	setMatrixFixed(request);
	// tHOIvV̐ݒ
	setFogOptionFixed(request);
	// Cg̃ZbgAbv
	setupFixedLight(request);
}
//------------------------------------------------------------------------------
// Œ@\s̐ݒ
void FixedShader::setMatrixFixed(DrawRequest* request){
	if(request->isSceneNodeChanged()){
		device_->setWorldMatrix(request->getSceneNode()->getWorldMatrix());
	}
}
//------------------------------------------------------------------------------
// Œ@\tHOIvV̐ݒ
void FixedShader::setFogOptionFixed(DrawRequest* request){
	Material::FogOption fogOption = request->getMaterial()->getFogOption();
	if(fogOption == Material::fogOptionDisable){
		device_->setRenderState(D3DRS_FOGENABLE, false);
	}else if(fogOption == Material::fogOptionBlack){
		device_->setRenderState(D3DRS_FOGCOLOR, 0);
	}
}
//------------------------------------------------------------------------------
// Œ@\Cg̃ZbgAbv
void FixedShader::setupFixedLight(DrawRequest* request){
	Material* material = request->getMaterial();
	// CggpȂ̂ȂΉȂ
	if(!material->useLight()){ return; }

	// ArGgCg̐ݒ
	// Request̒lightMask肪sĂ
	device_->setAmbientColor(request->getAmbientColor());

	// fBNViCg̐ݒ
	u_int lightMask = material->getLightMask();
	int lightCount = 0;
	int directionalLightCount = request->getDirectionalLightCount();
	for(int i = 0; i < directionalLightCount; i++){
		DirectionalLight* directionalLight = request->getDirectionalLight(i);
		// lightMask
		if((directionalLight->getLightMask() & lightMask) == 0){ continue; }
		device_->enableDirectionalLight(lightCount, directionalLight);
		lightCount++;
		// ő僉Cgݒ肵I
		if(lightCount == maxActiveLightCount_){ return; }
	}

	// [JCg̐ݒ
	// V[烍[JCgXg擾鎞lightMask肪sĂ
	int localLightCount = request->getLocalLightCount();
	// [JCgő吔𒴂Ăꍇ\[g
	if(localLightCount + lightCount > maxActiveLightCount_){
		request->sortLocalLights();
	}
	for(int i = 0; i < localLightCount; i++){
		LocalLight* localLight = request->getLocalLight(i);
		if(localLight->isPointLight()){
			device_->enablePointLight(lightCount, localLight->castPointLight());
		}else{
			ErrorOut("FixedShader::setupFixedLight() T|[g̃Cgł");
		}
		lightCount++;
		// ő僉Cgݒ肵I
		if(lightCount == maxActiveLightCount_){ return; }
	}

	// Cg
	device_->closeLight(lightCount);
}
//------------------------------------------------------------------------------
// `
//------------------------------------------------------------------------------
// Œ@\`
void FixedShader::drawFixed(DrawRequest* request){
	Mesh* mesh = request->getMesh();
	// LN^ό`
	bool deformed = false;
	deformed |= mesh->characterDeform();
	if(deformed){
		// bV͕K񂵂`悳Ȃ̂ŃXg[LbVsȂ
		// ό`_Lqݒ
		device_->setVertexDeclaration(mesh->getDeformedVertexDeclaration());
		// ό`_obt@ݒ
		device_->setVertexBuffer(mesh->getDeformedVertexBuffer(),
			mesh->getDeformedVertexSize());
	// bVf[^ŃpCvCɕύX΃Xg[ݒsȂ
	}else if(request->isMeshDataChanged() || request->isPipelineModeChanged()){
		// _Lqݒ
		device_->setVertexDeclaration(mesh->getVertexDeclaration());
		// _obt@ݒ
		device_->setVertexBuffer(mesh->getVertexBuffer(),
			mesh->getVertexSize());
	}
	// `R[
	drawCall(request);
}
//------------------------------------------------------------------------------
// `̌n
//------------------------------------------------------------------------------
// Œ@\`̃Zbg
void FixedShader::resetFixedDraw(DrawRequest* request){
	// tHOIvṼZbg
	resetFogOptionFixed(request);
}
//------------------------------------------------------------------------------
// Œ@\tHOIvṼZbg
void FixedShader::resetFogOptionFixed(DrawRequest* request){
	Material::FogOption fogOption = request->getMaterial()->getFogOption();
	if(fogOption == Material::fogOptionDisable){
		device_->setRenderState(D3DRS_FOGENABLE, true);
	}else if(fogOption == Material::fogOptionBlack){
		device_->setRenderState(D3DRS_FOGCOLOR,
			request->getFog()->getColor().getARGB());
	}
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
