//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * {VF[_ŒpCvC
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Shader/BasicShaderFixed.h"
#include "Graphics/Renderer/RenderingDevice.h"
#include "Graphics/Material/Material.h"

#include "Graphics/Texture/Texture.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
BasicShaderFixed::BasicShaderFixed(){
}
//------------------------------------------------------------------------------
// fXgN^
BasicShaderFixed::~BasicShaderFixed(){
}
//------------------------------------------------------------------------------
// Xe[gubN̍\z
void BasicShaderFixed::buildStateBlock(
	Direct3DStateBlock** startBlock, Direct3DStateBlock** endBlock,
	Material* material, Texture* baseTexture, int baseUVIndex,
	Texture* lightTexture, int lightUVIndex, Texture* stainTexture,
	int stainUVIndex, const Color3f& diffuseColor,
	const Color3f& specularColor, const Color3f& ambientColor,
	const Color3f& emissiveColor, float specularPower){
	// O
	Assert((startBlock != NULL) && (endBlock != NULL));
	Assert(((*startBlock) == NULL) && ((*endBlock) == NULL));

	//--------------------------------------------------------------------------
	// `JnXe[gubN̍\z
	//--------------------------------------------------------------------------
	device_->beginStateBlock();
	// }eA̐ݒ
	buildMaterialStart(material);
	// Œ@\CeBÕ}eAݒ
	device_->setMaterial(diffuseColor, specularColor, ambientColor,
		emissiveColor, specularPower, material->getAlpha());

	//--------------------------------------------------------------------------
	// J[eNX`Xe[W̐ݒ
	// XyLeNX`Xe[WɑׁAGlossMapsȂ
	// Color = (Diffuse + light) * base * stain + Specular
	int colorStage = 0;
	// CgeNX`ACgUVCfbNX
	colorStage = setFixedLightTexture(colorStage, lightTexture, lightUVIndex);

	// x[XeNX`Ax[XUVCfbNX
	int baseTextureStage = colorStage;
	if(baseTexture == NULL){ baseTextureStage = -1; }
	colorStage = setFixedBaseTexture(colorStage, baseTexture, baseUVIndex);

	// eNX`AUVCfbNX
	colorStage = setFixedStainTexture(colorStage, stainTexture, stainUVIndex);

	// J[eNX`Xe[W
	device_->closeColorTextureStage(colorStage);

	//--------------------------------------------------------------------------
	// At@XeNX`e[W̐ݒ
	// Alpha = Diffuse.a * base
	device_->setAlphaTextureStage(baseTextureStage);

	//--------------------------------------------------------------------------
	// Xe[gubN
	(*startBlock) = device_->endStateBlock();

	//--------------------------------------------------------------------------
	// `IXe[gubN̍\z
	//--------------------------------------------------------------------------
	// IXe[gubN
//	device_->beginStateBlock();
	// }eA̐ݒ
//	buildMaterialEnd(material);
//	(*endBlock) = device_->endStateBlock();

}
//------------------------------------------------------------------------------
// `
void BasicShaderFixed::draw(DrawRequest* request){
	// `̃ZbgAbv
	setupFixedDraw(request);
	// `
	drawFixed(request);
	// `̃Zbg
	resetFixedDraw(request);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
