//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[m[h}l[W
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/SceneNode/SceneNodeManager.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
SceneNodeManager::SceneNodeManager(Scene* scene) :
	SceneObjectManagerTemplate<SceneNode>(scene){
}
//------------------------------------------------------------------------------
// V[m[h̍쐬
SceneNode* SceneNodeManager::createSceneNode(const String& sceneNodeName){
	if(!checkName(sceneNodeName)){ return NULL; }
	SceneNode* sceneNode = new SceneNode(sceneNodeName, getScene());
	addDatabase(sceneNodeName, sceneNode);
	return sceneNode;
}
//------------------------------------------------------------------------------
// xIufBeB[V[m[h̍쐬
LODSceneNode* SceneNodeManager::createLODSceneNode(const String& sceneNodeName){
	if(!checkName(sceneNodeName)){ return NULL; }
	LODSceneNode* sceneNode = new LODSceneNode(sceneNodeName, getScene());
	addDatabase(sceneNodeName, sceneNode);
	return sceneNode;
}
//------------------------------------------------------------------------------
int SceneNodeManager::clear(){
	int result = getCount();
	// [gm[h͉Ȃ
	SceneNode* rootNode = array_.get(0);
	int sceneNodeCount = rootNode->getSceneNodeCount();
	for(int i = sceneNodeCount - 1; i >= 0; i--){
		rootNode->removeSceneNode(rootNode->getSceneNode(i));
	}
	int sceneLeafCount = rootNode->getSceneLeafCount();
	for(int i = sceneLeafCount - 1; i >= 0; i--){
		rootNode->removeSceneLeaf(rootNode->getSceneLeaf(i));
	}
	// vf̍폜
	for(int i = 1; i < result; i++){ delete array_.get(i); }
	array_.clear();
	database_.clear();
	addDatabase(rootNode->getName(), rootNode);
	return result - 1;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
