//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[m[h
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/SceneNode/SceneNode.h"
#include "Graphics/Scene/Scene.h"
#include "Graphics/Camera/Camera.h"
#include "Graphics/SceneNode/SceneNodeManager.h"
#include "Graphics/Model/Model.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
SceneNode::SceneNode(const String& name, Scene* scene) :
	SceneObject(name, scene), worldMatrix_(Matrix34::unit),
	parent_(NULL), enabled_(true), globalEnabled_(true), globalScaled_(false),
	globalChanged_(true){
}
//------------------------------------------------------------------------------
// fXgN^
SceneNode::~SceneNode(){
}
//------------------------------------------------------------------------------
// Rs[
SceneNode* SceneNode::copy(u_int copyMask) const{
	SceneNodeManager* manager = scene_->getSceneNodeManager();
	SceneNode* destination = manager->createSceneNode(manager->rename(name_));
	copySceneNodeValue(destination, copyMask);
	return destination;
}
//------------------------------------------------------------------------------
// ċAIj
int SceneNode::recursiveDestroy(SceneNode* sceneNode){
	Assert(sceneNode != sceneNode->getScene()->getRootNode());
	int result = recursiveDestroyChildren(sceneNode);
	// e폜
	SceneNode* parent = sceneNode->getParent();
	if(parent != NULL){ parent->removeSceneNode(sceneNode); }
	// ̔j
	SceneNodeManager* manager = sceneNode->getScene()->getSceneNodeManager();
	if(manager->destroy(sceneNode) == 0){ result++; }
	return result;
}
//------------------------------------------------------------------------------
// q̍ċAIj
int SceneNode::recursiveDestroyChildren(SceneNode* sceneNode){
	Assert(sceneNode != NULL);
	int result = 0;
	// V[[t̔j
	for(int i = sceneNode->getSceneLeafCount() - 1; i >= 0; i--){
		result += SceneLeaf::recursiveDestroy(sceneNode->getSceneLeaf(i));
	}
	// V[m[h̔j
	for(int i = sceneNode->getSceneNodeCount() - 1; i >= 0; i--){
		result += recursiveDestroy(sceneNode->getSceneNode(i));
	}
	return result;
}
//------------------------------------------------------------------------------
// V[m[h̒lRs[
void SceneNode::copySceneNodeValue(
	SceneNode* destination, u_int copyMask) const{
	destination->axis_ = axis_;
	destination->setEnabled(enabled_);
	// V[[t̃Rs[
	int sceneLeafCount = getSceneLeafCount();
	for(int i = 0; i < sceneLeafCount; i++){
		destination->addSceneLeaf(getSceneLeaf(i)->copy(copyMask));
	}
	// V[m[h̃Rs[
	int sceneNodeCount = getSceneNodeCount();
	for(int i = 0; i < sceneNodeCount; i++){
		destination->addSceneNode(getSceneNode(i)->copy(copyMask));
	}
}
//------------------------------------------------------------------------------
// 
void SceneNode::traverse(){
	const Vector3& cameraPosition = scene_->getCurrentCamera()->getPosition();
	if(parent_ == NULL){
		traverse(Matrix34::unit, cameraPosition, true, false, false);
	}else{
// parent_->traverseł́H2ʂpӂH
		traverse(parent_->getWorldMatrix(), cameraPosition,
			parent_->isGlobalEnabled(), parent_->isGlobalScaled(),
			parent_->isGlobalChanged());
	}
}
//------------------------------------------------------------------------------
// 
void SceneNode::traverse(const Matrix34& parentMatrix,
	const Vector3& cameraPosition, bool parentEnabled, bool parentScaled,
	bool parentChanged){
	bool preGlobalEnabled = isGlobalEnabled();
	bool globalEnabled = (parentEnabled && isEnabled());
	setGlobalEnabled(globalEnabled);
	// Odisableddisabled̂܂܂Ȃgo[XȂ
	if((!preGlobalEnabled) && (!globalEnabled)){ return; }

	// švZ
	bool globalChanged = calcMatrix(parentMatrix, parentChanged);
	setGlobalChanged(globalChanged);
	// O[oXP[tOݒ
	bool globalScaled = (parentScaled || isScaled());
	setGlobalScaled(globalScaled);
	// V[m[hĂ
	int sceneNodeCount = getSceneNodeCount();
	for(int i = 0; i < sceneNodeCount; i++){
		getSceneNode(i)->traverse(worldMatrix_, cameraPosition,
			globalEnabled, globalScaled, globalChanged);
	}
	// V[[tĂ
	int sceneLeafCount = getSceneLeafCount();
	for(int i = 0; i < sceneLeafCount; i++){
		getSceneLeaf(i)->traverse(worldMatrix_,
			globalEnabled, globalScaled, globalChanged);
	}
}
//------------------------------------------------------------------------------
// švZ
bool SceneNode::calcMatrix(const Matrix34& parentMatrix, bool parentChanged){
	// [JsɕύXΌvZĕύXLԂ
	if(axis_.buildMatrix()){
		worldMatrix_ = parentMatrix * getLocalMatrix();
		return true;
	}
	// [JsɕύXAeɕύXΏZĕύXLԂ
	if(parentChanged){
		// eƂ̏Z
		worldMatrix_ = parentMatrix * getLocalMatrix();
		return true;
	}
	// [JsɕύXAeɂύXΕύXԂ
	Assert((parentMatrix * getLocalMatrix()).epsilonEquals(
		worldMatrix_, 0.0001f));
	return false;
}
//------------------------------------------------------------------------------
// V[[t̒ǉ
void SceneNode::addSceneLeaf(SceneLeaf* sceneLeaf){
	sceneLeaf->setParent(this);
	sceneLeafs_.add(sceneLeaf);
}
//------------------------------------------------------------------------------
// V[[t̍폜
void SceneNode::removeSceneLeaf(SceneLeaf* sceneLeaf){
	sceneLeaf->removeParent(this);
	sceneLeafs_.removeByValue(sceneLeaf);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
