//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[[t
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/SceneNode/SceneLeaf.h"
#include "Graphics/SceneNode/SceneNode.h"
#include "Graphics/Light/Light.h"
#include "Graphics/Model/Model.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
SceneLeaf::SceneLeaf(const String& name, Scene* scene) :
	SceneObject(name, scene), parent_(NULL), enabled_(true),
	globalEnabled_(false){
}
//------------------------------------------------------------------------------
// fXgN^
SceneLeaf::~SceneLeaf(){
}
//------------------------------------------------------------------------------
// V[[t̒lRs[
void SceneLeaf::copySceneLeafValue(SceneLeaf* destination) const{
	// õRs[
	destination->setEnabled(enabled_);
}
//------------------------------------------------------------------------------
// ċAIj
int SceneLeaf::recursiveDestroy(SceneLeaf* leaf){
	Assert(leaf != NULL);
	int result = 0;
	// e폜
	SceneNode* parent = leaf->getParent();
	if(parent != NULL){ parent->removeSceneLeaf(leaf); }
	if(leaf->isLight()){
		// Cg̔j
		result += Light::destroy(leaf->castLight());
	}else if(leaf->isModel()){
		// f̔j
		result += Model::recursiveDestroy(leaf->castModel());
	}else{
		ErrorOut("SceneLeaf::recursiveDestroy Unknown type");
	}
	return result;
}
//------------------------------------------------------------------------------
// 
void SceneLeaf::traverse(const Matrix34& parentMatrix,
	bool parentEnabled, bool parentScaled, bool parentChanged){
	globalEnabled_ = (parentEnabled && isEnabled());
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
