//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * xIufBeB[V[m[h
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/SceneNode/LODSceneNode.h"
#include "Graphics/SceneNode/SceneNodeManager.h"
#include "Graphics/Model/Model.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
LODSceneNode::LODSceneNode(const String& name, Scene* scene) :
	SceneNode(name, scene), lodThresholdCount_(0), lodThreshold_(NULL){
}
//------------------------------------------------------------------------------
// fXgN^
LODSceneNode::~LODSceneNode(){
	SafeArrayDelete(lodThreshold_);
}
//------------------------------------------------------------------------------
// xIufBeB[V[m[hRs[
LODSceneNode* LODSceneNode::copyLODSceneNode(u_int copyMask) const{
	SceneNodeManager* manager = scene_->getSceneNodeManager();
	LODSceneNode* destination =
		manager->createLODSceneNode(manager->rename(name_));
	copySceneNodeValue(destination, copyMask);
	// LOD̃Rs[
	destination->setLODThresholdCount(lodThresholdCount_);
	for(int i = 0; i < lodThresholdCount_; i++){
		destination->setLODThreshold(i, lodThreshold_[i]);
	}
	return destination;
}
//------------------------------------------------------------------------------
// 
void LODSceneNode::traverse(const Matrix34& parentMatrix,
	const Vector3& cameraPosition, bool parentEnabled, bool parentScaled,
	bool parentChanged){
	bool preGlobalEnabled = isGlobalEnabled();
	bool globalEnabled = (parentEnabled && isEnabled());
	setGlobalEnabled(globalEnabled);
	// Odisableddisabled̂܂܂Ȃgo[XȂ
	if((!preGlobalEnabled) && (!globalEnabled)){ return; }

	// švZ
	bool globalChanged = calcMatrix(parentMatrix, parentChanged);
	setGlobalChanged(globalChanged);
	// O[oXP[tOݒ
	bool globalScaled = (parentScaled || isScaled());
	setGlobalScaled(globalScaled);
	const Matrix34& worldMatrix = getWorldMatrix(); 
	if(globalEnabled){
		// LOD
		Vector3 worldPosition = worldMatrix.getTranslation();
		worldPosition -= cameraPosition;
		float distance = worldPosition.getLength();
		// LOD
		int sceneNodeCount = getSceneNodeCount();
		Assert((lodThresholdCount_ - 1) == sceneNodeCount);
		for(int i = 0; i < sceneNodeCount; i++){
			Assert(lodThreshold_[i] < lodThreshold_[i + 1]);
			// ͈͂ɓĂΗLA͈͂łȂΖ
			bool childEnable = ((distance >= lodThreshold_[i]) &&
				(distance < lodThreshold_[i + 1]));
			// LOD͈͂̕ύXɑ΂ChangedtO𗧂ĂKv
			// OgpLODǂ𔻕ʂłΌ\
			getSceneNode(i)->traverse(
				worldMatrix, cameraPosition,
//				childEnable, globalScaled, globalChanged);
				childEnable, globalScaled, (childEnable || globalChanged));
		}
	}else{
		// LłȂꍇ͑SĖݒ
		int sceneNodeCount = getSceneNodeCount();
		for(int i = 0; i < sceneNodeCount; i++){
			getSceneNode(i)->traverse(worldMatrix, cameraPosition,
				globalEnabled, globalScaled, globalChanged);
		}
	}
	// V[[tĂ
	int sceneLeafCount = getSceneLeafCount();
	for(int i = 0; i < sceneLeafCount; i++){
		getSceneLeaf(i)->traverse(worldMatrix,
			globalEnabled, globalScaled, globalChanged);
	}
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
