//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[_`FbNtB^
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/SceneFilter/SceneLogicCheckFilter/SceneLogicCheckFilter.h"
#include "Core/Utility/StringTokenizer.h"
#include "Graphics/SceneNode/SceneNodeManager.h"
#include "Graphics/Model/ModelManager.h"
#include "Graphics/Mesh/MeshManager.h"
#include "Graphics/MeshData/MeshDataManager.h"
#include "Graphics/Material/MaterialManager.h"
#include "Graphics/Texture/TextureManager.h"
#include "Graphics/Picture/PictureManager.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
SceneLogicCheckFilter::SceneLogicCheckFilter(Scene* scene) :
	SceneFilterInterface(scene){
}
//------------------------------------------------------------------------------
// fXgN^
SceneLogicCheckFilter::~SceneLogicCheckFilter(){
}
//------------------------------------------------------------------------------
// tB^
bool SceneLogicCheckFilter::filter(const String& command){
	StringTokenizer tokenizer_(command);
	if(!tokenizer_.hasMoreTokens()){
		ErrorOut("SceneLogicCheckFilter::filter() Not found filter name");
		return false;
	}
	String filterName = tokenizer_.getNextToken();
	if(filterName != "SceneLogicCheck"){
		ErrorOut("SceneLogicCheckFilter::filter() Invalid filter name %s",
			filterName.getBytes());
		return false;
	}
	return filterScene();
}
//------------------------------------------------------------------------------
// V[̃tB^
bool SceneLogicCheckFilter::filterScene(){
	if(!filterSceneNode()){ return false; }
	if(!filterModel()){ return false; }
	if(!filterMesh()){ return false; }
	if(!filterMeshData()){ return false; }
	if(!filterMaterial()){ return false; }
	if(!filterTexture()){ return false; }
	if(!filterPicture()){ return false; }
	return true;
}
//------------------------------------------------------------------------------
// V[m[h̃tB^
bool SceneLogicCheckFilter::filterSceneNode(){
	// [gm[h݂邩ǂ
	int count = sceneNodeManager_->getCount();
	if(count < 1){
		ErrorOut("SceneLogicCheckFilter::fiterSceneNode() "
			"[gm[h݂܂ %d", count);
		return false;
	}
	// [gm[h̊mF
	SceneNode* rootNode = sceneNodeManager_->get(0);
	if(rootNode->getName() != "RootNode"){
		ErrorOut("SceneLogicCheckFilter::fiterSceneNode() "
			"[gm[h̖OႢ܂ %s", rootNode->getName().getBytes());
		return false;
	}
	// eV[m[h̃`FbN
	for(int i = 1; i < count; i++){
		SceneNode* sceneNode = sceneNodeManager_->get(i);
		// QƃJE^1ȏォǂ
		if(sceneNode->getReferenceCount() < 1){
			ErrorOut("SceneLogicCheckFilter::fiterSceneNode() "
				"QƂĂȂV[m[h܂ %s %d",
				sceneNode->getName().getBytes(),
				sceneNode->getReferenceCount());
			return false;
		}
	}
	return true;
}
//------------------------------------------------------------------------------
// f̃tB^
bool SceneLogicCheckFilter::filterModel(){
	int count = modelManager_->getCount();
	// ef̃`FbN
	for(int i = 0; i < count; i++){
		Model* model = modelManager_->get(i);
		// QƃJE^1ȏォǂ
		if(model->getReferenceCount() < 1){
			ErrorOut("SceneLogicCheckFilter::filterModel() "
				"QƂĂȂf܂ %s %d",
				model->getName().getBytes(), model->getReferenceCount());
			return false;
		}
		// bV݂邩ǂ
		if(model->getMeshCount() == 0){
			ErrorOut("SceneLogicCheckFilter::filterModel() "
				"bVȂf܂ %s",
				model->getName().getBytes());
			return false;
		}
	}
	return true;
}
//------------------------------------------------------------------------------
// bṼtB^
bool SceneLogicCheckFilter::filterMesh(){
	int count = meshManager_->getCount();
	// ebṼ`FbN
	for(int i = 0; i < count; i++){
		Mesh* mesh = meshManager_->get(i);
		// QƃJE^1ȏォǂ
		if(mesh->getReferenceCount() < 1){
			ErrorOut("SceneLogicCheckFilter::filterMesh() "
				"QƂĂȂbV܂ %s %d",
				mesh->getName().getBytes(), mesh->getReferenceCount());
			return false;
		}
		// bVf[^݂邩ǂ
		if(mesh->getMeshData() == NULL){
			ErrorOut("SceneLogicCheckFilter::filterMesh() "
				"bVf[^ĂȂbV܂ %s",
				mesh->getName().getBytes());
			return false;
		}
		// }eA݂邩ǂ
		if(mesh->getMaterial() == NULL){
			ErrorOut("SceneLogicCheckFilter::filterMesh() "
				"}eAĂȂbV܂ %s",
				mesh->getName().getBytes());
			return false;
		}
	}
	return true;
}
//------------------------------------------------------------------------------
// bVf[^̃tB^
bool SceneLogicCheckFilter::filterMeshData(){
	int count = meshDataManager_->getCount();
	// ebVf[^̃`FbN
	for(int i = 0; i < count; i++){
		MeshData* meshData = meshDataManager_->get(i);
		// QƃJE^1ȏォǂ
		if(meshData->getReferenceCount() < 1){
			ErrorOut("SceneLogicCheckFilter::filterMeshData() "
				"QƂĂȂbVf[^܂ %s %d",
				meshData->getName().getBytes(), meshData->getReferenceCount());
			return false;
		}
	}
	return true;
}
//------------------------------------------------------------------------------
// }eÃtB^
bool SceneLogicCheckFilter::filterMaterial(){
	int count = materialManager_->getCount();
	// e}eÃ`FbN
	for(int i = 0; i < count; i++){
		Material* material = materialManager_->get(i);
		// QƃJE^1ȏォǂ
		if(material->getReferenceCount() < 1){
			ErrorOut("SceneLogicCheckFilter::filterMaterial() "
				"QƂĂȂ}eA܂ %s %d",
				material->getName().getBytes(), material->getReferenceCount());
			return false;
		}
	}
// eeNX`UVIndex݂邩
	return true;
}
//------------------------------------------------------------------------------
// eNX`̃tB^
bool SceneLogicCheckFilter::filterTexture(){
	int count = textureManager_->getCount();
	// eeNX`̃`FbN
	for(int i = 0; i < count; i++){
		Texture* texture = textureManager_->get(i);
		// QƃJE^1ȏォǂ
		if(texture->getReferenceCount() < 1){
			ErrorOut("SceneLogicCheckFilter::filterTexture() "
				"QƂĂȂeNX`܂ %s %d",
				texture->getName().getBytes(), texture->getReferenceCount());
			return false;
		}
		// sN`݂邩ǂ
		if(texture->getPictureCount() <= 0){
			ErrorOut("SceneLogicCheckFilter::filterTexture() "
				"sN`ĂȂeNX`܂ %s",
				texture->getName().getBytes());
			return false;
		}
	}
	return true;
}
//------------------------------------------------------------------------------
// sN`̃tB^
bool SceneLogicCheckFilter::filterPicture(){
	int count = pictureManager_->getCount();
	// esN`̃`FbN
	for(int i = 0; i < count; i++){
		Picture* picture = pictureManager_->get(i);
		// QƃJE^1ȏォǂ
		if(picture->getReferenceCount() < 1){
			ErrorOut("SceneLogicCheckFilter::filterPicture() "
				"QƂĂȂsN`܂ %s %d",
				picture->getName().getBytes(), picture->getReferenceCount());
			return false;
		}
		// A2̗ݏ悩ǂ
		DimensionI size = picture->getSize();
		if((!Math::checkPow2(size.width)) || (!Math::checkPow2(size.height))){
			ErrorOut("SceneLogicCheckFilter::filterPicture() "
				"TCY2̗ݏłȂsN`܂ %s %s",
				picture->getName().getBytes(), size.toString().getBytes());
			return false;
		}
	}
	return true;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
