//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[tB^
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/SceneFilter/SceneFilter.h"
#include "Core/Utility/StringTokenizer.h"
#include "Core/InputOutput/TextReader.h"
#include "Graphics/SceneFilter/SceneLogicCheckFilter/SceneLogicCheckFilter.h"
#include "Graphics/SceneFilter/ChangePicturePathFilter/\
ChangePicturePathFilter.h"
#include "Graphics/SceneFilter/CalculateBoundingBoxFilter/\
CalculateBoundingBoxFilter.h"
#include "Graphics/SceneFilter/CalculateBoundingSphereFilter/\
CalculateBoundingSphereFilter.h"
#include "Graphics/SceneFilter/BuildIndexedTriangleFilter/\
BuildIndexedTriangleFilter.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
SceneFilter::SceneFilter(Scene* scene) : scene_(scene){
}
//------------------------------------------------------------------------------
// fXgN^
SceneFilter::~SceneFilter(){
}
//------------------------------------------------------------------------------
// tB^
bool SceneFilter::filter(const String& command){
	Assert(scene_ != NULL);
	StringTokenizer tokenizer_(command);
	// sǂݔ΂
	if(!tokenizer_.hasMoreTokens()){ return true; }
	String token = tokenizer_.getNextToken();
	// sXbVRg̓ǂݔ΂
	if(token.startsWith("//")){ return true; }
	// V[_`FbN
	if(token == "SceneLogicCheck"){
		SceneLogicCheckFilter filter(scene_);
		return filter.filter(command);
	// sN`pXύX
	}else if(token == "ChangePicturePath"){
		ChangePicturePathFilter filter(scene_);
		return filter.filter(command);
	// oEfBO{bNXZo
	}else if(token == "CalculateBoundingBox"){
		CalculateBoundingBoxFilter filter(scene_);
		return filter.filter(command);
	// oEfBOXtBAZo
	}else if(token == "CalculateBoundingSphere"){
		CalculateBoundingSphereFilter filter(scene_);
		return filter.filter(command);
	// CfbNXgCAO\z
	}else if(token == "BuildIndexedTriangle"){
		BuildIndexedTriangleFilter filter(scene_);
		return filter.filter(command);
	}else{
		ErrorOut("SceneFilter::filter() Unknown scene filter %s",
			command.getBytes());
		return false;
	}
	return false;
}
//------------------------------------------------------------------------------
// tB^
bool SceneFilter::filter(TextReader* reader){
	while(true){
		if(reader->isEnd()){ return true; }
		if(!filter(reader->readLine())){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
