//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * oEfBOXtBAvZtB^
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/SceneFilter/CalculateBoundingSphereFilter/\
CalculateBoundingSphereFilter.h"
#include "Core/Utility/StringTokenizer.h"
#include "Graphics/Mesh/MeshManager.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
CalculateBoundingSphereFilter::CalculateBoundingSphereFilter(Scene* scene) :
	SceneFilterInterface(scene), characterScale_(1.f){
}
//------------------------------------------------------------------------------
// fXgN^
CalculateBoundingSphereFilter::~CalculateBoundingSphereFilter(){
}
//------------------------------------------------------------------------------
// tB^
bool CalculateBoundingSphereFilter::filter(const String& command){
	StringTokenizer tokenizer_(command);
	if(!tokenizer_.hasMoreTokens()){
		ErrorOut("CalculateBoundingSphereFilter::filter() "
			"Not found filter name");
		return false;
	}
	String filterName = tokenizer_.getNextToken();
	if(filterName != "CalculateBoundingSphere"){
		ErrorOut("CalculateBoundingSphereFilter::filter() "
			"Invalid filter name %s",
			filterName.getBytes());
		return false;
	}
	// IvV̉
	while(tokenizer_.hasMoreTokens()){
		String token = tokenizer_.getNextToken();
		// LN^XP[IvV
		if(token == "characterScale"){
			if(!tokenizer_.hasMoreTokens()){
				ErrorOut("CalculateBoundingBoxFilter::filter() "
					"Not found characterScale value");
				return false;
			}
			String characterScaleString = tokenizer_.getNextToken();
			if(!characterScaleString.parseFloat(&characterScale_)){
				ErrorOut(String("CalculateBoundingBoxFilter::filter() "
					"Invalid characterScale value ") + characterScaleString);
				return false;
			}
		}else{
			ErrorOut(String("CalculateBoundingBoxFilter::filter() "
				"Unknown option ") + token);
			return false;
		}
	}
	return filterScene();
}
//------------------------------------------------------------------------------
// V[̃tB^
bool CalculateBoundingSphereFilter::filterScene(){
	if(!filterMesh()){ return false; }
	return true;
}
//------------------------------------------------------------------------------
// bṼtB^
bool CalculateBoundingSphereFilter::filterMesh(){
	int count = meshManager_->getCount();
	// ebṼ`FbN
	for(int i = 0; i < count; i++){
		if(!filterMesh(meshManager_->get(i))){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// bṼtB^
bool CalculateBoundingSphereFilter::filterMesh(Mesh* mesh){
	// oEfBO{bNX̒SXtBA̒SƂ
	Sphere boundingSphere(mesh->getBoundingBox().getCenter(), 0.f);
	int vertexCount = mesh->getVertexCount();
	for(int i = 0; i < vertexCount; i++){
		boundingSphere.append(mesh->getPosition(i));
	}
	// LN^XP[̓Kp
	if((characterScale_ != 1.f) && mesh->isCharacterMesh()){
		boundingSphere.setRadius(boundingSphere.getRadius() * characterScale_);
	}
	mesh->setBoundingSphere(boundingSphere);
	return true;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
