//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * v~eBu`惊NGXg
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/PrimitiveRenderer/PrimitiveDrawRequest.h"
#include "Graphics/Renderer/RenderingDevice.h"
#include "Graphics/System/LampGraphics.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
PrimitiveDrawRequest::PrimitiveDrawRequest(){
	data_ = new Data();
}
//------------------------------------------------------------------------------
// Rs[RXgN^
PrimitiveDrawRequest::PrimitiveDrawRequest(const PrimitiveDrawRequest& copy){
	data_ = copy.data_;
	data_->addReference();
}
//------------------------------------------------------------------------------
// Rs[
PrimitiveDrawRequest& PrimitiveDrawRequest::operator =(
	const PrimitiveDrawRequest& copy){
	// gȂ疳
	if(this == &copy){ return *this; }
	// t@X̍폜
	removeReference();
	// f[^̑
	data_ = copy.data_;
	data_->addReference();
	return *this;
}
//------------------------------------------------------------------------------
// fXgN^
PrimitiveDrawRequest::~PrimitiveDrawRequest(){
	// t@X̍폜
	removeReference();
}
//------------------------------------------------------------------------------
// t@X̍폜
int PrimitiveDrawRequest::removeReference(){
	int referenceCount = data_->removeReference();
	Assert(referenceCount >= 0);
	if(referenceCount == 0){ SafeDelete(data_); }
	return referenceCount;
}
//------------------------------------------------------------------------------
// _
//------------------------------------------------------------------------------
// _̐ݒ
void PrimitiveDrawRequest::setVertexCount(int vertexCount){
	Assert(vertexCount >= 0);
	if(data_->vertexCount_ == vertexCount){ return; }
	bool useColor = hasColor();
	data_->vertexCount_ = vertexCount;
	// _obt@̉
	SafeRelease(data_->vertexBuffer_);
	SafeArrayDelete(data_->colors_);
	SafeArrayDelete(data_->positions_);
	if(vertexCount == 0){ return; }
	data_->positions_ = new Vector3[vertexCount];
	if(useColor){ data_->colors_ = new Color4c[vertexCount]; }
	// _obt@
	SafeRelease(data_->vertexBuffer_);
}
//------------------------------------------------------------------------------
// J[
//------------------------------------------------------------------------------
// J[Lɂ邩ǂ
void PrimitiveDrawRequest::enableColor(bool colorFlag){
	if(hasColor() == colorFlag){ return; }
	// _obt@̉
	SafeRelease(data_->vertexBuffer_);
	SafeArrayDelete(data_->colors_);
	Assert(data_->vertexCount_ != 0);
	if(colorFlag){ data_->colors_ = new Color4c[data_->vertexCount_]; }
	// _obt@
	SafeRelease(data_->vertexBuffer_);
}
//------------------------------------------------------------------------------
// _CfbNX
//------------------------------------------------------------------------------
// _CfbNX̐ݒ
void PrimitiveDrawRequest::setVertexIndexCount(int vertexIndexCount){
	SafeRelease(data_->indexBuffer_);
	SafeArrayDelete(data_->vertexIndices_);
	data_->vertexIndexCount_ = vertexIndexCount;
	if(vertexIndexCount == 0){ return; }
	data_->vertexIndices_ = new u_short[vertexIndexCount];
	// CfbNXobt@
	SafeRelease(data_->indexBuffer_);
}
//------------------------------------------------------------------------------
// OtBbNXIuWFNg
//------------------------------------------------------------------------------
// _obt@̎擾
Direct3DVertexBuffer* PrimitiveDrawRequest::getVertexBuffer(){
	RenderingDevice* device = RenderingDevice::getInstance();
	int bufferSize = getVertexCount() * getVertexSize();
	// _obt@΍쐬
	if(data_->vertexBuffer_ == NULL){
		data_->vertexBuffer_ = device->createDynamicVertexBuffer(bufferSize);
		data_->vertexBufferChanged_ = true;
	}
	// _obt@f[^ύXĂΏ
	if(data_->vertexBufferChanged_){
		Assert(data_->vertexBuffer_ != NULL);
		device->writeDynamicVertexBuffer(data_->vertexBuffer_, bufferSize,
			getVertexCount(), data_->positions_, 0, NULL, 0, NULL, NULL,
			getColorArray(), 0, NULL, NULL);
		data_->vertexBufferChanged_ = false;
	}
	return data_->vertexBuffer_;
}
//------------------------------------------------------------------------------
// CfbNXobt@̎擾
Direct3DIndexBuffer* PrimitiveDrawRequest::getIndexBuffer(){
	Assert(hasVertexIndices());
	RenderingDevice* device = RenderingDevice::getInstance();
	int bufferSize = getVertexIndexCount() * sizeof(u_short);
	// CfbNXobt@΍쐬
	if(data_->indexBuffer_ == NULL){
		data_->indexBuffer_ = device->createDynamicIndexBuffer(bufferSize);
		data_->indexBufferChanged_ = true;
	}
	// CfbNXobt@f[^ύXĂΏ
	if(data_->indexBufferChanged_){
		Assert(data_->indexBuffer_ != NULL);
		device->writeDynamicIndexBuffer(
			data_->indexBuffer_, getVertexIndexArray(), bufferSize);
		data_->indexBufferChanged_ = false;
	}
	return data_->indexBuffer_;
}
//------------------------------------------------------------------------------
// f[^
//------------------------------------------------------------------------------
// RXgN^
PrimitiveDrawRequest::Data::Data() : vertexCount_(0), positions_(NULL),
	colors_(NULL), vertexIndexCount_(0), vertexIndices_(NULL),
	vertexBuffer_(NULL), indexBuffer_(NULL), referenceCount_(1),
	vertexBufferChanged_(true), indexBufferChanged_(true){
	LampGraphics::addDeviceObjectHolder(this);
}
//------------------------------------------------------------------------------
// fXgN^
PrimitiveDrawRequest::Data::~Data(){
	Assert(referenceCount_ == 0);
	LampGraphics::removeDeviceObjectHolder(this);
	invalidateGraphicsDeviceObjects();
	SafeArrayDelete(vertexIndices_);
	SafeArrayDelete(colors_);
	SafeArrayDelete(positions_);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
