//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OtBbNXobt@tH[}bg
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Primitive/GraphicsBufferFormat.h"

namespace Lamp{

//------------------------------------------------------------------------------
// tH[}bg̎擾
String GraphicsBufferFormat::getName(){
	switch(format_){
		case D3DFMT_UNKNOWN:		return "D3DFMT_UNKNOWN";

		case D3DFMT_R8G8B8:			return "D3DFMT_R8G8B8";
		case D3DFMT_A8R8G8B8:		return "D3DFMT_A8R8G8B8";
		case D3DFMT_X8R8G8B8:		return "D3DFMT_X8R8G8B8";
		case D3DFMT_R5G6B5:			return "D3DFMT_R5G6B5";
		case D3DFMT_X1R5G5B5:		return "D3DFMT_X1R5G5B5";
		case D3DFMT_A1R5G5B5:		return "D3DFMT_A1R5G5B5";
		case D3DFMT_A4R4G4B4:		return "D3DFMT_A4R4G4B4";
		case D3DFMT_R3G3B2:			return "D3DFMT_R3G3B2";
		case D3DFMT_A8:				return "D3DFMT_A8";
		case D3DFMT_A8R3G3B2:		return "D3DFMT_A8R3G3B2";
		case D3DFMT_X4R4G4B4:		return "D3DFMT_X4R4G4B4";
		case D3DFMT_A2B10G10R10:	return "D3DFMT_A2B10G10R10";
		case D3DFMT_A8B8G8R8:		return "D3DFMT_A8B8G8R8";
		case D3DFMT_X8B8G8R8:		return "D3DFMT_X8B8G8R8";
		case D3DFMT_G16R16:			return "D3DFMT_G16R16";
		case D3DFMT_A2R10G10B10:	return "D3DFMT_A2R10G10B10";
		case D3DFMT_A16B16G16R16:	return "D3DFMT_A16B16G16R16";

		case D3DFMT_A8P8:			return "D3DFMT_A8P8";
		case D3DFMT_P8:				return "D3DFMT_P8";

		case D3DFMT_L8:				return "D3DFMT_L8";
		case D3DFMT_A8L8:			return "D3DFMT_A8L8";
		case D3DFMT_A4L4:			return "D3DFMT_A4L4";

		case D3DFMT_V8U8:			return "D3DFMT_V8U8";
		case D3DFMT_L6V5U5:			return "D3DFMT_L6V5U5";
		case D3DFMT_X8L8V8U8:		return "D3DFMT_X8L8V8U8";
		case D3DFMT_Q8W8V8U8:		return "D3DFMT_Q8W8V8U8";
		case D3DFMT_V16U16:			return "D3DFMT_V16U16";
		case D3DFMT_A2W10V10U10:	return "D3DFMT_A2W10V10U10";

		case D3DFMT_UYVY:			return "D3DFMT_UYVY";
		case D3DFMT_R8G8_B8G8:		return "D3DFMT_R8G8_B8G8";
		case D3DFMT_YUY2:			return "D3DFMT_YUY2";
		case D3DFMT_G8R8_G8B8:		return "D3DFMT_G8R8_G8B8";
		case D3DFMT_DXT1:			return "D3DFMT_DXT1";
		case D3DFMT_DXT2:			return "D3DFMT_DXT2";
		case D3DFMT_DXT3:			return "D3DFMT_DXT3";
		case D3DFMT_DXT4:			return "D3DFMT_DXT4";
		case D3DFMT_DXT5:			return "D3DFMT_DXT5";

		case D3DFMT_D16_LOCKABLE:	return "D3DFMT_D16_LOCKABLE";
		case D3DFMT_D32:			return "D3DFMT_D32";
		case D3DFMT_D15S1:			return "D3DFMT_D15S1";
		case D3DFMT_D24S8:			return "D3DFMT_D24S8";
		case D3DFMT_D24X8:			return "D3DFMT_D24X8";
		case D3DFMT_D24X4S4:		return "D3DFMT_D24X4S4";
		case D3DFMT_D16:			return "D3DFMT_D16";

		case D3DFMT_D32F_LOCKABLE:	return "D3DFMT_D32F_LOCKABLE";
		case D3DFMT_D24FS8:			return "D3DFMT_D24FS8";

		case D3DFMT_L16:			return "D3DFMT_L16";

		case D3DFMT_VERTEXDATA:		return "D3DFMT_VERTEXDATA";
		case D3DFMT_INDEX16:		return "D3DFMT_INDEX16";
		case D3DFMT_INDEX32:		return "D3DFMT_INDEX32";

		case D3DFMT_Q16W16V16U16:	return "D3DFMT_Q16W16V16U16";

		case D3DFMT_MULTI2_ARGB8:	return "D3DFMT_MULTI2_ARGB8";

		case D3DFMT_R16F:			return "D3DFMT_R16F";
		case D3DFMT_G16R16F:		return "D3DFMT_G16R16F";
		case D3DFMT_A16B16G16R16F:	return "D3DFMT_A16B16G16R16F";

		case D3DFMT_R32F:			return "D3DFMT_R32F";
		case D3DFMT_G32R32F:		return "D3DFMT_G32R32F";
		case D3DFMT_A32B32G32R32F:	return "D3DFMT_A32B32G32R32F";

		case D3DFMT_CxV8U8:			return "D3DFMT_CxV8U8";
	}
	ErrorOut("GraphicsBufferFormat::getName() Unknown format");
	return "";
}
//------------------------------------------------------------------------------
// J[`lrbg̎擾
u_int GraphicsBufferFormat::getColorChannelBits(){
	switch(format_){
		case D3DFMT_UNKNOWN:		return 0;

		case D3DFMT_R8G8B8:			return 8;
		case D3DFMT_A8R8G8B8:		return 8;
		case D3DFMT_X8R8G8B8:		return 8;
		case D3DFMT_R5G6B5:			return 5;
		case D3DFMT_X1R5G5B5:		return 5;
		case D3DFMT_A1R5G5B5:		return 5;
		case D3DFMT_A4R4G4B4:		return 4;
		case D3DFMT_R3G3B2:			return 2;
		case D3DFMT_A8:				return 0;
		case D3DFMT_A8R3G3B2:		return 2;
		case D3DFMT_X4R4G4B4:		return 4;
		case D3DFMT_A2B10G10R10:	return 10;
		case D3DFMT_A8B8G8R8:		return 8;
		case D3DFMT_X8B8G8R8:		return 8;
		case D3DFMT_G16R16:			return 16;
		case D3DFMT_A2R10G10B10:	return 10;
		case D3DFMT_A16B16G16R16:	return 16;

		case D3DFMT_A8P8:			return 0;
		case D3DFMT_P8:				return 0;

		case D3DFMT_L8:				return 0;
		case D3DFMT_A8L8:			return 0;
		case D3DFMT_A4L4:			return 0;

		case D3DFMT_V8U8:			return 0;
		case D3DFMT_L6V5U5:			return 0;
		case D3DFMT_X8L8V8U8:		return 0;
		case D3DFMT_Q8W8V8U8:		return 0;
		case D3DFMT_V16U16:			return 0;
		case D3DFMT_A2W10V10U10:	return 0;

		case D3DFMT_UYVY:			return 0;
		case D3DFMT_R8G8_B8G8:		return 8;
		case D3DFMT_YUY2:			return 0;
		case D3DFMT_G8R8_G8B8:		return 8;
		case D3DFMT_DXT1:			return 5;
		case D3DFMT_DXT2:			return 5;
		case D3DFMT_DXT3:			return 5;
		case D3DFMT_DXT4:			return 5;
		case D3DFMT_DXT5:			return 5;

		case D3DFMT_D16_LOCKABLE:	return 0;
		case D3DFMT_D32:			return 0;
		case D3DFMT_D15S1:			return 0;
		case D3DFMT_D24S8:			return 0;
		case D3DFMT_D24X8:			return 0;
		case D3DFMT_D24X4S4:		return 0;
		case D3DFMT_D16:			return 0;

		case D3DFMT_D32F_LOCKABLE:	return 0;
		case D3DFMT_D24FS8:			return 0;

		case D3DFMT_L16:			return 0;

		case D3DFMT_VERTEXDATA:		return 0;
		case D3DFMT_INDEX16:		return 0;
		case D3DFMT_INDEX32:		return 0;

		case D3DFMT_Q16W16V16U16:	return 0;

		case D3DFMT_MULTI2_ARGB8:	return 8;

		case D3DFMT_R16F:			return 16;
		case D3DFMT_G16R16F:		return 16;
		case D3DFMT_A16B16G16R16F:	return 16;

		case D3DFMT_R32F:			return 32;
		case D3DFMT_G32R32F:		return 32;
		case D3DFMT_A32B32G32R32F:	return 32;

		case D3DFMT_CxV8U8:			return 0;
	}
	ErrorOut("GraphicsBufferFormat::getColorChannelBits() Unknown format");
	return 0;
}
//------------------------------------------------------------------------------
// At@`lrbg̎擾
u_int GraphicsBufferFormat::getAlphaChannelBits(){
	switch(format_){
		case D3DFMT_UNKNOWN:		return 0;

		case D3DFMT_R8G8B8:			return 0;
		case D3DFMT_A8R8G8B8:		return 8;
		case D3DFMT_X8R8G8B8:		return 0;
		case D3DFMT_R5G6B5:			return 0;
		case D3DFMT_X1R5G5B5:		return 0;
		case D3DFMT_A1R5G5B5:		return 1;
		case D3DFMT_A4R4G4B4:		return 4;
		case D3DFMT_R3G3B2:			return 0;
		case D3DFMT_A8:				return 8;
		case D3DFMT_A8R3G3B2:		return 8;
		case D3DFMT_X4R4G4B4:		return 0;
		case D3DFMT_A2B10G10R10:	return 2;
		case D3DFMT_A8B8G8R8:		return 8;
		case D3DFMT_X8B8G8R8:		return 0;
		case D3DFMT_G16R16:			return 0;
		case D3DFMT_A2R10G10B10:	return 2;
		case D3DFMT_A16B16G16R16:	return 16;

		case D3DFMT_A8P8:			return 8;
		case D3DFMT_P8:				return 0;

		case D3DFMT_L8:				return 0;
		case D3DFMT_A8L8:			return 8;
		case D3DFMT_A4L4:			return 4;

		case D3DFMT_V8U8:			return 0;
		case D3DFMT_L6V5U5:			return 0;
		case D3DFMT_X8L8V8U8:		return 0;
		case D3DFMT_Q8W8V8U8:		return 0;
		case D3DFMT_V16U16:			return 0;
		case D3DFMT_A2W10V10U10:	return 2;

		case D3DFMT_UYVY:			return 0;
		case D3DFMT_R8G8_B8G8:		return 0;
		case D3DFMT_YUY2:			return 0;
		case D3DFMT_G8R8_G8B8:		return 0;
		case D3DFMT_DXT1:			return 1;
		case D3DFMT_DXT2:			return 4;
		case D3DFMT_DXT3:			return 4;
		case D3DFMT_DXT4:			return 8;
		case D3DFMT_DXT5:			return 8;

		case D3DFMT_D16_LOCKABLE:	return 0;
		case D3DFMT_D32:			return 0;
		case D3DFMT_D15S1:			return 0;
		case D3DFMT_D24S8:			return 0;
		case D3DFMT_D24X8:			return 0;
		case D3DFMT_D24X4S4:		return 0;
		case D3DFMT_D16:			return 0;

		case D3DFMT_D32F_LOCKABLE:	return 0;
		case D3DFMT_D24FS8:			return 0;

		case D3DFMT_L16:			return 0;

		case D3DFMT_VERTEXDATA:		return 0;
		case D3DFMT_INDEX16:		return 0;
		case D3DFMT_INDEX32:		return 0;

		case D3DFMT_Q16W16V16U16:	return 0;

		case D3DFMT_MULTI2_ARGB8:	return 8;

		case D3DFMT_R16F:			return 0;
		case D3DFMT_G16R16F:		return 0;
		case D3DFMT_A16B16G16R16F:	return 16;

		case D3DFMT_R32F:			return 0;
		case D3DFMT_G32R32F:		return 0;
		case D3DFMT_A32B32G32R32F:	return 32;

		case D3DFMT_CxV8U8:			return 0;
	}
	ErrorOut("GraphicsBufferFormat::getAlphaChannelBits() Unknown format");
	return 0;
}
//------------------------------------------------------------------------------
// [xrbg̎擾
u_int GraphicsBufferFormat::getDepthBits(){
	switch(format_){
		case D3DFMT_UNKNOWN:		return 0;

		case D3DFMT_R8G8B8:			return 0;
		case D3DFMT_A8R8G8B8:		return 0;
		case D3DFMT_X8R8G8B8:		return 0;
		case D3DFMT_R5G6B5:			return 0;
		case D3DFMT_X1R5G5B5:		return 0;
		case D3DFMT_A1R5G5B5:		return 0;
		case D3DFMT_A4R4G4B4:		return 0;
		case D3DFMT_R3G3B2:			return 0;
		case D3DFMT_A8:				return 0;
		case D3DFMT_A8R3G3B2:		return 0;
		case D3DFMT_X4R4G4B4:		return 0;
		case D3DFMT_A2B10G10R10:	return 0;
		case D3DFMT_A8B8G8R8:		return 0;
		case D3DFMT_X8B8G8R8:		return 0;
		case D3DFMT_G16R16:			return 0;
		case D3DFMT_A2R10G10B10:	return 0;
		case D3DFMT_A16B16G16R16:	return 0;

		case D3DFMT_A8P8:			return 0;
		case D3DFMT_P8:				return 0;

		case D3DFMT_L8:				return 0;
		case D3DFMT_A8L8:			return 0;
		case D3DFMT_A4L4:			return 0;

		case D3DFMT_V8U8:			return 0;
		case D3DFMT_L6V5U5:			return 0;
		case D3DFMT_X8L8V8U8:		return 0;
		case D3DFMT_Q8W8V8U8:		return 0;
		case D3DFMT_V16U16:			return 0;
		case D3DFMT_A2W10V10U10:	return 0;

		case D3DFMT_UYVY:			return 0;
		case D3DFMT_R8G8_B8G8:		return 0;
		case D3DFMT_YUY2:			return 0;
		case D3DFMT_G8R8_G8B8:		return 0;
		case D3DFMT_DXT1:			return 0;
		case D3DFMT_DXT2:			return 0;
		case D3DFMT_DXT3:			return 0;
		case D3DFMT_DXT4:			return 0;
		case D3DFMT_DXT5:			return 0;

		case D3DFMT_D16_LOCKABLE:	return 16;
		case D3DFMT_D32:			return 32;
		case D3DFMT_D15S1:			return 15;
		case D3DFMT_D24S8:			return 24;
		case D3DFMT_D24X8:			return 24;
		case D3DFMT_D24X4S4:		return 24;
		case D3DFMT_D16:			return 16;

		case D3DFMT_D32F_LOCKABLE:	return 0;
		case D3DFMT_D24FS8:			return 0;

		case D3DFMT_L16:			return 0;

		case D3DFMT_VERTEXDATA:		return 0;
		case D3DFMT_INDEX16:		return 0;
		case D3DFMT_INDEX32:		return 0;

		case D3DFMT_Q16W16V16U16:	return 0;

		case D3DFMT_MULTI2_ARGB8:	return 0;

		case D3DFMT_R16F:			return 0;
		case D3DFMT_G16R16F:		return 0;
		case D3DFMT_A16B16G16R16F:	return 0;

		case D3DFMT_R32F:			return 0;
		case D3DFMT_G32R32F:		return 0;
		case D3DFMT_A32B32G32R32F:	return 0;

		case D3DFMT_CxV8U8:			return 0;
	}
	ErrorOut("GraphicsBufferFormat::getDepthBits() Unknown format");
	return 0;
}
//------------------------------------------------------------------------------
// XeVrbg̎擾
u_int GraphicsBufferFormat::getStencilBits(){
	switch(format_){
		case D3DFMT_UNKNOWN:		return 0;

		case D3DFMT_R8G8B8:			return 0;
		case D3DFMT_A8R8G8B8:		return 0;
		case D3DFMT_X8R8G8B8:		return 0;
		case D3DFMT_R5G6B5:			return 0;
		case D3DFMT_X1R5G5B5:		return 0;
		case D3DFMT_A1R5G5B5:		return 0;
		case D3DFMT_A4R4G4B4:		return 0;
		case D3DFMT_R3G3B2:			return 0;
		case D3DFMT_A8:				return 0;
		case D3DFMT_A8R3G3B2:		return 0;
		case D3DFMT_X4R4G4B4:		return 0;
		case D3DFMT_A2B10G10R10:	return 0;
		case D3DFMT_A8B8G8R8:		return 0;
		case D3DFMT_X8B8G8R8:		return 0;
		case D3DFMT_G16R16:			return 0;
		case D3DFMT_A2R10G10B10:	return 0;
		case D3DFMT_A16B16G16R16:	return 0;

		case D3DFMT_A8P8:			return 0;
		case D3DFMT_P8:				return 0;

		case D3DFMT_L8:				return 0;
		case D3DFMT_A8L8:			return 0;
		case D3DFMT_A4L4:			return 0;

		case D3DFMT_V8U8:			return 0;
		case D3DFMT_L6V5U5:			return 0;
		case D3DFMT_X8L8V8U8:		return 0;
		case D3DFMT_Q8W8V8U8:		return 0;
		case D3DFMT_V16U16:			return 0;
		case D3DFMT_A2W10V10U10:	return 0;

		case D3DFMT_UYVY:			return 0;
		case D3DFMT_R8G8_B8G8:		return 0;
		case D3DFMT_YUY2:			return 0;
		case D3DFMT_G8R8_G8B8:		return 0;
		case D3DFMT_DXT1:			return 0;
		case D3DFMT_DXT2:			return 0;
		case D3DFMT_DXT3:			return 0;
		case D3DFMT_DXT4:			return 0;
		case D3DFMT_DXT5:			return 0;

		case D3DFMT_D16_LOCKABLE:	return 0;
		case D3DFMT_D32:			return 0;
		case D3DFMT_D15S1:			return 1;
		case D3DFMT_D24S8:			return 8;
		case D3DFMT_D24X8:			return 0;
		case D3DFMT_D24X4S4:		return 4;
		case D3DFMT_D16:			return 0;

		case D3DFMT_D32F_LOCKABLE:	return 0;
		case D3DFMT_D24FS8:			return 0;

		case D3DFMT_L16:			return 0;

		case D3DFMT_VERTEXDATA:		return 0;
		case D3DFMT_INDEX16:		return 0;
		case D3DFMT_INDEX32:		return 0;

		case D3DFMT_Q16W16V16U16:	return 0;

		case D3DFMT_MULTI2_ARGB8:	return 0;

		case D3DFMT_R16F:			return 0;
		case D3DFMT_G16R16F:		return 0;
		case D3DFMT_A16B16G16R16F:	return 0;

		case D3DFMT_R32F:			return 0;
		case D3DFMT_G32R32F:		return 0;
		case D3DFMT_A32B32G32R32F:	return 0;

		case D3DFMT_CxV8U8:			return 0;
	}
	ErrorOut("GraphicsBufferFormat::getStencilBits() Unknown format");
	return 0;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
