//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * sN`}l[W
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Picture/PictureManager.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
PictureManager::PictureManager(Scene* scene) :
	SceneObjectManagerTemplate<Picture>(scene){
}
//------------------------------------------------------------------------------
// RGB8rbgsN`̍쐬
PictureRGB8* PictureManager::createPictureRGB8(const String& pictureName){
	if(!checkName(pictureName)){ return NULL; }
	PictureRGB8* picture = new PictureRGB8(pictureName, getScene());
	addDatabase(pictureName, picture);
	return picture;
}
//------------------------------------------------------------------------------
// RGBA8rbgsN`̍쐬
PictureRGBA8* PictureManager::createPictureRGBA8(const String& pictureName){
	if(!checkName(pictureName)){ return NULL; }
	PictureRGBA8* picture = new PictureRGBA8(pictureName, getScene());
	addDatabase(pictureName, picture);
	return picture;
}
//------------------------------------------------------------------------------
// foCXIuWFNg̏
bool PictureManager::initializeGraphicsDeviceObjects(){
	int pictureCount = getCount();
	for(int i = 0; i < pictureCount; i++){
		if(!get(i)->initializeGraphicsDeviceObjects()){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// foCXIuWFNg̍폜
void PictureManager::deleteGraphicsDeviceObjects(){
	int pictureCount = getCount();
	for(int i = 0; i < pictureCount; i++){
		get(i)->deleteGraphicsDeviceObjects();
	}
}
//------------------------------------------------------------------------------
// foCXIuWFNg̃XgA
bool PictureManager::restoreGraphicsDeviceObjects(){
	int pictureCount = getCount();
	for(int i = 0; i < pictureCount; i++){
		if(!get(i)->restoreGraphicsDeviceObjects()){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// foCXIuWFNg̖
void PictureManager::invalidateGraphicsDeviceObjects(){
	int pictureCount = getCount();
	for(int i = 0; i < pictureCount; i++){
		get(i)->invalidateGraphicsDeviceObjects();
	}
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
