//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * sN`
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Picture/Picture.h"
#include "Graphics/Scene/Scene.h"
#include "Graphics/Picture/PictureManager.h"
#include "Graphics/Texture/Texture.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
Picture::Picture(const String& name, Scene* scene) :
	SceneObject(name, scene), size_(0, 0){
}
//------------------------------------------------------------------------------
// fXgN^
Picture::~Picture(){
}
//------------------------------------------------------------------------------
// Xe[gύXtO𗧂Ă
void Picture::stateChanged(){
	int parentCount = getParentCount();
	for(int i = 0; i < parentCount; i++){
		Texture* texture = getParent(i);
		texture->stateChanged();
	}
}
//------------------------------------------------------------------------------
// sN`̒lRs[
void Picture::copyPictureValue(Picture* destination) const{
	destination->setPath(path_);
	destination->setSize(size_);
}
//------------------------------------------------------------------------------
// j
int Picture::destroy(Picture* picture){
	Assert(picture != NULL);
	// ̔j
	PictureManager* manager = picture->getScene()->getPictureManager();
	if(manager->destroy(picture) == 0){ return 1; }
	return 0;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
