//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Wf
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Model/StandardModel.h"
#include "Graphics/Scene/Scene.h"
#include "Graphics/Model/ModelManager.h"
#include "Graphics/Mesh/Mesh.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
StandardModel::StandardModel(const String& name, Scene* scene) :
	Model(name, scene){
}
//------------------------------------------------------------------------------
// fXgN^
StandardModel::~StandardModel(){
}
//------------------------------------------------------------------------------
// Wf̃Rs[
StandardModel* StandardModel::copyStandardModel(u_int copyMask) const{
	ModelManager* manager = scene_->getModelManager();
	StandardModel* copyModel =
		manager->createStandardModel(manager->rename(name_));
	// f̒lRs[
	copyModelValue(copyModel, copyMask);
	// õRs[
	return copyModel;
}
//------------------------------------------------------------------------------
// bV̒ǉ
void StandardModel::addMesh(Mesh* mesh){
	Assert(mesh->isRigidMesh());
	Model::addMesh(mesh);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
