//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * f
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Model/Model.h"
#include "Graphics/Model/ModelManager.h"
#include "Graphics/Mesh/Mesh.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
Model::Model(const String& name, Scene* scene) : SceneLeaf(name, scene){
}
//------------------------------------------------------------------------------
// fXgN^
Model::~Model(){
}
//------------------------------------------------------------------------------
// f̒lRs[
void Model::copyModelValue(Model* destination, u_int copyMask) const{
	// V[[t̒lRs[
	copySceneLeafValue(destination);
	// bṼRs[
	int meshCount = getMeshCount();
	for(int i = 0; i < meshCount; i++){
		destination->addMesh(getMesh(i)->copy(copyMask));
	}
}
//------------------------------------------------------------------------------
// ċAIj
int Model::recursiveDestroy(Model* model){
	Assert(model != NULL);
	int result = 0;
	// bV̔j
	for(int i = model->getMeshCount() - 1; i >= 0; i--){
		result += Mesh::recursiveDestroy(model->getMesh(i));
	}
	// ̔j
	ModelManager* manager = model->getScene()->getModelManager();
	if(manager->destroy(model) == 0){ result++; }
	return result;
}
//------------------------------------------------------------------------------
// 
void Model::traverse(const Matrix34& parentMatrix,
	bool parentEnabled, bool parentScaled, bool parentChanged){
	SceneLeaf::traverse(parentMatrix,
		parentEnabled, parentScaled, parentChanged);
	// bV
	int meshCount = getMeshCount();
	for(int i = 0; i < meshCount; i++){
		getMesh(i)->traverse(parentMatrix,
			isGlobalEnabled(), parentScaled, parentChanged);
	}
}
//------------------------------------------------------------------------------
// bV̒ǉ
void Model::addMesh(Mesh* mesh){
	mesh->setParent(this);
	meshes_.add(mesh);
}
//------------------------------------------------------------------------------
// bV̍폜
void Model::removeMesh(Mesh* mesh){
	mesh->removeParent(this);
	meshes_.removeByValue(mesh);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
