//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * {[
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Model/Bone.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
Bone::Bone(const String& name) :
	inversePoseMatrix_(Matrix34::unit), name_(name){
}
//------------------------------------------------------------------------------
// fXgN^
Bone::~Bone(){
}
//------------------------------------------------------------------------------
// {[̒lRs[
void Bone::copyBoneValue(Bone* destination) const{
	destination->axis_ = axis_;
	destination->setInversePoseMatrix(getInversePoseMatrix());
}
//------------------------------------------------------------------------------
// {[s̍\z
bool Bone::buildBoneMatrix(const Matrix34& parentModelMatrix){
	// [Js̍\z
	axis_.buildMatrix();
	bool scaled = axis_.isScaled();
	// ό`s̍\z
	modelMatrix_ = parentModelMatrix * getLocalMatrix();
	deformMatrix_ = modelMatrix_ * inversePoseMatrix_;
	// q{[Ă
	int boneCount = getBoneCount();
	for(int i = 0; i < boneCount; i++){
		scaled |= getBone(i)->buildBoneMatrix(modelMatrix_);
	}
	return scaled;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
