//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * bVf[^}l[W
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/MeshData/MeshDataManager.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
MeshDataManager::MeshDataManager(Scene* scene) :
	SceneObjectManagerTemplate<MeshData>(scene){
}
//------------------------------------------------------------------------------
// bVf[^̍쐬
MeshData* MeshDataManager::createMeshData(const String& meshDataName){
	if(!checkName(meshDataName)){ return NULL; }
	MeshData* meshData = new MeshData(meshDataName, getScene());
	addDatabase(meshDataName, meshData);
	return meshData;
}
//------------------------------------------------------------------------------
// foCXIuWFNg̏
bool MeshDataManager::initializeGraphicsDeviceObjects(){
	int meshDataCount = getCount();
	for(int i = 0; i < meshDataCount; i++){
		if(!get(i)->initializeGraphicsDeviceObjects()){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// foCXIuWFNg̍폜
void MeshDataManager::deleteGraphicsDeviceObjects(){
	int meshDataCount = getCount();
	for(int i = 0; i < meshDataCount; i++){
		get(i)->deleteGraphicsDeviceObjects();
	}
}
//------------------------------------------------------------------------------
// foCXIuWFNg̃XgA
bool MeshDataManager::restoreGraphicsDeviceObjects(){
	int meshDataCount = getCount();
	for(int i = 0; i < meshDataCount; i++){
		if(!get(i)->restoreGraphicsDeviceObjects()){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// foCXIuWFNg̖
void MeshDataManager::invalidateGraphicsDeviceObjects(){
	int meshDataCount = getCount();
	for(int i = 0; i < meshDataCount; i++){
		get(i)->invalidateGraphicsDeviceObjects();
	}
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
