//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * bV}l[W
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Mesh/MeshManager.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
MeshManager::MeshManager(Scene* scene) :
	SceneObjectManagerTemplate<Mesh>(scene){
}
//------------------------------------------------------------------------------
// ̃bV̍쐬
RigidMesh* MeshManager::createRigidMesh(const String& meshName){
	if(!checkName(meshName)){ return NULL; }
	RigidMesh* mesh = new RigidMesh(meshName, getScene());
	addDatabase(meshName, mesh);
	return mesh;
}
//------------------------------------------------------------------------------
// LN^bV̍쐬
CharacterMesh* MeshManager::createCharacterMesh(const String& meshName){
	if(!checkName(meshName)){ return NULL; }
	CharacterMesh* mesh = new CharacterMesh(meshName, getScene());
	addDatabase(meshName, mesh);
	return mesh;
}
//------------------------------------------------------------------------------
// foCXIuWFNg̏
bool MeshManager::initializeGraphicsDeviceObjects(){
	int meshCount = getCount();
	for(int i = 0; i < meshCount; i++){
		if(!get(i)->initializeGraphicsDeviceObjects()){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// foCXIuWFNg̍폜
void MeshManager::deleteGraphicsDeviceObjects(){
	int meshCount = getCount();
	for(int i = 0; i < meshCount; i++){
		get(i)->deleteGraphicsDeviceObjects();
	}
}
//------------------------------------------------------------------------------
// foCXIuWFNg̃XgA
bool MeshManager::restoreGraphicsDeviceObjects(){
	int meshCount = getCount();
	for(int i = 0; i < meshCount; i++){
		if(!get(i)->restoreGraphicsDeviceObjects()){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// foCXIuWFNg̖
void MeshManager::invalidateGraphicsDeviceObjects(){
	int meshCount = getCount();
	for(int i = 0; i < meshCount; i++){
		get(i)->invalidateGraphicsDeviceObjects();
	}
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
