//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * }eA}l[W
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Material/MaterialManager.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
MaterialManager::MaterialManager(Scene* scene) :
	SceneObjectManagerTemplate<Material>(scene){
}
//------------------------------------------------------------------------------
// {}eA̍쐬
BasicMaterial* MaterialManager::createBasicMaterial(const String& materialName){
	if(!checkName(materialName)){ return NULL; }
	BasicMaterial* material = new BasicMaterial(materialName, getScene());
	addDatabase(materialName, material);
	return material;
}
//------------------------------------------------------------------------------
// foCXIuWFNg̏
bool MaterialManager::initializeGraphicsDeviceObjects(){
	int materialCount = getCount();
	for(int i = 0; i < materialCount; i++){
		if(!get(i)->initializeGraphicsDeviceObjects()){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// foCXIuWFNg̍폜
void MaterialManager::deleteGraphicsDeviceObjects(){
	int materialCount = getCount();
	for(int i = 0; i < materialCount; i++){
		get(i)->deleteGraphicsDeviceObjects();
	}
}
//------------------------------------------------------------------------------
// foCXIuWFNg̃XgA
bool MaterialManager::restoreGraphicsDeviceObjects(){
	int materialCount = getCount();
	for(int i = 0; i < materialCount; i++){
		if(!get(i)->restoreGraphicsDeviceObjects()){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// foCXIuWFNg̖
void MaterialManager::invalidateGraphicsDeviceObjects(){
	int materialCount = getCount();
	for(int i = 0; i < materialCount; i++){
		get(i)->invalidateGraphicsDeviceObjects();
	}
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
