//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * |CgCg
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Light/PointLight.h"
#include "Graphics/Scene/Scene.h"
#include "Graphics/Light/LightManager.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
PointLight::PointLight(const String& name, Scene* scene) :
	LocalLight(name, scene), diffuseColor_(Color3f::white),
	specularColor_(Color3f::white), position_(0.f, 0.f, 0.f),
	worldPosition_(0.f, 0.f, 0.f), range_(Limit::floatMaxSqrt),
	globalRange_(Limit::floatMaxSqrt), attenuation0_(1.f), attenuation1_(0.f),
	attenuation2_(0.f), squaredCameraDistance_(0.f){
}
//------------------------------------------------------------------------------
// fXgN^
PointLight::~PointLight(){
}
//------------------------------------------------------------------------------
// |CgCg̃Rs[
PointLight* PointLight::copyPointLight() const{
	LightManager* manager = scene_->getLightManager();
	PointLight* copyLight =
		manager->createPointLight(manager->rename(name_));
	// Cg̒lRs[
	copyLightValue(copyLight);
	// õRs[
	copyLight->setDiffuseColor(diffuseColor_);
	copyLight->setSpecularColor(specularColor_);
	copyLight->setPosition(position_);
	copyLight->setRange(range_);
	copyLight->setAttenuation(attenuation0_, attenuation1_, attenuation2_);
	return copyLight;
}
//------------------------------------------------------------------------------
// 
void PointLight::traverse(const Matrix34& parentMatrix,
	bool parentEnabled, bool parentScaled, bool parentChanged){
	Light::traverse(parentMatrix, parentEnabled, parentScaled, parentChanged);
	// ʒu[hWɕϊ
	worldPosition_ = parentMatrix * position_;
	// Cgɑ΂XP[̔fBAssert(false);Ŏ~߂ق
	if(!parentScaled){
		globalRange_ = range_;
	}else{
		// XP[Ăꍇ͔ae̍őlɂ
		// xNg(1,0,0),(0,1,0),(0,0,1)ϊčŒ̒𔼌aɏZ
		float maxSquardLength = 0.f;
		for(int i = 0; i < 3; i++){
			float squaredLength =
				parentMatrix.m[0][i] * parentMatrix.m[0][i] +
				parentMatrix.m[1][i] * parentMatrix.m[1][i] +
				parentMatrix.m[2][i] * parentMatrix.m[2][i];
			if(squaredLength > maxSquardLength){
				maxSquardLength = squaredLength;
			}
		}
		globalRange_ = range_ * Math::sqrt(maxSquardLength);
	}
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
