//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Cg}l[W
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Light/LightManager.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
LightManager::LightManager(Scene* scene) :
	SceneObjectManagerTemplate<Light>(scene){
}
//------------------------------------------------------------------------------
// ArGgCg̍쐬
AmbientLight* LightManager::createAmbientLight(const String& lightName){
	if(!checkName(lightName)){ return NULL; }
	AmbientLight* light = new AmbientLight(lightName, getScene());
	addDatabase(lightName, light);
	return light;
}
//------------------------------------------------------------------------------
// fBNViCg̍쐬
DirectionalLight* LightManager::createDirectionalLight(const String& lightName){
	if(!checkName(lightName)){ return NULL; }
	DirectionalLight* light = new DirectionalLight(lightName, getScene());
	addDatabase(lightName, light);
	return light;
}
//------------------------------------------------------------------------------
// |CgCg̍쐬
PointLight* LightManager::createPointLight(const String& lightName){
	if(!checkName(lightName)){ return NULL; }
	PointLight* light = new PointLight(lightName, getScene());
	addDatabase(lightName, light);
	return light;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
