//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Cg
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Light/Light.h"
#include "Graphics/Light/LightManager.h"
#include "Graphics/Mesh/Mesh.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
Light::Light(const String& name, Scene* scene) : SceneLeaf(name, scene),
	lightMask_(1){
}
//------------------------------------------------------------------------------
// fXgN^
Light::~Light(){
}
//------------------------------------------------------------------------------
// Cg̒lRs[
void Light::copyLightValue(Light* destination) const{
	// V[[t̒lRs[
	copySceneLeafValue(destination);
	// Cg}XN
	destination->setLightMask(lightMask_);
}
//------------------------------------------------------------------------------
// j
int Light::destroy(Light* light){
	Assert(light != NULL);
	// ̔j
	LightManager* manager = light->getScene()->getLightManager();
	if(manager->destroy(light) == 0){ return 1; }
	return 0;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
