//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * fBNViCg
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Light/DirectionalLight.h"
#include "Graphics/Scene/Scene.h"
#include "Graphics/Light/LightManager.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
DirectionalLight::DirectionalLight(const String& name, Scene* scene) :
	GlobalLight(name, scene), diffuseColor_(Color3f::white),
	specularColor_(Color3f::white), direction_(0.f, -1.f, 0.f),
	worldDirection_(0.f, -1.f, 0.f){
}
//------------------------------------------------------------------------------
// fXgN^
DirectionalLight::~DirectionalLight(){
}
//------------------------------------------------------------------------------
// fBNViCg̃Rs[
DirectionalLight* DirectionalLight::copyDirectionalLight() const{
	LightManager* manager = scene_->getLightManager();
	DirectionalLight* copyLight =
		manager->createDirectionalLight(manager->rename(name_));
	// Cg̒lRs[
	copyLightValue(copyLight);
	// õRs[
	copyLight->setDiffuseColor(diffuseColor_);
	copyLight->setSpecularColor(specularColor_);
	copyLight->setDirection(direction_);
	return copyLight;
}
//------------------------------------------------------------------------------
// 
void DirectionalLight::traverse(const Matrix34& parentMatrix,
	bool parentEnabled, bool parentScaled, bool parentChanged){
	Light::traverse(parentMatrix, parentEnabled, parentScaled, parentChanged);
	// [h̕Zo
	worldDirection_ = parentMatrix.multiply33(direction_);
	// Cgɑ΂XP[̔fBAssert(false);Ŏ~߂ق
	if(parentScaled){ worldDirection_.normalize(); }
	Assert(worldDirection_.isUnit());
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
