//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * tHO
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Fog/Fog.h"

namespace Lamp{

// ~bgl
const float Fog::limitValue = 10000.f;// 

// whbvIt~bgW
const float Fog::exponentLimit = Math::log(64.f);// 256/4

// ̎whbvIt~bgW
const float Fog::exponent2Limit = Math::sqrt(Math::log(64.f));// 256/4

//------------------------------------------------------------------------------
// RXgN^
Fog::Fog() : color_(128, 128, 128, 0), mode_(modeLinear),
	density_(0.5f), fogNear_(1.f), fogFar_(limitValue), enabled_(false){
}
//------------------------------------------------------------------------------
// fXgN^
Fog::~Fog(){
}
//------------------------------------------------------------------------------
// El̎擾
float Fog::getLimit(){
	if(enabled_){
		if(mode_ == modeLinear){
			return fogFar_;
		}else if(mode_ == modeExponent){
			return (exponentLimit / density_);
		}else if(mode_ == modeExponent2){
			return (exponent2Limit / density_);
		}
	}
	return limitValue;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
