//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OtBbNXfoCX
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Enumeration/GraphicsDeviceInformation.h"
#include "Graphics/Enumeration/GraphicsDeviceEnumeration.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Primitive/GraphicsBufferFormat.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
GraphicsDeviceInformation::GraphicsDeviceInformation(){
}
//------------------------------------------------------------------------------
// fXgN^
GraphicsDeviceInformation::~GraphicsDeviceInformation(){
	// foCXR{̍폜
	for(int i = getDeviceComboCount() - 1; i >= 0; i--){
		delete getDeviceCombo(i);
	}
}
//------------------------------------------------------------------------------
// 
bool GraphicsDeviceInformation::enumerate(
	GraphicsDeviceEnumeration* enumeration,
	GraphicsAdapterInformation* adapterInformation, D3DDEVTYPE deviceType){
	// o̐ݒ
	adapterOrdinal_ = adapterInformation->getAdapterOrdinal();
	deviceType_ = deviceType;
	// foCX\͂̎擾
	Direct3D* direct3D = LampGraphics::getDirect3D();
	if(DirectXFailed(direct3D->GetDeviceCaps(
		adapterOrdinal_, deviceType_, &deviceCapability_))){
		return false;
	}
	// NULLt@XhCo͖
	if((deviceCapability_.PrimitiveMiscCaps & D3DPMISCCAPS_NULLREFERENCE) != 0){
		return false;
	}

	// foCXR{̗
	// SobNobt@tH[}bg
	const D3DFORMAT backBufferFormats[] = {
		D3DFMT_A8R8G8B8,
		D3DFMT_X8R8G8B8,
		D3DFMT_A2R10G10B10,
		D3DFMT_R5G6B5,
		D3DFMT_A1R5G5B5,
		D3DFMT_X1R5G5B5};
	const u_int backBufferFormatsCount =
		sizeof(backBufferFormats) / sizeof(backBufferFormats[0]);
	const bool isWindowedFlags[] = { false, true };
	// A_v^tH[}bg[v
	int adapterFormatCount = adapterInformation->getAdapterFormatCount();
	for(int i = 0; i < adapterFormatCount; i++){
		D3DFORMAT adapterFormat = adapterInformation->getAdapterFormat(i);
		// obNobt@tH[}bg[v
		for(int j = 0; j < backBufferFormatsCount; j++){
			D3DFORMAT backBufferFormat = backBufferFormats[j];
			GraphicsBufferFormat bufferFormat(backBufferFormat);
			// obNobt@̃At@rbg̃`FbN
			if(bufferFormat.getAlphaChannelBits() <
				enumeration->getMinimumBackBufferAlphaChannelBits()){
				continue;
			}
			// tXN[AEBhE[v
			for(u_int k = 0; k < 2; k++){
				bool isWindowed = isWindowedFlags[k];
				// EBhE[h̃`FbN
				if((!isWindowed) && enumeration->getRequiresWindowMode()){
					continue;
				}
				if(isWindowed && enumeration->getRequiresFullscreenMode()){
					continue;
				}
				// foCX^Cv`FbN
				if(DirectXFailed(direct3D->CheckDeviceType(
					adapterOrdinal_, deviceType_,
					adapterFormat, backBufferFormat, isWindowed))){
					continue;
				}
				// foCXR{̍쐬
				GraphicsDeviceComboInformation* deviceCombo =
					new GraphicsDeviceComboInformation(
					adapterFormat, backBufferFormat, isWindowed);
				if(!deviceCombo->enumerate(enumeration, this)){
					delete deviceCombo;
					continue;
				}
				deviceCombos_.add(deviceCombo);
			}
		}
	}
	return true;
}
//------------------------------------------------------------------------------
// ւ̕ϊ
String GraphicsDeviceInformation::toString(){
	String result;
	if(deviceType_ == D3DDEVTYPE_HAL){
		result = "D3DDEVTYPE_HAL";
	}else if(deviceType_ == D3DDEVTYPE_REF){
		result = "D3DDEVTYPE_REF";
	}else if(deviceType_ == D3DDEVTYPE_SW){
		result = "D3DDEVTYPE_SW";
	}
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
