//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OtBbNXfoCX񋓎
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Enumeration/GraphicsDeviceEnumeration.h"
#include "Graphics/System/LampGraphics.h"

namespace Lamp{

// CX^X
GraphicsDeviceEnumeration* GraphicsDeviceEnumeration::instance_ = NULL;

//------------------------------------------------------------------------------
// RXgN^
GraphicsDeviceEnumeration::GraphicsDeviceEnumeration(){
	Assert(instance_ == NULL);
	instance_ = this;
	enumerated_ = false;
	// ftHg̋tH[}bg
	addAllowedFormat(D3DFMT_X8R8G8B8);
	addAllowedFormat(D3DFMT_X1R5G5B5);
	addAllowedFormat(D3DFMT_R5G6B5);
	addAllowedFormat(D3DFMT_A2R10G10B10);
	// ̃OtBbNXfoCXmFݒ
	setConfirmGraphicsDevice(this);
	// ŏtXN[TCY
	setMinimumFullscreenWidth(640);
	setMinimumFullscreenHeight(480);
	// ŏrbg[x
	setMinimumAdapterColorChannelBits(5);
	setMinimumBackBufferAlphaChannelBits(0);
	setMinimumDepthBits(15);
	setMinimumStencilBits(0);
	// ʃ[h̕Kv
	setRequiresWindowMode(false);
	setRequiresFullscreenMode(false);
	// [xAXeVobt@gp
	setUsesDepthStencilBuffer(true);
	// _ZgpȂ
	setUsesMixedVertexProcessing(false);
}
//------------------------------------------------------------------------------
// fXgN^
GraphicsDeviceEnumeration::~GraphicsDeviceEnumeration(){
	// A_v^̍폜
	for(int i = getAdapterCount() - 1; i >= 0; i--){
		delete getAdapter(i);
	}
	Assert(instance_ == this);
	instance_ = NULL;
}
//------------------------------------------------------------------------------
// 
bool GraphicsDeviceEnumeration::enumerate(){
	if(enumerated_){ return true; }
	Direct3D* direct3D = LampGraphics::getDirect3D();
	u_int adapterCount = direct3D->GetAdapterCount();
	for(u_int i = 0; i < adapterCount; i++){
		GraphicsAdapterInformation* adapter = new GraphicsAdapterInformation(i);
		adapter->enumerate(this);
		// A_v^Ɋ܂܂foCX0Ȃ폜
		if(adapter->getDeviceCount() == 0){
			delete adapter;
			continue;
		}
		adapters_.add(adapter);
	}
	enumerated_ = true;
	return true;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
