//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OtBbNXA_v^
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/Enumeration/GraphicsAdapterInformation.h"
#include "Graphics/Enumeration/GraphicsDeviceEnumeration.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/Primitive/GraphicsBufferFormat.h"

namespace Lamp{

//------------------------------------------------------------------------------
// fBXvC[hr
static int displayModeCompare(
	const D3DDISPLAYMODE* left, const D3DDISPLAYMODE* right){
	if(left->Width > right->Width){ return 1; }
	if(left->Width < right->Width){ return -1; }
	if(left->Height > right->Height){ return 1; }
	if(left->Height < right->Height){ return -1; }
	if(left->Format > right->Format){ return 1; }
	if(left->Format < right->Format){ return -1; }
	if(left->RefreshRate > right->RefreshRate){ return 1; }
	if(left->RefreshRate < right->RefreshRate){ return -1; }
	return 0;
}
//------------------------------------------------------------------------------
// RXgN^
GraphicsAdapterInformation::GraphicsAdapterInformation(int adapterOrdinal) :
	adapterOrdinal_(adapterOrdinal){
}
//------------------------------------------------------------------------------
// fXgN^
GraphicsAdapterInformation::~GraphicsAdapterInformation(){
	// foCX̍폜
	for(int i = getDeviceCount() - 1; i >= 0; i--){
		delete getDevice(i);
	}
}
//------------------------------------------------------------------------------
// 
void GraphicsAdapterInformation::enumerate(
	GraphicsDeviceEnumeration* enumeration){
	// A_v^ʎq̎擾
	Direct3D* direct3D = LampGraphics::getDirect3D();
	direct3D->GetAdapterIdentifier(adapterOrdinal_, 0, &identifier_);
	name_ = identifier_.Description;
	driverName_ = identifier_.Driver;
	u_int minimumWidth = enumeration->getMinimumFullscreenWidth();
	u_int minimumHeight = enumeration->getMinimumFullscreenHeight();
	u_int minimumColorBits = enumeration->getMinimumAdapterColorChannelBits();
	// tH[}bgɂfBXvC[h̗
	int allowedFormatCount = enumeration->getAllowedFormatCount();
	for(int i = 0; i < allowedFormatCount; i++){
		D3DFORMAT allowedFormat = enumeration->getAllowedFormat(i);
		GraphicsBufferFormat bufferFormat(allowedFormat);
		u_int adapterModesCount =
			direct3D->GetAdapterModeCount(adapterOrdinal_, allowedFormat);
		for(u_int j = 0; j < adapterModesCount; j++){
			D3DDISPLAYMODE displayMode;
			direct3D->EnumAdapterModes(
				adapterOrdinal_, allowedFormat, j, &displayMode);
			// ɍȂfBXvC[h͖
			if(displayMode.Width < minimumWidth ||
				displayMode.Height < minimumHeight ||
				bufferFormat.getColorChannelBits() < minimumColorBits){
				continue;
			}
			// fBXvC[h̊i[
			displayModes_.add(displayMode);
			if(adapterFormats_.indexOf(displayMode.Format) == -1){
				adapterFormats_.add(displayMode.Format);
			}
		}
	}
	// fBXvC[h̃\[g
	displayModes_.sort(displayModeCompare);
	// SẴfoCX^Cv
	// D3DDEVTYPE_SWLɂĂƈȉ̃[jOoꍇ
	// No SW device has been registered. GetAdapterCaps fails.
	const D3DDEVTYPE deviceTypes[] = {
		D3DDEVTYPE_HAL,
		D3DDEVTYPE_SW,
		D3DDEVTYPE_REF
	};
	const u_int deviceTypesCount = sizeof(deviceTypes) / sizeof(deviceTypes[0]);
	for(int i = 0; i < deviceTypesCount; i++){
		GraphicsDeviceInformation* device = new GraphicsDeviceInformation();
		bool result = device->enumerate(enumeration, this, deviceTypes[i]);
		// 񋓎sfoCXR{0Ȃ폜
		if((!result) || (device->getDeviceComboCount() == 0)){
			delete device;
			continue;
		}
		devices_.add(device);
	}
}
//------------------------------------------------------------------------------
// ւ̕ϊ
String GraphicsAdapterInformation::toString(){
	String result;
	result.format("%s %d", name_.getBytes(), adapterOrdinal_);
/*
	for(int i = 0; i < getDisplayModeCount(); i++){
		D3DDISPLAYMODE displayMode = getDisplayMode(i);
		GraphicsBufferFormat bufferFormat(displayMode.Format);
		String displayModeString;
		displayModeString.format("\t%s ( %d x %d ) %dHz\n",
			bufferFormat.getName().getBytes(), displayMode.Width, displayMode.Height,
			displayMode.RefreshRate);
		result += displayModeString;
	}
*/
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
