//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * 
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/DeviceSelector/GraphicsDeviceSelector.h"
#include "Graphics/System/GraphicsDeviceSettings.h"
#include "Graphics/Enumeration/GraphicsDeviceEnumeration.h"

namespace Lamp{

//------------------------------------------------------------------------------
// foCXݒ̑I
bool GraphicsDeviceSelector::chooseDeviceSettings(
	HWND windowHandle, bool startFullscreen){
	GraphicsDeviceSettings* settings = GraphicsDeviceSettings::getInstance();
	bool foundWindowed = findBestWindowedMode(windowHandle, false, false);
	bool foundFullscreen = findBestFullscreenMode(windowHandle, false, false);
	// ftHg̓EBhE[h
	settings->setWindowed(true);
	// tXN[v΃tXN[
	if(startFullscreen && foundFullscreen){ settings->setWindowed(false); }
	// tXN[Ȃ΃tXN[
	if((!foundWindowed) && foundFullscreen){ settings->setWindowed(false); }
	// ȂΎs
	if((!foundWindowed) && (!foundFullscreen)){ return false; }
	return true;
}
//------------------------------------------------------------------------------
// EChE[hݒ̍\z
void GraphicsDeviceSelector::buildWindowModeSettings(
	HWND windowHandle, const D3DDISPLAYMODE& displayMode,
	GraphicsAdapterInformation* bestAdapter,
	GraphicsDeviceInformation* bestDevice,
	GraphicsDeviceComboInformation* bestDeviceCombo){
	// ݒɃRs[
	GraphicsDeviceEnumeration* enumeration =
		GraphicsDeviceEnumeration::getInstance();
	GraphicsDeviceSettings* settings = GraphicsDeviceSettings::getInstance();
	settings->setWindowed(true);
	settings->setAdapterInformation(bestAdapter);
	settings->setDeviceInformation(bestDevice);
	settings->setDeviceComboInformation(bestDeviceCombo);
	settings->setDisplayMode(displayMode);
	if(enumeration->getUsesDepthStencilBuffer()){
		// 񋓂ŐĂȂ΁AD3DFMT_D16gpB
		settings->setDepthStencilFormat(
			bestDeviceCombo->getDepthStencilFormat(0));
	}
	// }`Tv[hD3DMULTISAMPLE_NONEftHg
	settings->setMultiSampleType(bestDeviceCombo->getMultiSampleType(0));
	settings->setMultiSampleQuality(0);
	// Pure Hardware Mixed SoftwarȅŎgpł̂gpB
	settings->setVertexProcessingType(
		bestDeviceCombo->getVertexProcessingType(0));
	// v[e[VԊuD3DPRESENT_INTERVAL_IMMEDIATEftHg
	settings->setPresentationInterval(
		bestDeviceCombo->getPresentationInterval(0));
	// EBhETCYݒ
	RECT windowRect;
	::GetClientRect(windowHandle, &windowRect);
	DimensionI windowSize(windowRect.right - windowRect.left,
		windowRect.bottom - windowRect.top);
	settings->setWindowSize(windowSize);

DebugOut("BestWindow %s %s\n%s\n",
	bestAdapter->toString().getBytes(),
	bestDevice->toString().getBytes(),
	bestDeviceCombo->toString().getBytes());
DebugOut("( %d x %d ) %dHz window (%d x %d)\n\n",
	displayMode.Width, displayMode.Height,
	displayMode.RefreshRate, windowSize.width, windowSize.height);

}
//------------------------------------------------------------------------------
// tXN[[hݒ̍\z
void GraphicsDeviceSelector::buildFullscreenModeSettings(
	const D3DDISPLAYMODE& displayMode,
	GraphicsAdapterInformation* bestAdapter,
	GraphicsDeviceInformation* bestDevice,
	GraphicsDeviceComboInformation* bestDeviceCombo){
	// ݒɃRs[
	GraphicsDeviceEnumeration* enumeration =
		GraphicsDeviceEnumeration::getInstance();
	GraphicsDeviceSettings* settings = GraphicsDeviceSettings::getInstance();
	settings->setWindowed(false);
	settings->setAdapterInformation(bestAdapter);
	settings->setDeviceInformation(bestDevice);
	settings->setDeviceComboInformation(bestDeviceCombo);
	settings->setDisplayMode(displayMode);
	if(enumeration->getUsesDepthStencilBuffer()){
		// 񋓂ŐĂȂ΁AD3DFMT_D16gpB
		settings->setDepthStencilFormat(
			bestDeviceCombo->getDepthStencilFormat(0));
	}
	// }`Tv[hD3DMULTISAMPLE_NONEftHg
	settings->setMultiSampleType(bestDeviceCombo->getMultiSampleType(0));
	settings->setMultiSampleQuality(0);
	// Pure Hardware Mixed SoftwarȅŎgpł̂gpB
	settings->setVertexProcessingType(
		bestDeviceCombo->getVertexProcessingType(0));
	// v[e[VԊuD3DPRESENT_INTERVAL_IMMEDIATEftHg
	settings->setPresentationInterval(
		bestDeviceCombo->getPresentationInterval(0));

DebugOut("BestFullscreen %s %s\n%s\n",
	bestAdapter->toString().getBytes(),
	bestDevice->toString().getBytes(),
	bestDeviceCombo->toString().getBytes());
DebugOut("( %d x %d ) %dHz\n\n",
	displayMode.Width, displayMode.Height,
	displayMode.RefreshRate);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
