//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * fXNgbvOtBbNXfoCXZN^
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics/DeviceSelector/DesktopGraphicsDeviceSelector.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/System/GraphicsDeviceSettings.h"
#include "Graphics/Enumeration/GraphicsDeviceEnumeration.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
DesktopGraphicsDeviceSelector::DesktopGraphicsDeviceSelector(){
}
//------------------------------------------------------------------------------
// fXgN^
DesktopGraphicsDeviceSelector::~DesktopGraphicsDeviceSelector(){
}
//------------------------------------------------------------------------------
// EBhE[h̍œKȐݒT
bool DesktopGraphicsDeviceSelector::findBestWindowedMode(
	HWND windowHandle, bool requireHAL, bool requireREF){
	Direct3D* direct3D = LampGraphics::getDirect3D();
	GraphicsDeviceEnumeration* enumeration =
		GraphicsDeviceEnumeration::getInstance();
	// œKȃfoCXQ
	GraphicsAdapterInformation* bestAdapter = NULL;
	GraphicsDeviceInformation* bestDevice = NULL;
	GraphicsDeviceComboInformation* bestDeviceCombo = NULL;
	// EBhE̓vC}fXNgbvɂƉ肷
	D3DDISPLAYMODE primaryDesktopDisplayMode;
	direct3D->GetAdapterDisplayMode(0, &primaryDesktopDisplayMode);
	// œKȃfoCXT
	bool foundBestDevice = false;
	// A_v^[v
	int adapterCount = enumeration->getAdapterCount();
	for(int i = 0; i < adapterCount; i++){
		GraphicsAdapterInformation* adapter = enumeration->getAdapter(i);
		// foCX[v
		int deviceCount = adapter->getDeviceCount();
		for(int j = 0; j < deviceCount; j++){
			GraphicsDeviceInformation* device = adapter->getDevice(j);
			// HALvɓȂȂ疳
			if(requireHAL && (device->getDeviceType() != D3DDEVTYPE_HAL)){
				continue;
			}
			// REFvɓȂȂ疳
			if(requireREF && (device->getDeviceType() != D3DDEVTYPE_REF)){
				continue;
			}
			// foCXR{[v
			int deviceComboCount = device->getDeviceComboCount();
			for(int k = 0; k < deviceComboCount; k++){
				GraphicsDeviceComboInformation* combo =
					device->getDeviceCombo(k);
				// tXN[[hȂ疳
				if(!combo->isWindowed()){ continue; }
				// tH[}bgȂΖ
				if(combo->getAdapterFormat() !=
					primaryDesktopDisplayMode.Format){ continue; }
				// obNobt@ƃtH[}bgv
				bool matchedBackBuffer = 
					(combo->getAdapterFormat() == combo->getBackBufferFormat());
				if(	// foCXR{NULLȂ獇i
					(bestDeviceCombo == NULL) ||
					// HALɑΉł悤ɂȂȂ獇i
					((bestDeviceCombo->getDeviceType() != D3DDEVTYPE_HAL) &&
						(combo->getDeviceType() == D3DDEVTYPE_HAL)) ||
					// HALŃobNobt@vȂ獇i
					((bestDeviceCombo->getDeviceType() == D3DDEVTYPE_HAL) &&
						matchedBackBuffer)
				){
					bestAdapter = adapter;
					bestDevice = device;
					bestDeviceCombo = combo;
					// ō̏Ȃ烋[vI
					if((device->getDeviceType() == D3DDEVTYPE_HAL) &&
						matchedBackBuffer){
						foundBestDevice = true;
						break;
					}
				}
			}
			if(foundBestDevice){ break; }
		}
		if(foundBestDevice){ break; }
	}
	// foCX𔭌łȂΎs
	if(bestDeviceCombo == NULL){ return false; }

	// ݒɃRs[
	buildWindowModeSettings(windowHandle, primaryDesktopDisplayMode,
		bestAdapter, bestDevice, bestDeviceCombo);
	return true;
}
//------------------------------------------------------------------------------
// tXN[[h̍œKȐݒT
bool DesktopGraphicsDeviceSelector::findBestFullscreenMode(
	HWND windowHandle, bool requireHAL, bool requireREF){
	Direct3D* direct3D = LampGraphics::getDirect3D();
	GraphicsDeviceEnumeration* enumeration =
		GraphicsDeviceEnumeration::getInstance();
	// œKȃfoCXQ
	GraphicsAdapterInformation* bestAdapter = NULL;
	GraphicsDeviceInformation* bestDevice = NULL;
	GraphicsDeviceComboInformation* bestDeviceCombo = NULL;
	// œKȃfXNgbṽfBXvC[h
	// ݂̃fXNgbvfBXvC[hɍ킻Ƃ܂
	D3DDISPLAYMODE bestDesktopDisplayMode;
	// œKȃfoCXT
	bool foundBestDevice = false;
	// A_v^[v
	int adapterCount = enumeration->getAdapterCount();
	for(int i = 0; i < adapterCount; i++){
		GraphicsAdapterInformation* adapter = enumeration->getAdapter(i);
		// A_v^fBXvC[h擾
		D3DDISPLAYMODE desktopDisplayMode;
		direct3D->GetAdapterDisplayMode(
			adapter->getAdapterOrdinal(), &desktopDisplayMode);
		// foCX[v
		int deviceCount = adapter->getDeviceCount();
		for(int j = 0; j < deviceCount; j++){
			GraphicsDeviceInformation* device = adapter->getDevice(j);
			// HALvɓȂȂ疳
			if(requireHAL && (device->getDeviceType() != D3DDEVTYPE_HAL)){
				continue;
			}
			// REFvɓȂȂ疳
			if(requireREF && (device->getDeviceType() != D3DDEVTYPE_REF)){
				continue;
			}
			// foCXR{[v
			int deviceComboCount = device->getDeviceComboCount();
			for(int k = 0; k < deviceComboCount; k++){
				GraphicsDeviceComboInformation* combo =
					device->getDeviceCombo(k);
				// EBhE[hȂ疳
				if(combo->isWindowed()){ continue; }
				// fXNgbvƃtH[}bgv
				bool matchedDesktop =
					(combo->getAdapterFormat() == desktopDisplayMode.Format);
				// obNobt@ƃtH[}bgv
				bool matchedBackBuffer = 
					(combo->getAdapterFormat() == combo->getBackBufferFormat());
				// foCXR{̐R
				if(	// foCXR{NULLȂ獇i
					(bestDeviceCombo == NULL) ||
					// HALɑΉł悤ɂȂȂ獇i
					((bestDeviceCombo->getDeviceType() != D3DDEVTYPE_HAL) &&
						(combo->getDeviceType() == D3DDEVTYPE_HAL)) ||
					// HALŃfXNgbvtH[}bgvł悤ɂȂȂ獇i
					((bestDeviceCombo->getDeviceType() == D3DDEVTYPE_HAL) &&
						(bestDeviceCombo->getAdapterFormat() !=
							desktopDisplayMode.Format) && matchedDesktop) ||
					// HALŃfXNgbvobNobt@vȂ獇i
					((bestDeviceCombo->getDeviceType() == D3DDEVTYPE_HAL) &&
						matchedDesktop && matchedBackBuffer)
				){
					// îŃf[^ۑ
					bestDesktopDisplayMode = desktopDisplayMode;
					bestAdapter = adapter;
					bestDevice = device;
					bestDeviceCombo = combo;
					// ō̏Ȃ烋[vI
					if((device->getDeviceType() == D3DDEVTYPE_HAL) &&
						matchedDesktop && matchedBackBuffer){
						foundBestDevice = true;
						break;
					}
				}
			}
			if(foundBestDevice){ break; }
		}
		if(foundBestDevice){ break; }
	}
	// foCX𔭌łȂΎs
	if(bestDeviceCombo == NULL){ return false; }
/*
	// œKȃfBXvC[hT
	D3DDISPLAYMODE bestDisplayMode;
	bestDisplayMode.Width = 0;
	bestDisplayMode.Height = 0;
	bestDisplayMode.Format = D3DFMT_UNKNOWN;
	bestDisplayMode.RefreshRate = 0;
	int displayModeCount = bestAdapter->getDisplayModeCount();
	for(int i = 0; i < displayModeCount; i++){
		D3DDISPLAYMODE displayMode = bestAdapter->getDisplayMode(i);
		// tH[}bgႦΖ
		if(bestDeviceCombo->getAdapterFormat() != displayMode.Format){
			continue;
		}
		// fXNgbvƊSvI
		if((displayMode.Width == bestDesktopDisplayMode.Width) &&
			(displayMode.Height == bestDesktopDisplayMode.Height) &&
			(displayMode.RefreshRate == bestDesktopDisplayMode.RefreshRate)){
			bestDisplayMode = displayMode;
			break;
		// tbV[g傫Ȃ獇i
		}else if((displayMode.Width == bestDesktopDisplayMode.Width) &&
			(displayMode.Height == bestDesktopDisplayMode.Height) &&
			(displayMode.RefreshRate > bestDesktopDisplayMode.RefreshRate)){
			bestDisplayMode = displayMode;
		// Ȃ獇i
		}else if(displayMode.Width == bestDesktopDisplayMode.Width){
			bestDisplayMode = displayMode;
		// ߂̃fBXvC[h͍i
		}else if(bestDisplayMode.Width == 0){
			bestDisplayMode = displayMode;
		}
	}
//*/
//*
	// œKȃfBXvC[hT
	RECT windowRect;
	::GetClientRect(windowHandle, &windowRect);
	DimensionI windowSize(windowRect.right - windowRect.left,
		windowRect.bottom - windowRect.top);
	D3DDISPLAYMODE bestDisplayMode;
	bestDisplayMode.Width = 0;
	bestDisplayMode.Height = 0;
	bestDisplayMode.Format = D3DFMT_UNKNOWN;
	bestDisplayMode.RefreshRate = 0;
	int displayModeCount = bestAdapter->getDisplayModeCount();
	for(int i = 0; i < displayModeCount; i++){
		D3DDISPLAYMODE displayMode = bestAdapter->getDisplayMode(i);
		// tH[}bgႦΖ
		if(bestDeviceCombo->getAdapterFormat() != displayMode.Format){
			continue;
		}
		// ߂̃fBXvC[h͍i
		if(bestDisplayMode.Width == 0){
			bestDisplayMode = displayMode;
			continue;
		}
		// Εsi
		int newWidthDist = Math::abs((int)(
			(int)windowSize.width - (int)displayMode.Width));
		int bestWidthDist = Math::abs((int)(
			(int)windowSize.width - (int)bestDisplayMode.Width));
		if(newWidthDist > bestWidthDist){ continue; }
		// łȂ΍i
		if(newWidthDist != bestWidthDist){
			bestDisplayMode = displayMode;
			continue;
		}
		// ꍇAΕsi
		int newHeightDist = Math::abs((int)(
			(int)windowSize.height - (int)displayMode.Height));
		int bestHeightDist = Math::abs((int)(
			(int)windowSize.height - (int)bestDisplayMode.Height));
		if(newHeightDist > bestHeightDist){ continue; }
		// ꍇAłȂ΍i
		if(newHeightDist != bestHeightDist){
			bestDisplayMode = displayMode;
			continue;
		}
		// ꍇAtbV[gႦΕsi
		int newRefreshDist = Math::abs((int)(
			(int)bestDesktopDisplayMode.RefreshRate -
			(int)displayMode.RefreshRate));
		int bestRefreshDist = Math::abs((int)(
			(int)bestDesktopDisplayMode.RefreshRate -
			(int)bestDisplayMode.RefreshRate));
		if(newRefreshDist > bestRefreshDist){ continue; }
		// łȂ΍i
		bestDisplayMode = displayMode;
	}
//*/
	// ݒɃRs[
	buildFullscreenModeSettings(
		bestDisplayMode, bestAdapter, bestDevice, bestDeviceCombo);
	return true;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
