//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Op
 * @author Junpee
 */

#include "LampBasic.h"
#include "Geometry/System/Intersection.h"
#include "Geometry/Primitive/Triangle.h"
#include "Geometry/Distance/AxisAlignedBoxDistance.h"
#include "Geometry/Distance/CapsuleDistance.h"
#include "Geometry/Distance/ConeDistance.h"
#include "Geometry/Distance/LineDistance.h"
#include "Geometry/Distance/OrientedBoxDistance.h"
#include "Geometry/Distance/PlaneDistance.h"
#include "Geometry/Distance/RayDistance.h"
#include "Geometry/Distance/SegmentDistance.h"
#include "Geometry/Distance/SphereDistance.h"
#include "Geometry/Distance/TriangleDistance.h"
#include "Geometry/Intersection/AxisAlignedBoxIntersection.h"
#include "Geometry/Intersection/CapsuleIntersection.h"
#include "Geometry/Intersection/ConeIntersection.h"
#include "Geometry/Intersection/LineIntersection.h"
#include "Geometry/Intersection/OrientedBoxIntersection.h"
#include "Geometry/Intersection/PlaneIntersection.h"
#include "Geometry/Intersection/RayIntersection.h"
#include "Geometry/Intersection/SegmentIntersection.h"
#include "Geometry/Intersection/SphereIntersection.h"
#include "Geometry/Intersection/TriangleIntersection.h"

namespace Lamp{

//------------------------------------------------------------------------------
// 萔
//------------------------------------------------------------------------------
// [Op
const Triangle Triangle::zero(Vector3::zero, Vector3::zero, Vector3::zero);

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// _̓
float Triangle::getSquaredDistance(const Vector3& point) const{
	return TriangleDistance::squaredDistance(*this, point);
}
//------------------------------------------------------------------------------
// {bNX̓
float Triangle::getSquaredDistance(const AxisAlignedBox& axisAlignedBox) const{
	return AxisAlignedBoxDistance::squaredDistance(axisAlignedBox, *this);
}
//------------------------------------------------------------------------------
// JvZ̓
float Triangle::getSquaredDistance(const Capsule& capsule) const{
	return CapsuleDistance::squaredDistance(capsule, *this);
}
//------------------------------------------------------------------------------
// R[̓
float Triangle::getSquaredDistance(const Cone& cone) const{
	return ConeDistance::squaredDistance(cone, *this);
}
//------------------------------------------------------------------------------
// C̓
float Triangle::getSquaredDistance(const Line& line) const{
	return LineDistance::squaredDistance(line, *this);
}
//------------------------------------------------------------------------------
// w{bNX̓
float Triangle::getSquaredDistance(const OrientedBox& orientedBox) const{
	return OrientedBoxDistance::squaredDistance(orientedBox, *this);
}
//------------------------------------------------------------------------------
// ʋ
float Triangle::getDistance(const Plane& plane) const{
	return PlaneDistance::distance(plane, *this);
}
//------------------------------------------------------------------------------
// C̓
float Triangle::getSquaredDistance(const Ray& ray) const{
	return RayDistance::squaredDistance(ray, *this);
}
//------------------------------------------------------------------------------
// ZOg̓
float Triangle::getSquaredDistance(const Segment& segment) const{
	return SegmentDistance::squaredDistance(segment, *this);
}
//------------------------------------------------------------------------------
// ̓
float Triangle::getSquaredDistance(const Sphere& sphere) const{
	return SphereDistance::squaredDistance(sphere, *this);
}
//------------------------------------------------------------------------------
// Op̓
float Triangle::getSquaredDistance(const Triangle& triangle) const{
	return TriangleDistance::squaredDistance(*this, triangle);
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// _
bool Triangle::intersect(const Vector3& point, float range) const{
	return TriangleIntersection::intersect(*this, point, range);
}
//------------------------------------------------------------------------------
// {bNX
bool Triangle::intersect(const AxisAlignedBox& axisAlignedBox) const{
	return AxisAlignedBoxIntersection::intersect(axisAlignedBox, *this);
}
//------------------------------------------------------------------------------
// R[
bool Triangle::intersect(const Cone& cone) const{
	return ConeIntersection::intersect(cone, *this);
}
//------------------------------------------------------------------------------
// JvZ
bool Triangle::intersect(const Capsule& capsule) const{
	return CapsuleIntersection::intersect(capsule, *this);
}
//------------------------------------------------------------------------------
// C
bool Triangle::intersect(const Line& line) const{
	return LineIntersection::intersect(line, *this);
}
//------------------------------------------------------------------------------
// w{bNX
bool Triangle::intersect(const OrientedBox& orientedBox) const{
	return OrientedBoxIntersection::intersect(orientedBox, *this);
}
//------------------------------------------------------------------------------
// ʌ
bool Triangle::intersect(const Plane& plane) const{
	return PlaneIntersection::intersect(plane, *this);
}
//------------------------------------------------------------------------------
// C
bool Triangle::intersect(const Ray& ray) const{
	return RayIntersection::intersect(ray, *this);
}
//------------------------------------------------------------------------------
// ZOg
bool Triangle::intersect(const Segment& segment) const{
	return SegmentIntersection::intersect(segment, *this);
}
//------------------------------------------------------------------------------
// 
bool Triangle::intersect(const Sphere& sphere) const{
	return SphereIntersection::intersect(sphere, *this);
}
//------------------------------------------------------------------------------
// 
bool Triangle::intersect(Intersection* intersection, const Sphere& sphere) const{
	bool result = SphereIntersection::intersect(intersection, sphere, *this);
	if(result){ intersection->reverse(); }
	return result;
}
//------------------------------------------------------------------------------
// Op
bool Triangle::intersect(const Triangle& triangle) const{
	return TriangleIntersection::intersect(*this, triangle);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
