//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * 
 * @author Junpee
 */

#include "LampBasic.h"
#include "Geometry/Primitive/Sphere.h"
#include "Geometry/Distance/AxisAlignedBoxDistance.h"
#include "Geometry/Distance/CapsuleDistance.h"
#include "Geometry/Distance/ConeDistance.h"
#include "Geometry/Distance/LineDistance.h"
#include "Geometry/Distance/OrientedBoxDistance.h"
#include "Geometry/Distance/PlaneDistance.h"
#include "Geometry/Distance/RayDistance.h"
#include "Geometry/Distance/SegmentDistance.h"
#include "Geometry/Distance/SphereDistance.h"
#include "Geometry/Intersection/AxisAlignedBoxIntersection.h"
#include "Geometry/Intersection/CapsuleIntersection.h"
#include "Geometry/Intersection/ConeIntersection.h"
#include "Geometry/Intersection/LineIntersection.h"
#include "Geometry/Intersection/OrientedBoxIntersection.h"
#include "Geometry/Intersection/PlaneIntersection.h"
#include "Geometry/Intersection/RayIntersection.h"
#include "Geometry/Intersection/SegmentIntersection.h"
#include "Geometry/Intersection/SphereIntersection.h"

namespace Lamp{

//------------------------------------------------------------------------------
// 萔
//------------------------------------------------------------------------------
// [
const Sphere Sphere::zero(0.f, 0.f, 0.f, 0.f);

// Pʋ
const Sphere Sphere::unit(0.f, 0.f, 0.f, 1.f);

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// _̓
float Sphere::getSquaredDistance(const Vector3& point) const{
	return SphereDistance::squaredDistance(*this, point);
}
//------------------------------------------------------------------------------
// {bNX̓
float Sphere::getSquaredDistance(const AxisAlignedBox& axisAlignedBox) const{
	return AxisAlignedBoxDistance::squaredDistance(axisAlignedBox, *this);
}
//------------------------------------------------------------------------------
// JvZ̓
float Sphere::getSquaredDistance(const Capsule& capsule) const{
	return CapsuleDistance::squaredDistance(capsule, *this);
}
//------------------------------------------------------------------------------
// R[̓
float Sphere::getSquaredDistance(const Cone& cone) const{
	return ConeDistance::squaredDistance(cone, *this);
}
//------------------------------------------------------------------------------
// C̓
float Sphere::getSquaredDistance(const Line& line) const{
	return LineDistance::squaredDistance(line, *this);
}
//------------------------------------------------------------------------------
// w{bNX̓
float Sphere::getSquaredDistance(const OrientedBox& orientedBox) const{
	return OrientedBoxDistance::squaredDistance(orientedBox, *this);
}
//------------------------------------------------------------------------------
// ʋ
float Sphere::getDistance(const Plane& plane) const{
	return PlaneDistance::distance(plane, *this);
}
//------------------------------------------------------------------------------
// C̓
float Sphere::getSquaredDistance(const Ray& ray) const{
	return RayDistance::squaredDistance(ray, *this);
}
//------------------------------------------------------------------------------
// ZOg̓
float Sphere::getSquaredDistance(const Segment& segment) const{
	return SegmentDistance::squaredDistance(segment, *this);
}
//------------------------------------------------------------------------------
// ̓
float Sphere::getSquaredDistance(const Sphere& sphere) const{
	return SphereDistance::squaredDistance(*this, sphere);
}
//------------------------------------------------------------------------------
// Op̓
float Sphere::getSquaredDistance(const Triangle& triangle) const{
	return SphereDistance::squaredDistance(*this, triangle);
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// _
bool Sphere::intersect(const Vector3& point) const{
	return SphereIntersection::intersect(*this, point);
}
//------------------------------------------------------------------------------
// {bNX
bool Sphere::intersect(const AxisAlignedBox& axisAlignedBox) const{
	return AxisAlignedBoxIntersection::intersect(axisAlignedBox, *this);
}
//------------------------------------------------------------------------------
// R[
bool Sphere::intersect(const Cone& cone) const{
	return ConeIntersection::intersect(cone, *this);
}
//------------------------------------------------------------------------------
// JvZ
bool Sphere::intersect(const Capsule& capsule) const{
	return CapsuleIntersection::intersect(capsule, *this);
}
//------------------------------------------------------------------------------
// C
bool Sphere::intersect(const Line& line) const{
	return LineIntersection::intersect(line, *this);
}
//------------------------------------------------------------------------------
// w{bNX
bool Sphere::intersect(const OrientedBox& orientedBox) const{
	return OrientedBoxIntersection::intersect(orientedBox, *this);
}
//------------------------------------------------------------------------------
// ʌ
bool Sphere::intersect(const Plane& plane) const{
	return PlaneIntersection::intersect(plane, *this);
}
//------------------------------------------------------------------------------
// C
bool Sphere::intersect(const Ray& ray) const{
	return RayIntersection::intersect(ray, *this);
}
//------------------------------------------------------------------------------
// ZOg
bool Sphere::intersect(const Segment& segment) const{
	return SegmentIntersection::intersect(segment, *this);
}
//------------------------------------------------------------------------------
// 
bool Sphere::intersect(const Sphere& sphere) const{
	return SphereIntersection::intersect(*this, sphere);
}
//------------------------------------------------------------------------------
// 
bool Sphere::intersect(Intersection* intersection, const Sphere& sphere) const{
	return SphereIntersection::intersect(intersection, *this, sphere);
}
//------------------------------------------------------------------------------
// Op
bool Sphere::intersect(const Triangle& triangle) const{
	return SphereIntersection::intersect(*this, triangle);
}
//------------------------------------------------------------------------------
// Op
bool Sphere::intersect(
	Intersection* intersection, const Triangle& triangle) const{
	return SphereIntersection::intersect(intersection, *this, triangle);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
