//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * C
 * @author Junpee
 */

#include "LampBasic.h"
#include "Geometry/Primitive/Ray.h"
#include "Geometry/Distance/AxisAlignedBoxDistance.h"
#include "Geometry/Distance/CapsuleDistance.h"
#include "Geometry/Distance/ConeDistance.h"
#include "Geometry/Distance/LineDistance.h"
#include "Geometry/Distance/OrientedBoxDistance.h"
#include "Geometry/Distance/PlaneDistance.h"
#include "Geometry/Distance/RayDistance.h"
#include "Geometry/Intersection/AxisAlignedBoxIntersection.h"
#include "Geometry/Intersection/CapsuleIntersection.h"
#include "Geometry/Intersection/ConeIntersection.h"
#include "Geometry/Intersection/LineIntersection.h"
#include "Geometry/Intersection/OrientedBoxIntersection.h"
#include "Geometry/Intersection/PlaneIntersection.h"
#include "Geometry/Intersection/RayIntersection.h"

namespace Lamp{

//------------------------------------------------------------------------------
// 萔
//------------------------------------------------------------------------------
/// [C
const Ray Ray::zero(0.f, 0.f, 0.f, 0.f, 0.f, 0.f);

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// _̓
float Ray::getSquaredDistance(const Vector3& point) const{
	return RayDistance::squaredDistance(*this, point);
}
//------------------------------------------------------------------------------
// {bNX̓
float Ray::getSquaredDistance(const AxisAlignedBox& axisAlignedBox) const{
	return AxisAlignedBoxDistance::squaredDistance(axisAlignedBox, *this);
}
//------------------------------------------------------------------------------
// JvZ̓
float Ray::getSquaredDistance(const Capsule& capsule) const{
	return CapsuleDistance::squaredDistance(capsule, *this);
}
//------------------------------------------------------------------------------
// R[̓
float Ray::getSquaredDistance(const Cone& cone) const{
	return ConeDistance::squaredDistance(cone, *this);
}
//------------------------------------------------------------------------------
// C̓
float Ray::getSquaredDistance(const Line& line) const{
	return LineDistance::squaredDistance(line, *this);
}
//------------------------------------------------------------------------------
// w{bNX̓
float Ray::getSquaredDistance(const OrientedBox& orientedBox) const{
	return OrientedBoxDistance::squaredDistance(orientedBox, *this);
}
//------------------------------------------------------------------------------
// ʋ
float Ray::getDistance(const Plane& plane) const{
	return PlaneDistance::distance(plane, *this);
}
//------------------------------------------------------------------------------
// C̓
float Ray::getSquaredDistance(const Ray& ray) const{
	return RayDistance::squaredDistance(*this, ray);
}
//------------------------------------------------------------------------------
// ZOg̓
float Ray::getSquaredDistance(const Segment& segment) const{
	return RayDistance::squaredDistance(*this, segment);
}
//------------------------------------------------------------------------------
// ̓
float Ray::getSquaredDistance(const Sphere& sphere) const{
	return RayDistance::squaredDistance(*this, sphere);
}
//------------------------------------------------------------------------------
// Op̓
float Ray::getSquaredDistance(const Triangle& triangle) const{
	return RayDistance::squaredDistance(*this, triangle);
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// _
bool Ray::intersect(const Vector3& point, float range) const{
	return RayIntersection::intersect(*this, point, range);
}
//------------------------------------------------------------------------------
// {bNX
bool Ray::intersect(const AxisAlignedBox& axisAlignedBox) const{
	return AxisAlignedBoxIntersection::intersect(axisAlignedBox, *this);
}
//------------------------------------------------------------------------------
// JvZ
bool Ray::intersect(const Capsule& capsule) const{
	return CapsuleIntersection::intersect(capsule, *this);
}
//------------------------------------------------------------------------------
// R[
bool Ray::intersect(const Cone& cone) const{
	return ConeIntersection::intersect(cone, *this);
}
//------------------------------------------------------------------------------
// C
bool Ray::intersect(const Line& line, float range) const{
	return LineIntersection::intersect(line, *this, range);
}
//------------------------------------------------------------------------------
// w{bNX
bool Ray::intersect(const OrientedBox& orientedBox) const{
	return OrientedBoxIntersection::intersect(orientedBox, *this);
}
//------------------------------------------------------------------------------
// ʌ
bool Ray::intersect(const Plane& plane) const{
	return PlaneIntersection::intersect(plane, *this);
}
//------------------------------------------------------------------------------
// C
bool Ray::intersect(const Ray& ray, float range) const{
	return RayIntersection::intersect(*this, ray, range);
}
//------------------------------------------------------------------------------
// ZOg
bool Ray::intersect(const Segment& segment, float range) const{
	return RayIntersection::intersect(*this, segment, range);
}
//------------------------------------------------------------------------------
// 
bool Ray::intersect(const Sphere& sphere) const{
	return RayIntersection::intersect(*this, sphere);
}
//------------------------------------------------------------------------------
// Op
bool Ray::intersect(const Triangle& triangle) const{
	return RayIntersection::intersect(*this, triangle);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------

