//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ʎ
 * @author Junpee
 */

#include "LampBasic.h"
#include "Geometry/Primitive/Plane.h"
#include "Geometry/Distance/AxisAlignedBoxDistance.h"
#include "Geometry/Distance/CapsuleDistance.h"
#include "Geometry/Distance/ConeDistance.h"
#include "Geometry/Distance/LineDistance.h"
#include "Geometry/Distance/OrientedBoxDistance.h"
#include "Geometry/Distance/PlaneDistance.h"
#include "Geometry/Intersection/AxisAlignedBoxIntersection.h"
#include "Geometry/Intersection/CapsuleIntersection.h"
#include "Geometry/Intersection/ConeIntersection.h"
#include "Geometry/Intersection/LineIntersection.h"
#include "Geometry/Intersection/OrientedBoxIntersection.h"
#include "Geometry/Intersection/PlaneIntersection.h"

namespace Lamp{

//------------------------------------------------------------------------------
// 萔
//------------------------------------------------------------------------------
// [
const Plane Plane::zero(0.f, 0.f, 0.f, 0.f);

// XPʕ
const Plane Plane::unitX(1.f, 0.f, 0.f, 0.f);

// YPʕ
const Plane Plane::unitY(0.f, 1.f, 0.f, 0.f);

// ZPʕ
const Plane Plane::unitZ(0.f, 0.f, 1.f, 0.f);

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// _
float Plane::getDistance(const Vector3& point) const{
	return PlaneDistance::distance(*this, point);
}
//------------------------------------------------------------------------------
// {bNX
float Plane::getDistance(const AxisAlignedBox& axisAlignedBox) const{
	return AxisAlignedBoxDistance::distance(axisAlignedBox, *this);
}
//------------------------------------------------------------------------------
// JvZ
float Plane::getDistance(const Capsule& capsule) const{
	return CapsuleDistance::distance(capsule, *this);
}
//------------------------------------------------------------------------------
// R[
float Plane::getDistance(const Cone& cone) const{
	return ConeDistance::distance(cone, *this);
}
//------------------------------------------------------------------------------
// C
float Plane::getDistance(const Line& line) const{
	return LineDistance::distance(line, *this);
}
//------------------------------------------------------------------------------
// ʋ
float Plane::getDistance(const Plane& plane) const{
	return PlaneDistance::distance(*this, plane);
}
//------------------------------------------------------------------------------
// w{bNX
float Plane::getDistance(const OrientedBox& orientedBox) const{
	return OrientedBoxDistance::distance(orientedBox, *this);
}
//------------------------------------------------------------------------------
// C
float Plane::getDistance(const Ray& ray) const{
	return PlaneDistance::distance(*this, ray);
}
//------------------------------------------------------------------------------
// ZOg
float Plane::getDistance(const Segment& segment) const{
	return PlaneDistance::distance(*this, segment);
}
//------------------------------------------------------------------------------
// 
float Plane::getDistance(const Sphere& sphere) const{
	return PlaneDistance::distance(*this, sphere);
}
//------------------------------------------------------------------------------
// Op
float Plane::getDistance(const Triangle& triangle) const{
	return PlaneDistance::distance(*this, triangle);
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// _
bool Plane::intersect(const Vector3& point, float range) const{
	return PlaneIntersection::intersect(*this, point, range);
}
//------------------------------------------------------------------------------
// {bNX
bool Plane::intersect(const AxisAlignedBox& axisAlignedBox) const{
	return AxisAlignedBoxIntersection::intersect(axisAlignedBox, *this);
}
//------------------------------------------------------------------------------
// JvZ
bool Plane::intersect(const Capsule& capsule) const{
	return CapsuleIntersection::intersect(capsule, *this);
}
//------------------------------------------------------------------------------
// R[
bool Plane::intersect(const Cone& cone) const{
	return ConeIntersection::intersect(cone, *this);
}
//------------------------------------------------------------------------------
// C
bool Plane::intersect(const Line& line) const{
	return LineIntersection::intersect(line, *this);
}
//------------------------------------------------------------------------------
// w{bNX
bool Plane::intersect(const OrientedBox& orientedBox) const{
	return OrientedBoxIntersection::intersect(orientedBox, *this);
}
//------------------------------------------------------------------------------
// ʌ
bool Plane::intersect(const Plane& plane) const{
	return PlaneIntersection::intersect(*this, plane);
}
//------------------------------------------------------------------------------
// C
bool Plane::intersect(const Ray& ray) const{
	return PlaneIntersection::intersect(*this, ray);
}
//------------------------------------------------------------------------------
// ZOg
bool Plane::intersect(const Segment& segment) const{
	return PlaneIntersection::intersect(*this, segment);
}
//------------------------------------------------------------------------------
// 
bool Plane::intersect(const Sphere& sphere) const{
	return PlaneIntersection::intersect(*this, sphere);
}
//------------------------------------------------------------------------------
// Op
bool Plane::intersect(const Triangle& triangle) const{
	return PlaneIntersection::intersect(*this, triangle);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
