//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * w{bNX
 * @author Junpee
 */

#include "LampBasic.h"
#include "Geometry/Primitive/OrientedBox.h"
#include "Geometry/Distance/AxisAlignedBoxDistance.h"
#include "Geometry/Distance/CapsuleDistance.h"
#include "Geometry/Distance/ConeDistance.h"
#include "Geometry/Distance/LineDistance.h"
#include "Geometry/Distance/OrientedBoxDistance.h"
#include "Geometry/Intersection/AxisAlignedBoxIntersection.h"
#include "Geometry/Intersection/CapsuleIntersection.h"
#include "Geometry/Intersection/ConeIntersection.h"
#include "Geometry/Intersection/LineIntersection.h"
#include "Geometry/Intersection/OrientedBoxIntersection.h"

namespace Lamp{

//------------------------------------------------------------------------------
// 萔
//------------------------------------------------------------------------------
// [{bNX
const OrientedBox OrientedBox::zero(
	Matrix33::zero, Vector3::zero, Vector3::zero);

// Pʃ{bNX
const OrientedBox OrientedBox::unit(
	Matrix33::unit, Vector3::zero, Vector3(0.5f, 0.5f, 0.5f));

//------------------------------------------------------------------------------
// gXtH[
//------------------------------------------------------------------------------
// XP[LgXtH[
AxisAlignedBox OrientedBox::scaledTransform(const Matrix33& matrix) const{
	AxisAlignedBox result;
	Vector3 corner[8];
	getCornerArray(corner);
	Vector3 firstCorner = matrix * corner[7];
	result.set(firstCorner, firstCorner);
	for(int i = 0; i < 7; i++){ result.merge(matrix * corner[i]); }
	return result;
}
//------------------------------------------------------------------------------
// XP[LgXtH[
AxisAlignedBox OrientedBox::scaledTransform(const Matrix34& matrix) const{
	AxisAlignedBox result;
	Vector3 corner[8];
	getCornerArray(corner);
	Vector3 firstCorner = matrix * corner[7];
	result.set(firstCorner, firstCorner);
	for(int i = 0; i < 7; i++){ result.merge(matrix * corner[i]); }
	return result;
}
//------------------------------------------------------------------------------
// XP[LgXtH[
AxisAlignedBox OrientedBox::scaledTransform(const Matrix44& matrix) const{
	AxisAlignedBox result;
	Vector3 corner[8];
	getCornerArray(corner);
	Vector3 firstCorner = matrix * corner[7];
	result.set(firstCorner, firstCorner);
	for(int i = 0; i < 7; i++){ result.merge(matrix * corner[i]); }
	return result;
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// _̓
float OrientedBox::getSquaredDistance(const Vector3& point) const{
	return OrientedBoxDistance::squaredDistance(*this, point);
}
//------------------------------------------------------------------------------
// {bNX̓
float OrientedBox::getSquaredDistance(
	const AxisAlignedBox& axisAlignedBox) const{
	return AxisAlignedBoxDistance::squaredDistance(axisAlignedBox, *this);
}
//------------------------------------------------------------------------------
// JvZ̓
float OrientedBox::getSquaredDistance(const Capsule& capsule) const{
	return CapsuleDistance::squaredDistance(capsule, *this);
}
//------------------------------------------------------------------------------
// R[̓
float OrientedBox::getSquaredDistance(const Cone& cone) const{
	return ConeDistance::squaredDistance(cone, *this);
}
//------------------------------------------------------------------------------
// C̓
float OrientedBox::getSquaredDistance(const Line& line) const{
	return LineDistance::squaredDistance(line, *this);
}
//------------------------------------------------------------------------------
// w{bNX̓
float OrientedBox::getSquaredDistance(
	const OrientedBox& orientedBox) const{
	return OrientedBoxDistance::squaredDistance(*this, orientedBox);
}
//------------------------------------------------------------------------------
// ʋ
float OrientedBox::getDistance(const Plane& plane) const{
	return OrientedBoxDistance::distance(*this, plane);
}
//------------------------------------------------------------------------------
// C̓
float OrientedBox::getSquaredDistance(const Ray& ray) const{
	return OrientedBoxDistance::squaredDistance(*this, ray);
}
//------------------------------------------------------------------------------
// ZOg̓
float OrientedBox::getSquaredDistance(const Segment& segment) const{
	return OrientedBoxDistance::squaredDistance(*this, segment);
}
//------------------------------------------------------------------------------
// ̓
float OrientedBox::getSquaredDistance(const Sphere& sphere) const{
	return OrientedBoxDistance::squaredDistance(*this, sphere);
}
//------------------------------------------------------------------------------
// Op̓
float OrientedBox::getSquaredDistance(const Triangle& triangle) const{
	return OrientedBoxDistance::squaredDistance(*this, triangle);
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// _
bool OrientedBox::intersect(const Vector3& point) const{
	return OrientedBoxIntersection::intersect(*this, point);
}
//------------------------------------------------------------------------------
// {bNX
bool OrientedBox::intersect(const AxisAlignedBox& axisAlignedBox) const{
	return AxisAlignedBoxIntersection::intersect(axisAlignedBox, *this);
}
//------------------------------------------------------------------------------
// JvZ
bool OrientedBox::intersect(const Capsule& capsule) const{
	return CapsuleIntersection::intersect(capsule, *this);
}
//------------------------------------------------------------------------------
// R[
bool OrientedBox::intersect(const Cone& cone) const{
	return ConeIntersection::intersect(cone, *this);
}
//------------------------------------------------------------------------------
// C
bool OrientedBox::intersect(const Line& line) const{
	return LineIntersection::intersect(line, *this);
}
//------------------------------------------------------------------------------
// w{bNX
bool OrientedBox::intersect(const OrientedBox& orientedBox) const{
	return OrientedBoxIntersection::intersect(*this, orientedBox);
}
//------------------------------------------------------------------------------
// ʌ
bool OrientedBox::intersect(const Plane& plane) const{
	return OrientedBoxIntersection::intersect(*this, plane);
}
//------------------------------------------------------------------------------
// C
bool OrientedBox::intersect(const Ray& ray) const{
	return OrientedBoxIntersection::intersect(*this, ray);
}
//------------------------------------------------------------------------------
// ZOg
bool OrientedBox::intersect(const Segment& segment) const{
	return OrientedBoxIntersection::intersect(*this, segment);
}
//------------------------------------------------------------------------------
// 
bool OrientedBox::intersect(const Sphere& sphere) const{
	return OrientedBoxIntersection::intersect(*this, sphere);
}
//------------------------------------------------------------------------------
// Op
bool OrientedBox::intersect(const Triangle& triangle) const{
	return OrientedBoxIntersection::intersect(*this, triangle);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
