//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * C
 * @author Junpee
 */

#include "LampBasic.h"
#include "Geometry/Primitive/Line.h"
#include "Geometry/Distance/AxisAlignedBoxDistance.h"
#include "Geometry/Distance/CapsuleDistance.h"
#include "Geometry/Distance/ConeDistance.h"
#include "Geometry/Distance/LineDistance.h"
#include "Geometry/Intersection/AxisAlignedBoxIntersection.h"
#include "Geometry/Intersection/CapsuleIntersection.h"
#include "Geometry/Intersection/ConeIntersection.h"
#include "Geometry/Intersection/LineIntersection.h"

namespace Lamp{

//------------------------------------------------------------------------------
// 萔
//------------------------------------------------------------------------------
/// [C
const Line Line::zero(0.f, 0.f, 0.f, 0.f, 0.f, 0.f);

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// _̓
float Line::getSquaredDistance(const Vector3& point) const{
	return LineDistance::squaredDistance(*this, point);
}
//------------------------------------------------------------------------------
// {bNX̓
float Line::getSquaredDistance(const AxisAlignedBox& axisAlignedBox) const{
	return AxisAlignedBoxDistance::squaredDistance(axisAlignedBox, *this);
}
//------------------------------------------------------------------------------
// JvZ̓
float Line::getSquaredDistance(const Capsule& capsule) const{
	return CapsuleDistance::squaredDistance(capsule, *this);
}
//------------------------------------------------------------------------------
// R[̓
float Line::getSquaredDistance(const Cone& cone) const{
	return ConeDistance::squaredDistance(cone, *this);
}
//------------------------------------------------------------------------------
// C̓
float Line::getSquaredDistance(const Line& line) const{
	return LineDistance::squaredDistance(*this, line);
}
//------------------------------------------------------------------------------
// w{bNX̓
float Line::getSquaredDistance(const OrientedBox& orientedBox) const{
	return LineDistance::squaredDistance(*this, orientedBox);
}
//------------------------------------------------------------------------------
// ʋ
float Line::getDistance(const Plane& plane) const{
	return LineDistance::distance(*this, plane);
}
//------------------------------------------------------------------------------
// C̓
float Line::getSquaredDistance(const Ray& ray) const{
	return LineDistance::squaredDistance(*this, ray);
}
//------------------------------------------------------------------------------
// ZOg̓
float Line::getSquaredDistance(const Segment& segment) const{
	return LineDistance::squaredDistance(*this, segment);
}
//------------------------------------------------------------------------------
// ̓
float Line::getSquaredDistance(const Sphere& sphere) const{
	return LineDistance::squaredDistance(*this, sphere);
}
//------------------------------------------------------------------------------
// Op̓
float Line::getSquaredDistance(const Triangle& triangle) const{
	return LineDistance::squaredDistance(*this, triangle);
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// _
bool Line::intersect(const Vector3& point, float range) const{
	return LineIntersection::intersect(*this, point, range);
}
//------------------------------------------------------------------------------
// {bNX
bool Line::intersect(const AxisAlignedBox& axisAlignedBox) const{
	return AxisAlignedBoxIntersection::intersect(axisAlignedBox, *this);
}
//------------------------------------------------------------------------------
// JvZ
bool Line::intersect(const Capsule& capsule) const{
	return CapsuleIntersection::intersect(capsule, *this);
}
//------------------------------------------------------------------------------
// R[
bool Line::intersect(const Cone& cone) const{
	return ConeIntersection::intersect(cone, *this);
}
//------------------------------------------------------------------------------
// C
bool Line::intersect(const Line& line, float range) const{
	return LineIntersection::intersect(*this, line, range);
}
//------------------------------------------------------------------------------
// w{bNX
bool Line::intersect(const OrientedBox& orientedBox) const{
	return LineIntersection::intersect(*this, orientedBox);
}
//------------------------------------------------------------------------------
// ʌ
bool Line::intersect(const Plane& plane) const{
	return LineIntersection::intersect(*this, plane);
}
//------------------------------------------------------------------------------
// C
bool Line::intersect(const Ray& ray, float range) const{
	return LineIntersection::intersect(*this, ray, range);
}
//------------------------------------------------------------------------------
// ZOg
bool Line::intersect(const Segment& segment, float range) const{
	return LineIntersection::intersect(*this, segment, range);
}
//------------------------------------------------------------------------------
// 
bool Line::intersect(const Sphere& sphere) const{
	return LineIntersection::intersect(*this, sphere);
}
//------------------------------------------------------------------------------
// Op
bool Line::intersect(const Triangle& triangle) const{
	return LineIntersection::intersect(*this, triangle);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------

