//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * R[
 * @author Junpee
 */

#include "LampBasic.h"
#include "Geometry/Primitive/Cone.h"
#include "Geometry/Distance/AxisAlignedBoxDistance.h"
#include "Geometry/Distance/CapsuleDistance.h"
#include "Geometry/Distance/ConeDistance.h"
#include "Geometry/Intersection/AxisAlignedBoxIntersection.h"
#include "Geometry/Intersection/CapsuleIntersection.h"
#include "Geometry/Intersection/ConeIntersection.h"

namespace Lamp{

//------------------------------------------------------------------------------
// 萔
//------------------------------------------------------------------------------
/// [R[
const Cone Cone::zero(0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f);

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// _̓
float Cone::getSquaredDistance(const Vector3& point) const{
	return ConeDistance::squaredDistance(*this, point);
}
//------------------------------------------------------------------------------
// {bNX̓
float Cone::getSquaredDistance(const AxisAlignedBox& axisAlignedBox) const{
	return AxisAlignedBoxDistance::squaredDistance(axisAlignedBox, *this);
}
//------------------------------------------------------------------------------
// JvZ̓
float Cone::getSquaredDistance(const Capsule& capsule) const{
	return CapsuleDistance::squaredDistance(capsule, *this);
}
//------------------------------------------------------------------------------
// R[̓
float Cone::getSquaredDistance(const Cone& cone) const{
	return ConeDistance::squaredDistance(*this, cone);
}
//------------------------------------------------------------------------------
// C̓
float Cone::getSquaredDistance(const Line& line) const{
	return ConeDistance::squaredDistance(*this, line);
}
//------------------------------------------------------------------------------
// w{bNX̓
float Cone::getSquaredDistance(const OrientedBox& orientedBox) const{
	return ConeDistance::squaredDistance(*this, orientedBox);
}
//------------------------------------------------------------------------------
// ʋ
float Cone::getDistance(const Plane& plane) const{
	return ConeDistance::distance(*this, plane);
}
//------------------------------------------------------------------------------
// C̓
float Cone::getSquaredDistance(const Ray& ray) const{
	return ConeDistance::squaredDistance(*this, ray);
}
//------------------------------------------------------------------------------
// ZOg̓
float Cone::getSquaredDistance(const Segment& segment) const{
	return ConeDistance::squaredDistance(*this, segment);
}
//------------------------------------------------------------------------------
// ̓
float Cone::getSquaredDistance(const Sphere& sphere) const{
	return ConeDistance::squaredDistance(*this, sphere);
}
//------------------------------------------------------------------------------
// Op̓
float Cone::getSquaredDistance(const Triangle& triangle) const{
	return ConeDistance::squaredDistance(*this, triangle);
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// _
bool Cone::intersect(const Vector3& point) const{
	return ConeIntersection::intersect(*this, point);
}
//------------------------------------------------------------------------------
// {bNX
bool Cone::intersect(const AxisAlignedBox& axisAlignedBox) const{
	return AxisAlignedBoxIntersection::intersect(axisAlignedBox, *this);
}
//------------------------------------------------------------------------------
// JvZ
bool Cone::intersect(const Capsule& capsule) const{
	return CapsuleIntersection::intersect(capsule, *this);
}
//------------------------------------------------------------------------------
// R[
bool Cone::intersect(const Cone& cone) const{
	return ConeIntersection::intersect(*this, cone);
}
//------------------------------------------------------------------------------
// C
bool Cone::intersect(const Line& line) const{
	return ConeIntersection::intersect(*this, line);
}
//------------------------------------------------------------------------------
// w{bNX
bool Cone::intersect(const OrientedBox& orientedBox) const{
	return ConeIntersection::intersect(*this, orientedBox);
}
//------------------------------------------------------------------------------
// ʌ
bool Cone::intersect(const Plane& plane) const{
	return ConeIntersection::intersect(*this, plane);
}
//------------------------------------------------------------------------------
// C
bool Cone::intersect(const Ray& ray) const{
	return ConeIntersection::intersect(*this, ray);
}
//------------------------------------------------------------------------------
// ZOg
bool Cone::intersect(const Segment& segment) const{
	return ConeIntersection::intersect(*this, segment);
}
//------------------------------------------------------------------------------
// 
bool Cone::intersect(const Sphere& sphere) const{
	return ConeIntersection::intersect(*this, sphere);
}
//------------------------------------------------------------------------------
// Op
bool Cone::intersect(const Triangle& triangle) const{
	return ConeIntersection::intersect(*this, triangle);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------

