//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * JvZ
 * @author Junpee
 */

#include "LampBasic.h"
#include "Geometry/Primitive/Capsule.h"
#include "Geometry/Distance/AxisAlignedBoxDistance.h"
#include "Geometry/Distance/CapsuleDistance.h"
#include "Geometry/Intersection/AxisAlignedBoxIntersection.h"
#include "Geometry/Intersection/CapsuleIntersection.h"

namespace Lamp{

//------------------------------------------------------------------------------
// 萔
//------------------------------------------------------------------------------
/// [JvZ
const Capsule Capsule::zero(0.f, 0.f, 0.f, 0.f, 0.f, 0.f, 0.f);

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// _̓
float Capsule::getSquaredDistance(const Vector3& point) const{
	return CapsuleDistance::squaredDistance(*this, point);
}
//------------------------------------------------------------------------------
// {bNX̓
float Capsule::getSquaredDistance(const AxisAlignedBox& axisAlignedBox) const{
	return AxisAlignedBoxDistance::squaredDistance(axisAlignedBox, *this);
}
//------------------------------------------------------------------------------
// JvZ̓
float Capsule::getSquaredDistance(const Capsule& capsule) const{
	return CapsuleDistance::squaredDistance(*this, capsule);
}
//------------------------------------------------------------------------------
// R[̓
float Capsule::getSquaredDistance(const Cone& cone) const{
	return CapsuleDistance::squaredDistance(*this, cone);
}
//------------------------------------------------------------------------------
// C̓
float Capsule::getSquaredDistance(const Line& line) const{
	return CapsuleDistance::squaredDistance(*this, line);
}
//------------------------------------------------------------------------------
// w{bNX̓
float Capsule::getSquaredDistance(const OrientedBox& orientedBox) const{
	return CapsuleDistance::squaredDistance(*this, orientedBox);
}
//------------------------------------------------------------------------------
// ʋ
float Capsule::getDistance(const Plane& plane) const{
	return CapsuleDistance::distance(*this, plane);
}
//------------------------------------------------------------------------------
// C̓
float Capsule::getSquaredDistance(const Ray& ray) const{
	return CapsuleDistance::squaredDistance(*this, ray);
}
//------------------------------------------------------------------------------
// ZOg̓
float Capsule::getSquaredDistance(const Segment& segment) const{
	return CapsuleDistance::squaredDistance(*this, segment);
}
//------------------------------------------------------------------------------
// ̓
float Capsule::getSquaredDistance(const Sphere& sphere) const{
	return CapsuleDistance::squaredDistance(*this, sphere);
}
//------------------------------------------------------------------------------
// Op̓
float Capsule::getSquaredDistance(const Triangle& triangle) const{
	return CapsuleDistance::squaredDistance(*this, triangle);
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// _
bool Capsule::intersect(const Vector3& point) const{
	return CapsuleIntersection::intersect(*this, point);
}
//------------------------------------------------------------------------------
// {bNX
bool Capsule::intersect(const AxisAlignedBox& axisAlignedBox) const{
	return AxisAlignedBoxIntersection::intersect(axisAlignedBox, *this);
}
//------------------------------------------------------------------------------
// JvZ
bool Capsule::intersect(const Capsule& capsule) const{
	return CapsuleIntersection::intersect(*this, capsule);
}
//------------------------------------------------------------------------------
// R[
bool Capsule::intersect(const Cone& cone) const{
	return CapsuleIntersection::intersect(*this, cone);
}
//------------------------------------------------------------------------------
// C
bool Capsule::intersect(const Line& line) const{
	return CapsuleIntersection::intersect(*this, line);
}
//------------------------------------------------------------------------------
// w{bNX
bool Capsule::intersect(const OrientedBox& orientedBox) const{
	return CapsuleIntersection::intersect(*this, orientedBox);
}
//------------------------------------------------------------------------------
// ʌ
bool Capsule::intersect(const Plane& plane) const{
	return CapsuleIntersection::intersect(*this, plane);
}
//------------------------------------------------------------------------------
// C
bool Capsule::intersect(const Ray& ray) const{
	return CapsuleIntersection::intersect(*this, ray);
}
//------------------------------------------------------------------------------
// ZOg
bool Capsule::intersect(const Segment& segment) const{
	return CapsuleIntersection::intersect(*this, segment);
}
//------------------------------------------------------------------------------
// 
bool Capsule::intersect(const Sphere& sphere) const{
	return CapsuleIntersection::intersect(*this, sphere);
}
//------------------------------------------------------------------------------
// Op
bool Capsule::intersect(const Triangle& triangle) const{
	return CapsuleIntersection::intersect(*this, triangle);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------

