//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * {bNX
 * @author Junpee
 */

#include "LampBasic.h"
#include "Geometry/Primitive/AxisAlignedBox.h"
#include "Geometry/Distance/AxisAlignedBoxDistance.h"
#include "Geometry/Intersection/AxisAlignedBoxIntersection.h"

namespace Lamp{

//------------------------------------------------------------------------------
// 萔
//------------------------------------------------------------------------------
// [{bNX
const AxisAlignedBox AxisAlignedBox::zero(0.f, 0.f, 0.f, 0.f, 0.f, 0.f);

// Pʃ{bNX
const AxisAlignedBox AxisAlignedBox::unit(
	-0.5f, -0.5f, -0.5f, 0.5f, 0.5f, 0.5f);

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// _̓
float AxisAlignedBox::getSquaredDistance(const Vector3& point) const{
	return AxisAlignedBoxDistance::squaredDistance(*this, point);
}
//------------------------------------------------------------------------------
// {bNX̓
float AxisAlignedBox::getSquaredDistance(
	const AxisAlignedBox& axisAlignedBox) const{
	return AxisAlignedBoxDistance::squaredDistance(*this, axisAlignedBox);
}
//------------------------------------------------------------------------------
// JvZ̓
float AxisAlignedBox::getSquaredDistance(const Capsule& capsule) const{
	return AxisAlignedBoxDistance::squaredDistance(*this, capsule);
}
//------------------------------------------------------------------------------
// R[̓
float AxisAlignedBox::getSquaredDistance(const Cone& cone) const{
	return AxisAlignedBoxDistance::squaredDistance(*this, cone);
}
//------------------------------------------------------------------------------
// C̓
float AxisAlignedBox::getSquaredDistance(const Line& line) const{
	return AxisAlignedBoxDistance::squaredDistance(*this, line);
}
//------------------------------------------------------------------------------
// w{bNX̓
float AxisAlignedBox::getSquaredDistance(const OrientedBox& orientedBox) const{
	return AxisAlignedBoxDistance::squaredDistance(*this, orientedBox);
}
//------------------------------------------------------------------------------
// ʋ
float AxisAlignedBox::getDistance(const Plane& plane) const{
	return AxisAlignedBoxDistance::distance(*this, plane);
}
//------------------------------------------------------------------------------
// C̓
float AxisAlignedBox::getSquaredDistance(const Ray& ray) const{
	return AxisAlignedBoxDistance::squaredDistance(*this, ray);
}
//------------------------------------------------------------------------------
// ZOg̓
float AxisAlignedBox::getSquaredDistance(const Segment& segment) const{
	return AxisAlignedBoxDistance::squaredDistance(*this, segment);
}
//------------------------------------------------------------------------------
// ̓
float AxisAlignedBox::getSquaredDistance(const Sphere& sphere) const{
	return AxisAlignedBoxDistance::squaredDistance(*this, sphere);
}
//------------------------------------------------------------------------------
// Op̓
float AxisAlignedBox::getSquaredDistance(const Triangle& triangle) const{
	return AxisAlignedBoxDistance::squaredDistance(*this, triangle);
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// _
bool AxisAlignedBox::intersect(const Vector3& point) const{
	return AxisAlignedBoxIntersection::intersect(*this, point);
}
//------------------------------------------------------------------------------
// {bNX
bool AxisAlignedBox::intersect(const AxisAlignedBox& axisAlignedBox) const{
	return AxisAlignedBoxIntersection::intersect(*this, axisAlignedBox);
}
//------------------------------------------------------------------------------
// JvZ
bool AxisAlignedBox::intersect(const Capsule& capsule) const{
	return AxisAlignedBoxIntersection::intersect(*this, capsule);
}
//------------------------------------------------------------------------------
// R[
bool AxisAlignedBox::intersect(const Cone& cone) const{
	return AxisAlignedBoxIntersection::intersect(*this, cone);
}
//------------------------------------------------------------------------------
// C
bool AxisAlignedBox::intersect(const Line& line) const{
	return AxisAlignedBoxIntersection::intersect(*this, line);
}
//------------------------------------------------------------------------------
// w{bNX
bool AxisAlignedBox::intersect(const OrientedBox& orientedBox) const{
	return AxisAlignedBoxIntersection::intersect(*this, orientedBox);
}
//------------------------------------------------------------------------------
// ʌ
bool AxisAlignedBox::intersect(const Plane& plane) const{
	return AxisAlignedBoxIntersection::intersect(*this, plane);
}
//------------------------------------------------------------------------------
// C
bool AxisAlignedBox::intersect(const Ray& ray) const{
	return AxisAlignedBoxIntersection::intersect(*this, ray);
}
//------------------------------------------------------------------------------
// ZOg
bool AxisAlignedBox::intersect(const Segment& segment) const{
	return AxisAlignedBoxIntersection::intersect(*this, segment);
}
//------------------------------------------------------------------------------
// 
bool AxisAlignedBox::intersect(const Sphere& sphere) const{
	return AxisAlignedBoxIntersection::intersect(*this, sphere);
}
//------------------------------------------------------------------------------
// Op
bool AxisAlignedBox::intersect(const Triangle& triangle) const{
	return AxisAlignedBoxIntersection::intersect(*this, triangle);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
