//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ZOg
 * @author Junpee
 */

#include "LampBasic.h"
#include "Geometry/Intersection/SegmentIntersection.h"

namespace Lamp{

//------------------------------------------------------------------------------
// _
//------------------------------------------------------------------------------
// _
bool SegmentIntersection::intersect(
	const Segment& segment, const Vector3& point, float range){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
// ZOg
//------------------------------------------------------------------------------
// ZOg
bool SegmentIntersection::intersect(
	const Segment& segment0, const Segment& segment1, float range){
	return (segment0.getSquaredDistance(segment1) <= (range * range));
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
bool SegmentIntersection::intersect(const Segment& segment, const Sphere& sphere){
	// SƂ̋aȓȂ
	float squaredDistance = segment.getSquaredDistance(sphere.getCenter());
	float radius = sphere.getRadius();
	return (squaredDistance <= (radius * radius));
}
//------------------------------------------------------------------------------
// Op
//------------------------------------------------------------------------------
// Op
bool SegmentIntersection::intersect(
	const Segment& segment, const Triangle& triangle){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
