//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * C
 * @author Junpee
 */

#include "LampBasic.h"
#include "Geometry/Intersection/RayIntersection.h"

namespace Lamp{

//------------------------------------------------------------------------------
// _
//------------------------------------------------------------------------------
// _
bool RayIntersection::intersect(
	const Ray& ray, const Vector3& point, float range){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
// C
//------------------------------------------------------------------------------
// C
bool RayIntersection::intersect(const Ray& ray0, const Ray& ray1, float range){
	return (ray0.getSquaredDistance(ray1) <= (range * range));
}
//------------------------------------------------------------------------------
// ZOg
//------------------------------------------------------------------------------
// ZOg
bool RayIntersection::intersect(
	const Ray& ray, const Segment& segment, float range){
	return (ray.getSquaredDistance(segment) <= (range * range));
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
bool RayIntersection::intersect(const Ray& ray, const Sphere& sphere){
	// SƂ̋aȓȂ
	float squaredDistance = ray.getSquaredDistance(sphere.getCenter());
	float radius = sphere.getRadius();
	return (squaredDistance <= (radius * radius));
}
//------------------------------------------------------------------------------
// Op
//------------------------------------------------------------------------------
// Op
bool RayIntersection::intersect(const Ray& ray, const Triangle& triangle){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
