//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ʌ
 * @author Junpee
 */

#include "LampBasic.h"
#include "Geometry/Intersection/PlaneIntersection.h"

namespace Lamp{

//------------------------------------------------------------------------------
// _
//------------------------------------------------------------------------------
// _
bool PlaneIntersection::intersect(
	const Plane& plane, const Vector3& point, float range){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// ʌ
bool PlaneIntersection::intersect(const Plane& plane0, const Plane& plane1){
	// ʂsłȂΌĂ
	Vector3 cross = plane0.getNormal().crossProduct(plane1.getNormal());
	return (cross.getSquaredLength() > Math::epsilon);
}
//------------------------------------------------------------------------------
// C
//------------------------------------------------------------------------------
// C
bool PlaneIntersection::intersect(const Plane& plane, const Ray& ray){
	const Vector3& normal = plane.getNormal();
	float denominator = ray.getDirection().dotProduct(normal);
	float distance = plane.getDistance(ray.getOrigin());
	if(Math::abs(denominator) <= Math::epsilon){
		// ʂɕsȃC͌_ʂɐڂĂΌ
		return (Math::abs(distance) <= Math::epsilon);
	}
	float t = ((-distance) / denominator);
	// t0ȏȂ
	return (t >= 0.f);
}
//------------------------------------------------------------------------------
// ZOg
//------------------------------------------------------------------------------
// ZOg
bool PlaneIntersection::intersect(const Plane& plane, const Segment& segment){
	const Vector3& normal = plane.getNormal();
	float denominator = segment.getDirection().dotProduct(normal);
	float distance = plane.getDistance(segment.getOrigin());
	if(Math::abs(denominator) <= Math::epsilon){
		// ʂɕsȃZOg͌_ʂɐڂĂΌ
		return (Math::abs(distance) <= Math::epsilon);
	}
	float t = ((-distance) / denominator);
	// t0ȏ1ȉȂ
	return ((t >= 0.f) && (t <= 1.f));
}
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
bool PlaneIntersection::intersect(const Plane& plane, const Sphere& sphere){
	// ʂƋ̋aȓȂ
	float distance = plane.getDistance(sphere.getCenter());
	return (Math::abs(distance) <= sphere.getRadius());
}
//------------------------------------------------------------------------------
// Op
//------------------------------------------------------------------------------
// Op
bool PlaneIntersection::intersect(const Plane& plane, const Triangle& triangle){
	Assert(false);
	return false;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
